/**
 * @file PreparingSetupState.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _PREPARING_SETUP_STATE_H
#define _PREPARING_SETUP_STATE_H

#include <boost/shared_ptr.hpp>

#include "asf/core/Logger.h"

#include "WBLTypes.h"
#include "WBLMessageTypes.h"
#include "StateMachineTypes.h"
#include "WifiSetupState.h"

namespace org
{
namespace bosch
{

// forward declarations
class IEEE80211APClientIf;
class IEEE80211STAClientIf;

class PreparingSetupState final: public WifiSetupState
{
public:

   explicit PreparingSetupState(IWifiSetupSM* wifiSetupSMIf);
   virtual ~PreparingSetupState();

   //! Override WifiSetupState interfaces
   virtual void onEntry(::boost::shared_ptr< StateMachineMsg > msg) override;
   virtual void onRequest(::boost::shared_ptr< DeActivateSetupMsg > msg) override;
   virtual void onEvent(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError) override;

private:

   PreparingSetupSubstate getSubState() const;
   void setSubState(PreparingSetupSubstate subState);
   void switchToNextSubState();
   bool isSubstateEntryRequired(PreparingSetupSubstate subState);

   void onEntryIdleState();
   void onEntryResolvingLimState();
   void onEntryConfigFrequencyState();
   void onEntryConfigChannelsState();
   void onEntryConfigSSIDState();
   void onEntryConfigPassphraseState();
   void onEntryConfigSecurityState();
   void onEntryConfigVisibilityState();
   void onEntryConfigTetheringState();
   void onEntryConfigNetworkTypeState();
   void onEntryConfigMaxStaState();
   void onEntryPoweringOnState();
   void onEntryInitiateConfigs();

   void handleResolvingLimState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleIntitateConfigurationState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleConfigFrequencyState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleConfigChannelsState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleConfigSSIDState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleConfigPassphraseState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleConfigSecurityState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleConfigVisibilityState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleConfigTetheringState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleConfigMaxStaState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handlePoweringOnState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleConfigNetworkTypeState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);

   bool isFrequencyChangeRequired() const;
   bool isChannelChangeRequired() const;
   bool isChannelUpdateRequired(ChannelList& channels) const;
   bool isSSIDChangeRequired() const;
   bool isPassphraseChangeRequired() const;
   bool isSecurityChangeRequired() const;
   bool isVisibilityChangeRequired() const;
   bool isTetheringChangeRequired() const;
   bool isNetworkTypeChangeRequired() const;
   bool isMaxStationChangeRequired() const;
   bool isInterfacePoweredOff() const;
   bool isActionActivate() const;

   void resolveLimitations();

   bool isRequestValid(::boost::shared_ptr< PrepareSetupMsg > msg) const;

   int isValidChannel(uint16 channel) const;
   int isCPWCertifiedChannel(uint16 channel,WBLFrequencyBand& requestedFrequency) const;
   void getCarPlayChannels(ChannelList& channels,WBLFrequencyBand& requestedFrequency) const;
   void getRequestedChannels(ChannelList& channels) const;
   void getChannelsInRequestedFreq(WBLFrequencyBand frequency,ChannelList& channels) const;

   void onInterfaceRemoved(WifiMode removedWifiMode);
   void sendPrepareSetupResult(SMErrorCode errorCode);

   bool isCarplayRequest();
   bool isAAWRequest();
   void getUniqueSSID(const ::std::string ssid);
   bool isSTAPoweredON();
   bool isAPPoweredON();
   bool isMultiRoleLimitation();
   bool isStationSlotFull();
   bool resolveByStationDeauthentication();
   void updatePoweredSetting(WifiSetUpItem& setup);
   void resolveByDeactivation(WifiMode mode);

   PreparingSetupSubstate _subState;
   WifiSetUpItem _activeWifiSetup;
   APConfig _requestedAPConfig;
   WBLActionType _requestedAction;
   bool _isChannelChangeOngoing;
   bool _abortSetup;

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_PREPARING_SETUP_STATE_H

/** @} */
