/**
 * @file DeactivatingSetupState.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _DEACTIVATING_SETUP_STATE_H
#define _DEACTIVATING_SETUP_STATE_H

#include <boost/shared_ptr.hpp>

#include "asf/core/Logger.h"

#include "WBLMessageTypes.h"
#include "WifiSetupState.h"

namespace org
{
namespace bosch
{

// forward declarations

class DeactivatingSetupState final: public WifiSetupState
{
public:

   explicit DeactivatingSetupState(IWifiSetupSM* wifiSetupSMIf);
   virtual ~DeactivatingSetupState();

   //! Override WifiSetupState interfaces
   virtual void onEntry(::boost::shared_ptr< StateMachineMsg > msg) override;
   virtual void onEvent(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError) override;

private:

   bool sendPowerOffRequest();
   void onDeactivateSetupSuccess(const WifiSetUpItem& setup);

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_DEACTIVATING_SETUP_STATE_H

/** @} */
