/**
 * @file IWifiSetupSM.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _I_WIFI_SETUP_SM_H
#define _I_WIFI_SETUP_SM_H

#include <boost/shared_ptr.hpp>

#include "asf/core/Logger.h"

#include "WBLTypes.h"
#include "WBLMessages.h"
#include "StateMachineTypes.h"
#include "StateMachineMsg.h"

namespace org
{
namespace bosch
{

// forward declarations

class IWifiSetupSM
{
public:

   IWifiSetupSM()
   {
   }

   virtual ~IWifiSetupSM()
   {
   }

   virtual WifiMode getWifiMode() const = 0;
   virtual WifiSetupStateType getStateType() const = 0;
   virtual void setState(WifiSetupStateType state, ::boost::shared_ptr< StateMachineMsg > msg) = 0;
   virtual const WifiSetUpItem& getWifiSetupInfo() const = 0;
   virtual const WifiSetUpList& getAllWifiSetups() const = 0;

   virtual ::boost::shared_ptr< PrepareSetupMsg > getPrepareSetupMsg() = 0;
   virtual ::boost::shared_ptr< DeActivateSetupMsg > getDeactivateSetupMsg() = 0;
   virtual ::boost::shared_ptr< DisableSetupMsg > getDisableSetupMsg() = 0;
   virtual ::boost::shared_ptr< RestoreFactorySettingsMsg > getRestoreFactorySettingsMsg() = 0;

   virtual void setPrepareSetupMsg(::boost::shared_ptr< PrepareSetupMsg > msg) = 0;
   virtual void setDeactivateSetupMsg(::boost::shared_ptr< DeActivateSetupMsg > msg) = 0;
   virtual void setDisableSetupMsg(::boost::shared_ptr< DisableSetupMsg > msg) = 0;
   virtual void setRestoreFactorySettingsMsg(::boost::shared_ptr< RestoreFactorySettingsMsg > msg) = 0;

   virtual void sendMsgResponse(::boost::shared_ptr< WBLBaseMsg > msg, WBLErrorCode errorCode) = 0;
   virtual void sendRequest(::boost::shared_ptr< WBLBaseMsg > msg) = 0;

private:

   IWifiSetupSM(const IWifiSetupSM&);
   IWifiSetupSM& operator=(const IWifiSetupSM&);

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_I_WIFI_SETUP_SM_H

/** @} */
