/**
 * @file IRespWifiSetupControllerSM.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _I_RESP_WIFI_SETUP_CONTROLLER_SM_H
#define _I_RESP_WIFI_SETUP_CONTROLLER_SM_H

#include <boost/shared_ptr.hpp>

#include "WBLTypes.h"
#include "WBLBaseMsg.h"
#include "WBLMessageTypes.h"

namespace org
{
namespace bosch
{

class IRespWifiSetupControllerSM
{
public:

   IRespWifiSetupControllerSM()
   {
   }

   virtual ~IRespWifiSetupControllerSM()
   {
   }

   virtual void sendMsgResponse(::boost::shared_ptr< WBLBaseMsg > msg, WBLErrorCode errorCode) = 0;
   virtual void sendRequest(::boost::shared_ptr< WBLBaseMsg > msg) = 0;
   virtual const WifiSetUpList& getAllWifiSetups() const = 0;

private:

   IRespWifiSetupControllerSM(const IRespWifiSetupControllerSM&);
   IRespWifiSetupControllerSM& operator=(const IRespWifiSetupControllerSM&);

};

} // namespace bosch
} // namespace org

#endif //_I_RESP_WIFI_SETUP_CONTROLLER_SM_H

/** @} */
