/**
 * @file ICmdWifiSetupControllerSM.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _I_CMD_WIFI_SETUP_CONTROLLER_SM_H
#define _I_CMD_WIFI_SETUP_CONTROLLER_SM_H

#include <boost/shared_ptr.hpp>

#include "WBLBaseMsg.h"
#include "WBLMessages.h"
#include "WBLMessageTypes.h"
#include "StateMachineTypes.h"

namespace org
{
namespace bosch
{

class ICmdWifiSetupControllerSM
{
public:

   ICmdWifiSetupControllerSM()
   {
   }

   virtual ~ICmdWifiSetupControllerSM()
   {
   }

   virtual void onRequest(::boost::shared_ptr< PrepareSetupMsg > msg) = 0;
   virtual void onRequest(::boost::shared_ptr< DeActivateSetupMsg > msg) = 0;
   virtual void onRequest(::boost::shared_ptr< DisableSetupMsg > msg) = 0;
   virtual void onRequest(::boost::shared_ptr< RestoreFactorySettingsMsg > msg) = 0;
   virtual void onEvent(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError) = 0;
   virtual bool isSMBusy() const = 0;

private:

   ICmdWifiSetupControllerSM(const ICmdWifiSetupControllerSM&);
   ICmdWifiSetupControllerSM& operator=(const ICmdWifiSetupControllerSM&);

};

} // namespace bosch
} // namespace org

#endif //_I_CMD_WIFI_SETUP_CONTROLLER_SM_H

/** @} */
