/**
 * @file ConflictManagerFactory.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 *
 * @brief
 *
 * @{
 */

#include "WBLDefines.h"
#include "ConflictManagerFactory.h"

namespace org
{
namespace bosch
{

DEFINE_CLASS_LOGGER_AND_LEVEL("wifi_business_logic/ConflictMgr", ConflictManagerFactory, Info);

ConflictManagerFactory::ConflictManagerFactory() :
      _poConflictMgr(nullptr),
      _poConflictResolver(nullptr)
{
   _poConflictMgr = new IEEE80211ConflictManager;
   WBL_ASSERT(nullptr == _poConflictMgr);

   _poConflictResolver = new ConflictResolver;
   WBL_ASSERT(nullptr == _poConflictResolver);
}

ConflictManagerFactory::~ConflictManagerFactory()
{
   RELEASE_MEM(_poConflictMgr);
   RELEASE_MEM(_poConflictResolver);
}

ICmdConflictManager* ConflictManagerFactory::getConflictManagerRequestIf()
{
   return _poConflictMgr;
}

ICmdConflictResolver* ConflictManagerFactory::getConflictResolverIf()
{
   return _poConflictResolver;
}

} // namespace bosch
} // namespace org

/** @} */
