/**
 * @file WBLBaseMsg.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include "WBLBaseMsg.h"

namespace org
{
namespace bosch
{

WBLBaseMsg::WBLBaseMsg(WBLBaseMsgID msgID) :
      _msgID(msgID),
      _errCode(WBL_ERR_UNKNOWN),
      _actToken(0)
{
}

WBLBaseMsg::~WBLBaseMsg()
{
   _msgID = WBL_MSG_UNKNOWN;
   _errCode = WBL_ERR_UNKNOWN;
   _actToken = 0;
}

WBLBaseMsg::WBLBaseMsg(const WBLBaseMsg& ref)
{
   *this = ref;
}

bool WBLBaseMsg::operator==(const WBLBaseMsg& ref)
{
   return ((_msgID == ref._msgID) &&
         (_errCode == ref._errCode) &&
         (_actToken == ref._actToken));
}

WBLBaseMsg& WBLBaseMsg::operator=(const WBLBaseMsg& ref)
{
   if (this == &ref)
   {
      return *this;
   }
   this->_msgID = ref._msgID;
   this->_actToken = ref._actToken;
   this->_errCode = ref._errCode;

   return *this;
}
void WBLBaseMsg::setMsgID(WBLBaseMsgID msgID)
{
   _msgID = msgID;
}

WBLBaseMsgID WBLBaseMsg::getMsgID() const
{
   return _msgID;
}

void WBLBaseMsg::setMsgToken(const uint32 actToken)
{
   _actToken = actToken;
}

uint32 WBLBaseMsg::getMsgToken() const
{
   return _actToken;
}

void WBLBaseMsg::setErrorCode(const WBLErrorCode errCode)
{
   _errCode = errCode;
}

WBLErrorCode WBLBaseMsg::getErrorCode() const
{
   return _errCode;
}

} //namespace bosch
} //namespace org

/** @} */
