/**
 * @file DbusIfTypes.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include "DbusIfTypes.h"
#include <cstring>
#include <cstdio>
#include <stdint.h> // using <cstdint> compiler complains that std=c++0x or -std=gnu++0x compiler option must be enabled

namespace org 
{
namespace bosch 
{

DbusIntVariant::DbusIntVariant():
      _int8Data(0),_uint8Data(0),_int16Data(0),
      _uint16Data(0),_int32Data(0),_uint32Data(0),
      _int64Data(0),_uint64Data(0),_enumData(0),
      _boolData(false),_empty(true)
{
}

DbusIntVariant::DbusIntVariant(const DbusIntVariant& ref):
   _int8Data(ref._int8Data),
   _uint8Data(ref._uint8Data),
   _int16Data(ref._int16Data),
   _uint16Data(ref._uint16Data),
   _int32Data(ref._int32Data),
   _uint32Data(ref._uint32Data),
   _int64Data(ref._int64Data),
   _uint64Data(ref._uint64Data),
   _enumData(ref._enumData),
   _boolData(ref._boolData),
   _empty(ref._empty)
{
}

DbusIntVariant& DbusIntVariant::operator=(const DbusIntVariant& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   _int8Data = ref._int8Data;
   _uint8Data = ref._uint8Data;
   _int16Data = ref._int16Data;
   _uint16Data = ref._uint16Data;
   _int32Data = ref._int32Data;
   _uint32Data = ref._uint32Data;
   _int64Data = ref._int64Data;
   _uint64Data = ref._uint64Data;
   _enumData = ref._enumData;
   _boolData = ref._boolData;
   _empty = ref._empty;

   return *this;
}

bool DbusIntVariant::operator==(const DbusIntVariant& ref) const
{
   bool result = true;

   result = (true == result) && (_int8Data == ref._int8Data);
   result = (true == result) && (_uint8Data == ref._uint8Data);
   result = (true == result) && (_int16Data == ref._int16Data);
   result = (true == result) && (_uint16Data == ref._uint16Data);
   result = (true == result) && (_int32Data == ref._int32Data);
   result = (true == result) && (_uint32Data == ref._uint32Data);
   result = (true == result) && (_int64Data == ref._int64Data);
   result = (true == result) && (_uint64Data == ref._uint64Data);
   result = (true == result) && (_enumData == ref._enumData);
   result = (true == result) && (_boolData == ref._boolData);
   result = (true == result) && (_empty == ref._empty);

   return result;
}

bool DbusIntVariant::operator!=(const DbusIntVariant& ref) const
{
   return !(operator==(ref));
}

DbusIntVariant::~DbusIntVariant()
{
}


DbusVariant::DbusVariant()
{
   _type = VARIANT_UNKNOWN;
   // _stringData
   // _stringArray
}

DbusVariant::DbusVariant(const DbusVariant& ref)
{
   _type = ref._type;
   _intData = ref._intData;
   _stringData = ref._stringData;
   _stringArray = ref._stringArray;
   _byteArray = ref._byteArray;
   _integerArray = ref._integerArray;
   _dict = ref._dict;
}

DbusVariant& DbusVariant::operator=(const DbusVariant& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   _type = ref._type;
   _intData = ref._intData;
   _stringData = ref._stringData;
   _stringArray = ref._stringArray;
   _byteArray = ref._byteArray;
   _integerArray = ref._integerArray;
   _dict = ref._dict;

   return *this;
}

bool DbusVariant::operator==(const DbusVariant& ref) const
{
   bool result = true;

   result = (true == result) && (_type == ref._type);
   result = (true == result) && (_intData == ref._intData);
   result = (true == result) && (_stringData == ref._stringData);
   result = (true == result) && (_stringArray == ref._stringArray);
   result = (true == result) && (_byteArray == ref._byteArray);
   result = (true == result) && (_integerArray == ref._integerArray);
   result = (true == result) && (_dict == ref._dict);

   return result;
}

bool DbusVariant::operator!=(const DbusVariant& ref) const
{
   return !(operator==(ref));
}

DbusVariant::~DbusVariant()
{
}

int8_t DbusVariant::getInt8(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_INT8 == _type);
   return _intData._int8Data;
}

uint8_t DbusVariant::getUInt8(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_UINT8 == _type);
   return _intData._uint8Data;
}

int16_t DbusVariant::getInt16(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_INT16 == _type);
   return _intData._int16Data;
}

uint16_t DbusVariant::getUInt16(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_UINT16 == _type);
   return _intData._uint16Data;
}

int32_t DbusVariant::getInt32(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_INT32 == _type);
   return _intData._int32Data;
}

uint32_t DbusVariant::getUInt32(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_UINT32 == _type);
   return _intData._uint32Data;
}

int64_t DbusVariant::getInt64(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_INT64 == _type);
   return _intData._int64Data;
}

uint64_t DbusVariant::getUInt64(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_UINT64 == _type);
   return _intData._uint64Data;
}

bool DbusVariant::getBool(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_BOOL == _type);
   return _intData._boolData;
}

int DbusVariant::getEnum(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_ENUM == _type);
   return _intData._enumData;
}

const ::std::string& DbusVariant::getString(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_STRING == _type);
   return _stringData;
}

const ::std::vector< ::std::string >& DbusVariant::getStringArray(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_STRING_ARRAY == _type);
   return _stringArray;
}

bool DbusVariant::getNone(void) const
{
   // no assert here because this check can be done every time
   return _intData._empty;
}

void DbusVariant::reset(void)
{
   _type = VARIANT_UNKNOWN;
   DbusIntVariant intVariant;
   _intData = intVariant;
   _stringData.clear();
   _stringArray.clear();
   _byteArray.clear();
   _integerArray.clear();
   _dict.clear();
}

const ::std::vector<uint8_t>& DbusVariant::getByteArray(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_STRING_ARRAY == _type);
   return _byteArray;
}

const ::std::vector<uint16_t>& DbusVariant::getUInt16Array(void) const
{
   //FW_NORMAL_ASSERT(VARIANT_UINT16_ARRAY == _type);
   return _integerArray;
}
::std::map < ::std::string, int8_t > DbusVariant::getString2Int8Dict(void) const
{
   ::std::map < ::std::string, int8_t > dict;
   typedef ::std::map < ::std::string, DbusIntVariant >::const_iterator tDictItr;
   for (tDictItr itr = _dict.begin(); itr != _dict.end(); ++itr)
   {
      dict.insert(std::pair< ::std::string, int8_t >(itr->first, (itr->second)._int8Data));
   }
   return dict;
}

::std::map < ::std::string, uint8_t > DbusVariant::getString2UInt8Dict(void) const
{
   ::std::map < ::std::string, uint8_t > dict;
   typedef ::std::map < ::std::string, DbusIntVariant >::const_iterator tDictItr;
   for (tDictItr itr = _dict.begin(); itr != _dict.end(); ++itr)
   {
      dict.insert(std::pair< ::std::string, uint8_t >(itr->first, (itr->second)._uint8Data));
   }
   return dict;
}

::std::map < ::std::string, int16_t > DbusVariant::getString2Int16Dict(void) const
{
   ::std::map < ::std::string, int16_t > dict;
   typedef ::std::map < ::std::string, DbusIntVariant >::const_iterator tDictItr;
   for (tDictItr itr = _dict.begin(); itr != _dict.end(); ++itr)
   {
      dict.insert(std::pair< ::std::string, int16_t >(itr->first, (itr->second)._int16Data));
   }
   return dict;
}

::std::map < ::std::string, uint16_t > DbusVariant::getString2UInt16Dict(void) const
{
   ::std::map < ::std::string, uint16_t > dict;
   typedef ::std::map < ::std::string, DbusIntVariant >::const_iterator tDictItr;
   for (tDictItr itr = _dict.begin(); itr != _dict.end(); ++itr)
   {
      dict.insert(std::pair< ::std::string, uint16_t >(itr->first, (itr->second)._uint16Data));
   }
   return dict;
}

::std::map < ::std::string, int32_t > DbusVariant::getString2Int32Dict(void) const
{
   ::std::map < ::std::string, int32_t > dict;
   typedef ::std::map < ::std::string, DbusIntVariant >::const_iterator tDictItr;
   for (tDictItr itr = _dict.begin(); itr != _dict.end(); ++itr)
   {
      dict.insert(std::pair< ::std::string, int32_t >(itr->first, (itr->second)._int32Data));
   }
   return dict;
}


::std::map < ::std::string, uint32_t > DbusVariant::getString2UInt32Dict(void) const
{
   ::std::map < ::std::string, uint32_t > dict;
   typedef ::std::map < ::std::string, DbusIntVariant >::const_iterator tDictItr;
   for (tDictItr itr = _dict.begin(); itr != _dict.end(); ++itr)
   {
      dict.insert(std::pair< ::std::string, uint32_t >(itr->first, (itr->second)._uint32Data));
   }
   return dict;
}

::std::map < ::std::string, int64_t > DbusVariant::getString2Int64Dict(void) const
{
   ::std::map < ::std::string, int64_t > dict;
   typedef ::std::map < ::std::string, DbusIntVariant >::const_iterator tDictItr;
   for (tDictItr itr = _dict.begin(); itr != _dict.end(); ++itr)
   {
      dict.insert(std::pair< ::std::string, int64_t >(itr->first, (itr->second)._int64Data));
   }
   return dict;
}

::std::map < ::std::string, uint64_t > DbusVariant::getString2UInt64Dict(void) const
{
   ::std::map < ::std::string, uint64_t > dict;
   typedef ::std::map < ::std::string, DbusIntVariant >::const_iterator tDictItr;
   for (tDictItr itr = _dict.begin(); itr != _dict.end(); ++itr)
   {
      dict.insert(std::pair< ::std::string, uint64_t >(itr->first, (itr->second)._uint64Data));
   }
   return dict;
}

::std::map < ::std::string, bool > DbusVariant::getString2Bool8Dict(void) const
{
   ::std::map < ::std::string, bool > dict;
   typedef ::std::map < ::std::string, DbusIntVariant >::const_iterator tDictItr;
   for (tDictItr itr = _dict.begin(); itr != _dict.end(); ++itr)
   {
      dict.insert(std::pair< ::std::string, bool >(itr->first, (itr->second)._boolData));
   }
   return dict;
}

//------------------------------------------------------------------------------

DbusVariantProperty::DbusVariantProperty()
{
   propEnum = 0;
   // propData
}

DbusVariantProperty::DbusVariantProperty(const DbusVariantProperty& ref)
{
   propEnum = ref.propEnum;
   propData = ref.propData;
}

DbusVariantProperty& DbusVariantProperty::operator=(const DbusVariantProperty& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   propEnum = ref.propEnum;
   propData = ref.propData;

   return *this;
}

bool DbusVariantProperty::operator==(const DbusVariantProperty& ref) const
{
   bool result = true;

   result = (true == result) && (propEnum == ref.propEnum);
   result = (true == result) && (propData == ref.propData);

   return result;
}

bool DbusVariantProperty::operator!=(const DbusVariantProperty& ref) const
{
   return !(operator==(ref));
}

DbusVariantProperty::~DbusVariantProperty()
{
}

void DbusVariantProperty::reset(void)
{
   propEnum = 0;
   propData.reset();
}

//------------------------------------------------------------------------------

DbusPropertyEntry::DbusPropertyEntry()
{
   propName = nullptr;
   propEnum = 0;
}

DbusPropertyEntry::DbusPropertyEntry(const DbusPropertyEntry& ref)
{
   propName = nullptr;
   setPropName(ref.propName);
   propEnum = ref.propEnum;
}

DbusPropertyEntry& DbusPropertyEntry::operator=(const DbusPropertyEntry& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   propName = nullptr;
   setPropName(ref.propName);
   propEnum = ref.propEnum;

   return *this;
}

bool DbusPropertyEntry::operator==(const DbusPropertyEntry& ref) const
{
   return (0 == compare(ref));
}

bool DbusPropertyEntry::operator!=(const DbusPropertyEntry& ref) const
{
   return (0 != compare(ref));
}

bool DbusPropertyEntry::operator<(const DbusPropertyEntry& ref) const
{
   return (0 > compare(ref));
}

bool DbusPropertyEntry::operator>(const DbusPropertyEntry& ref) const
{
   return (0 < compare(ref));
}

DbusPropertyEntry::~DbusPropertyEntry()
{
   propName = nullptr;
}

int DbusPropertyEntry::compare(const DbusPropertyEntry& ref) const
{
   uintptr_t left = (uintptr_t)propName;
   uintptr_t right = (uintptr_t)ref.propName;

   if(left < right)
   {
      return -1;
   }
   else if(left > right)
   {
      return 1;
   }

   // propName is equal

   if(propEnum < ref.propEnum)
   {
      return -1;
   }
   else if(propEnum > ref.propEnum)
   {
      return 1;
   }

   // propEnum is equal

   return 0;
}

//------------------------------------------------------------------------------

DbusInterfaceEntry::DbusInterfaceEntry()
{
   interfaceName = nullptr;
   interfaceEnum = 0;
   propertyList = nullptr;
}

DbusInterfaceEntry::DbusInterfaceEntry(const DbusInterfaceEntry& ref)
{
   interfaceName = nullptr;
   setInterfaceName(ref.interfaceName);
   interfaceEnum = ref.interfaceEnum;
   propertyList = nullptr;
   setPropertyList(ref.propertyList);
}

DbusInterfaceEntry& DbusInterfaceEntry::operator=(const DbusInterfaceEntry& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   interfaceName = nullptr;
   setInterfaceName(ref.interfaceName);
   interfaceEnum = ref.interfaceEnum;
   propertyList = nullptr;
   setPropertyList(ref.propertyList);

   return *this;
}

bool DbusInterfaceEntry::operator==(const DbusInterfaceEntry& ref) const
{
   return (0 == compare(ref));
}

bool DbusInterfaceEntry::operator!=(const DbusInterfaceEntry& ref) const
{
   return (0 != compare(ref));
}

bool DbusInterfaceEntry::operator<(const DbusInterfaceEntry& ref) const
{
   return (0 > compare(ref));
}

bool DbusInterfaceEntry::operator>(const DbusInterfaceEntry& ref) const
{
   return (0 < compare(ref));
}

DbusInterfaceEntry::~DbusInterfaceEntry()
{
   interfaceName = nullptr;
   propertyList = nullptr;
}

int DbusInterfaceEntry::compare(const DbusInterfaceEntry& ref) const
{
   uintptr_t left = (uintptr_t)interfaceName;
   uintptr_t right = (uintptr_t)ref.interfaceName;

   if(left < right)
   {
      return -1;
   }
   else if(left > right)
   {
      return 1;
   }

   // interfaceName is equal

   if(interfaceEnum < ref.interfaceEnum)
   {
      return -1;
   }
   else if(interfaceEnum > ref.interfaceEnum)
   {
      return 1;
   }

   // interfaceEnum is equal

   left = (uintptr_t)propertyList;
   right = (uintptr_t)ref.propertyList;

   if(left < right)
   {
      return -1;
   }
   else if(left > right)
   {
      return 1;
   }

   // propertyList id is equal

   return 0;
}

//------------------------------------------------------------------------------

} //namespace bosch
} //namespace org

/** @} */
