/**
 * @file WBLTypeProperties.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WBL_TYPE_PROPERTIES_H
#define _WBL_TYPE_PROPERTIES_H

#include <string>

#include "DbusProperties.h"
#include "WBLTypes.h"

namespace org
{
namespace bosch
{

class WBLWifiModeProperty: public DbusProperties
{
   public:
      WBLWifiModeProperty();
      virtual ~WBLWifiModeProperty();

      WifiMode getWifiMode2Enum(const ::std::string& value) const;
      const ::std::string& getWifiMode2String(const WifiMode value) const;

   private:
      const ::std::string _modeAP;
      const ::std::string _modeSTA;
      const ::std::string _modeP2P;
      const ::std::string _modeUnknown;

};

class WBLFrequencyProperty: public DbusProperties
{
   public:
      WBLFrequencyProperty();
      virtual ~WBLFrequencyProperty();

      WBLFrequencyBand getFrequency2Enum(const ::std::string& value) const;
      const ::std::string& getFrequency2String(const WBLFrequencyBand value) const;

   private:
      const ::std::string _frequency_2_4;
      const ::std::string _frequency_5;

};

class WBLSecurityProperty: public DbusProperties
{
   public:
      WBLSecurityProperty();
      virtual ~WBLSecurityProperty();

      WBLSecurityType getSecurity2Enum(const ::std::string& value) const;
      const ::std::string& getSecurity2String(const WBLSecurityType value) const;

   private:
      const ::std::string _securityOpen;
      const ::std::string _securityWEP;
      const ::std::string _securityWPA_PSK;
      const ::std::string _securityWPA2_PSK;

};

class WBLAPTypeProperty: public DbusProperties
{
   public:
      WBLAPTypeProperty();
      virtual ~WBLAPTypeProperty();

      WBLAPType getAPType2Enum(const ::std::string& value) const;
      const ::std::string& getAPType2String(const WBLAPType value) const;

   private:
      const ::std::string _apTypeNormal;
      const ::std::string _apTypeCarplay;
      const ::std::string _apTypeAAW;
      const ::std::string _apTypeRestricted;
      const ::std::string _apTypeUnknown;

};

class WBLPowerStateProperty: public DbusProperties
{
   public:
      WBLPowerStateProperty();
      virtual ~WBLPowerStateProperty();

      WBLPowerStateType getPowerState2Enum(const ::std::string& value) const;
      const ::std::string& getPowerState2String(const WBLPowerStateType value) const;

   private:
      const ::std::string _statePoweringOn;
      const ::std::string _statePoweredOn;
      const ::std::string _statePoweringOff;
      const ::std::string _statePoweredOff;
      const ::std::string _statePowerFailure;
      const ::std::string _stateDeviceUnavailable;
      const ::std::string _stateDeviceavailable;

};

class WBLPowerFailureProperty: public DbusProperties
{
   public:
      WBLPowerFailureProperty();
      virtual ~WBLPowerFailureProperty();

      WBLPowerFailureType getPowerFailure2Enum(const ::std::string& value) const;
      const ::std::string& getPowerFailure2String(const WBLPowerFailureType value) const;

   private:
      const ::std::string _typeUnavailable;
      const ::std::string _typeNotReady;
      const ::std::string _typeDeviceFailure;
      const ::std::string _typeConfiguration;
      const ::std::string _typeInternalFailure;
      const ::std::string _typeUnknown;
};
class WBLErrorCodeProperty: public DbusProperties
{
   public:
      WBLErrorCodeProperty();
      virtual ~WBLErrorCodeProperty();

      WBLErrorCode getErrorCode2Enum(const ::std::string& value) const;
      const ::std::string& getErrorCode2String(const WBLErrorCode value) const;

   private:
      const ::std::string _errNoError;
      const ::std::string _errInvalidArgs;
      const ::std::string _errPermissionDenied;
      const ::std::string _errNotSupported;
      const ::std::string _errRejected;
      const ::std::string _errInProgress;
      const ::std::string _errCancelled;
      const ::std::string _errAlreadyExist;
	  const ::std::string _errWiFiStateBlocked;
      const ::std::string _errUnknown;

};

class WBLConflictTypeProperty: public DbusProperties
{
   public:
      WBLConflictTypeProperty();
      virtual ~WBLConflictTypeProperty();

      WBLConflictType getConflictType2Enum(const ::std::string& value) const;
      const ::std::string& getConflictType2String(const WBLConflictType value) const;
      ::std::map< int, const std::string> conflictIssueDesList;

   private:
      const ::std::string _conflictReqStaUnavailable;
      const ::std::string _conflictAPConfMismatch;
      const ::std::string _conflictWifiPowerOff;
      const ::std::string _conflictSimOpNotAllowed;
};

class WBLResolutionTypeProperty: public DbusProperties
{
   public:
      WBLResolutionTypeProperty();
      virtual ~WBLResolutionTypeProperty();

      WBLResolutionType getResolution2Enum(const ::std::string& value) const;
      const ::std::string& getResolution2String(const WBLResolutionType value) const;

   private:
      const ::std::string _resSetupPrepared;
      const ::std::string _resSetupUserRejected;
      const ::std::string _resSetupPrio;
      const ::std::string _resSlotsFreed;
};

class LCMWiFiStateProperty: public DbusProperties
{
public:
      LCMWiFiStateProperty();
      virtual ~LCMWiFiStateProperty();

      LCMWiFiState getWiFiState2Enum(const ::std::string& value) const;
      const ::std::string& getWiFiState2String(const LCMWiFiState value) const;

   private:
      const ::std::string _wifiStateOff;
      const ::std::string _wifiStateBlocked;
      const ::std::string _wifiStateNormal;
      const ::std::string _wifiStateNormalSwitchOffWifi;
      const ::std::string _wifiStateUnknown;

};

class WBLPowerOffReasonProperty:public DbusProperties
{
public:
   WBLPowerOffReasonProperty();
   virtual ~WBLPowerOffReasonProperty();

   WBLPowerOffReason getWBLPowerOffReason2Enum(const ::std::string& value) const;
   const ::std::string& getWBLPowerOffReason2String(const WBLPowerOffReason value) const;

private:
   const ::std::string _wifiPowerOffUserRequest;
   const ::std::string _wifiPowerOffWifiState;
   const ::std::string _wifiPowerOffBlockWifiState;
   const ::std::string _wifiPowerOffUnknown;

};

class WBLActionProperty : public DbusProperties
{
public:
   WBLActionProperty();
   virtual ~WBLActionProperty();

   WBLActionType getWBLActionType2Enum(const ::std::string& value) const;
   const ::std::string& getWBLActionType2String(const WBLActionType value) const;

private:
   const ::std::string _wifiActionActivate;
   const ::std::string _wifiActionUpdate;
   const ::std::string _wifiActionRandomize;
   const ::std::string _wifiActionUnknown;

};
class WBLTechnologyRestriction:public DbusProperties
{
public:
   WBLTechnologyRestriction();
   virtual ~WBLTechnologyRestriction();

   WBLTechnology getWBLTechnology2Enum(const ::std::string& value) const;
   const ::std::string& getWBLTechnology2String(const WBLTechnology value) const;

private:
   const ::std::string _wifiCPWTechnology;
   const ::std::string _wifiAATechnology;
   const ::std::string _wifiUnknownTechnology;

};

class WBLRestrictionState:public DbusProperties
{
public:
   WBLRestrictionState();
   virtual ~WBLRestrictionState();

   WBLRestrictState getWBLRestriction2Enum(const ::std::string& value) const;
   const ::std::string& getWBLRestriction2String(const WBLRestrictState value) const;

private:
   const ::std::string _stateRequested;
   const ::std::string _stateActivating;
   const ::std::string _stateActivated;
   const ::std::string _stateDeActivating;
   const ::std::string _stateDeActivated;
   const ::std::string _stateFailed;


};

static WBLWifiModeProperty wblWifiMode;
static WBLFrequencyProperty wblFrequency;
static WBLSecurityProperty wblSecurity;
static WBLAPTypeProperty wblAPType;
static WBLPowerStateProperty wblPowerState;
static WBLErrorCodeProperty wblErrorCode;
static WBLConflictTypeProperty wblConflictType;
static WBLResolutionTypeProperty wblResolutionType;
static WBLPowerFailureProperty wblPowerFailure;
static LCMWiFiStateProperty wblLCMWifiState;
static WBLPowerOffReasonProperty wblPowerOffType;
static WBLActionProperty wblActionType;
static WBLTechnologyRestriction wblTechRestriction;
static WBLRestrictionState wblRestrictionState;

#define BOOL_TO_STR(BOOL_VALUE)   ((BOOL_VALUE) ? ("true") : ("false"))
#define WIFI_MODE_TO_STR(WBL_WIFI_MODE)   (wblWifiMode.getEnum2StringTrace(WBL_WIFI_MODE).c_str())
#define FREQ_TO_STR(WBL_FREQUENCY)   (wblFrequency.getEnum2StringTrace(WBL_FREQUENCY).c_str())
#define SECURITY_TO_STR(WBL_SECURITY)   (wblSecurity.getEnum2StringTrace(WBL_SECURITY).c_str())
#define AP_TYPE_TO_STR(WBL_AP_TYPE)   (wblAPType.getEnum2StringTrace(WBL_AP_TYPE).c_str())
#define POWER_STATE_TO_STR(WBL_POWER_STATE)   (wblPowerState.getEnum2StringTrace(WBL_POWER_STATE).c_str())
#define ERROR_TO_STR(WBL_ERROR_CODE)   (wblErrorCode.getEnum2StringTrace(WBL_ERROR_CODE).c_str())
#define CONF_TYPE_TO_STR(WBL_CONFLICT_TYPE)   (wblConflictType.getEnum2StringTrace(WBL_CONFLICT_TYPE).c_str())
#define RESOLUTION_TO_STR(WBL_RESOLUTION)   (wblResolutionType.getEnum2StringTrace(WBL_RESOLUTION).c_str())
#define WIFISTATE_TO_STR(WBL_WIFI_STATE)   (wblLCMWifiState.getEnum2StringTrace(WBL_WIFI_STATE).c_str())
#define POWEROFFTYPE_TO_STR(WBL_POWEROFF_TYPE)   (wblPowerOffType.getEnum2StringTrace(WBL_POWEROFF_TYPE).c_str())
#define ACTIONTYPE_TO_STR(WBL_ACTION_TYPE)   (wblActionType.getEnum2StringTrace(WBL_ACTION_TYPE).c_str())

} //namespace bosch
} //namespace org

#endif //_WBL_TYPE_PROPERTIES_H

/** @} */
