/**
 * @file WBLMessageTypes.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _WBL_MESSAGE_TYPES_H
#define _WBL_MESSAGE_TYPES_H

#include <string>
#include <vector>
#include <algorithm>

#include "WBLTypes.h"
#include "APModeClient_Types.h"

namespace org
{
namespace bosch
{

//Forward declarations
class WifiSetUpItem;
class LIMItem;

typedef std::vector < WifiSetUpItem > WifiSetUpList;
typedef std::vector < LIMItem > LIMList;
typedef std::vector < uint16 > ChannelList;
typedef std::vector < WifiMode > PriorityList;

class SSIDItem
{
   public:
      SSIDItem();
      SSIDItem(const SSIDItem &ref);
      SSIDItem& operator=(const SSIDItem &ref);
      bool operator==(const SSIDItem &ref);
      virtual ~SSIDItem();
      ByteArray SSID;
      bool isUTF8;
};

class APConfig
{
   public:
      APConfig();
      APConfig(const APConfig &ref);
      APConfig& operator=(const APConfig &ref);
      bool operator==(const APConfig &ref);
      virtual ~APConfig();

      WBLAPType type; //Mandatory
      SSIDItem ssid;
      ::std::string passphrase;
      WBLSecurityType security;
      bool isVisible;
      WBLFrequencyBand frequency;
      ChannelList chanList; 
      uint16 stationsToReserve; //Mandatory
      bool isSeparateAP;

      bool isTypeValid;
      bool isSSIDValid;
      bool isPassphraseValid;
      bool isSecurityValid;
      bool isVisibilityValid;
      bool isFrequencyValid;
      bool isChanListValid;
      bool isStationsToReserveValid;
      bool isSeparateAPValid;
};

class APSetup
{
   public:
      APSetup();
      APSetup(const APSetup &ref);
      APSetup& operator=(const APSetup &ref);
      bool operator==(const APSetup &ref);
      virtual ~APSetup();

      ByteArray SSID;
      ::std::string passphrase;
      WBLSecurityType security;
      WBLAPType type;
      AssociatedStationList stationList;
      bool isVisible;
      ::std::string macAddress;
      SupportedChannelList chanList;
      uint16 maxStations;
      VendorIEList vendorIEs;
      SupportedFrequencies supportedFrequencies;
      IPv4ConfigurationList ipv4ConfigurationList;
      bool isTethering;
      WifiAccessNetworkType networkType;
};

class WBLConnectionStatus
{
   public:
   WBLConnectionStatus();
   WBLConnectionStatus(const WBLConnectionStatus &ref);
   WBLConnectionStatus& operator=(const WBLConnectionStatus &ref);
   bool operator==(const WBLConnectionStatus &ref);
   virtual ~WBLConnectionStatus();

   bool isConnected;
   uint32 healthIndicatorValue;
};

class WifiSetUpProperty
{
   public:
      WifiSetUpProperty();
      WifiSetUpProperty(const WifiSetUpProperty &ref);
      WifiSetUpProperty& operator=(const WifiSetUpProperty &ref);
      bool operator==(const WifiSetUpProperty &ref);
      virtual ~WifiSetUpProperty();

      WifiMode mode;
      ::std::string interface;
      WBLPowerStateType powerState;
      WBLPowerOffReason powerOffType;
      bool isPowered;
      bool isConnected;
      WBLFrequencyBand frequency;
      WBLPowerFailureType powerFailure;
      uint16 currChannel;
      APSetup apSetup;
      WBLConnectionStatus connectionStatus;
};

class WifiSetUpItem final
{
   public:
      WifiSetUpItem();
      WifiSetUpItem(const WifiSetUpItem &ref);
      WifiSetUpItem& operator=(const WifiSetUpItem &ref);
      bool operator==(const WifiSetUpItem &ref);
      virtual ~WifiSetUpItem();
      bool isEmpty();

      ::std::string setupObjPath;
      ::std::string nativeObjPath;
      WifiSetUpProperty property;
};

class LIMAPConfig
{
   public:
      LIMAPConfig();
      LIMAPConfig(const LIMAPConfig &ref);
      LIMAPConfig& operator=(const LIMAPConfig &ref);
      bool operator==(const LIMAPConfig &ref);
      virtual ~LIMAPConfig();

      WBLFrequencyBand frequency;
      WBLAPType apType;

};

class LIMProperty
{
   public:
      LIMProperty();
      LIMProperty(const LIMProperty &ref);
      LIMProperty& operator=(const LIMProperty &ref);
      bool operator==(const LIMProperty&ref);
      virtual ~LIMProperty();

      WifiMode mode;
      bool poweredSetting;
      LIMAPConfig limAPConfig;
      WBLPowerStateType powerState;
};

class LIMItem final
{
   public:
      LIMItem();
      LIMItem(const LIMItem &ref);
      LIMItem& operator=(const LIMItem &ref);
      bool operator==(const LIMItem &ref);
      virtual ~LIMItem();

      ::std::string objPath;
      LIMProperty property;
};

class RequestTypeItem
{
   public:
      RequestTypeItem();
      RequestTypeItem(const RequestTypeItem &ref);
      RequestTypeItem& operator=(const RequestTypeItem &ref);
      bool operator==(const RequestTypeItem &ref);
      virtual ~RequestTypeItem();

      WifiMode mode;
      APConfig apConfig;
      WBLFrequencyBand frequency;

};

class ConflictDetectedItem final
{
   public:
      ConflictDetectedItem();
      ConflictDetectedItem(const ConflictDetectedItem &ref);
      ConflictDetectedItem& operator=(const ConflictDetectedItem &ref);
      bool operator==(const ConflictDetectedItem &ref);
      virtual ~ConflictDetectedItem();
      void clearConflict();
     
      //::std::string user;
      uint32 conflictID;
      RequestTypeItem reqConfig;
      RequestTypeItem currConfig;
      WBLConflictType conflictType;
      ::std::string conflictDes;
      uint16 numStaToFree;
};

class ConflictResolvedItem
{
   public:
      ConflictResolvedItem();
      ConflictResolvedItem(const ConflictResolvedItem &ref);
      ConflictResolvedItem& operator=(const ConflictResolvedItem &ref);
      bool operator==(const ConflictResolvedItem &ref);
      virtual ~ConflictResolvedItem();

      uint32 conflictID;
      WBLConflictType conflictType;
      WBLResolutionType resType;
      ::std::string resolutionDes;
};

class DeAuthenticateStationItem
{
   public:
      DeAuthenticateStationItem();
      DeAuthenticateStationItem(const DeAuthenticateStationItem &ref);
      DeAuthenticateStationItem& operator=(const DeAuthenticateStationItem &ref);
      bool operator==(const DeAuthenticateStationItem &ref);
      virtual ~DeAuthenticateStationItem();

      ::std::string macAddress;
      ::std::string type;
      ::std::string objPath;
};

class HWLimitationInfo
{
public:
   HWLimitationInfo();
   HWLimitationInfo(const HWLimitationInfo &ref);
   HWLimitationInfo& operator=(const HWLimitationInfo &ref);
   bool operator==(const HWLimitationInfo &ref);
   virtual ~HWLimitationInfo();

   bool isCPWSupport;
   bool is2_4GHz_Support;
   bool is5_GHz_Support;
};

} //namespace bosch
} //namespace org

#endif //_WBL_MESSAGE_TYPES_H

/** @} */
