/**
 * @file WBLBaseMsg.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 * @{
 */

#ifndef _WBL_BASE_MSG_H
#define _WBL_BASE_MSG_H

#include "asf/core/Types.h"

#include "WBLTypes.h"

namespace org
{
namespace bosch
{

class WBLBaseMsg
{
public:
   WBLBaseMsg(WBLBaseMsgID msgID);
   WBLBaseMsg(const WBLBaseMsg& ref);
   WBLBaseMsg& operator=(const WBLBaseMsg& ref);
   bool operator==(const WBLBaseMsg& ref);
   virtual ~WBLBaseMsg();

   virtual WBLBaseMsgID getMsgID() const final;
   virtual void setMsgID(const WBLBaseMsgID msgID) final;
   virtual uint32 getMsgToken() const final;
   virtual void setMsgToken(const uint32 actToken) final;
   virtual WBLErrorCode getErrorCode() const final;
   virtual void setErrorCode(const WBLErrorCode errCode) final;

private:
   WBLBaseMsgID _msgID;
   WBLErrorCode _errCode;
   uint32 _actToken;

};

} //namespace bosch
} //namespace org

#endif //_WBL_BASE_MSG_H

/** @} */
