/**
 * @file DbusProperties.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _DBUS_PROPERTIES_H
#define _DBUS_PROPERTIES_H

#include <string>

#include "DbusIfTypes.h"

namespace org 
{
namespace bosch 
{

/**
 * Properties base class.
 */
class DbusProperties
{
protected:
   DbusProperties();
   DbusProperties(const ::std::string& description);
   virtual ~DbusProperties();

public:
   inline const ::std::map< std::string, int >& getString2EnumList(void) const
   {
      return _string2EnumList;
   }
   inline const ::std::map< int, const std::string* >& getEnum2StringList(void) const
   {
      return _enum2StringList;
   }
   inline const ::std::map< std::string, int >* getString2EnumListPtr(void) const
   {
      return &_string2EnumList;
   }
   inline const ::std::map< int, const std::string* >* getEnum2StringListPtr(void) const
   {
      return &_enum2StringList;
   }

   int convertString2Enum(const ::std::string& input, const bool handleError = true) const;
   const ::std::string& convertEnum2String(const int input, const bool handleError = true) const;
   const ::std::string& getEnum2StringTrace(const int input);

protected:
   ::std::map< std::string, int > _string2EnumList; /**< map with property + enum pairs */
   ::std::map< int, const std::string* > _enum2StringList; /**< map with enum + property pairs */
   static const ::std::string _emptyString; /**< empty string */
   static const int _dummyEnum; /**< dummy enum */
   static const ::std::string _unknownString; /**< unknown string */

   int convertString2Enum(const ::std::map< std::string, int >& list,
         const ::std::string& input, const bool handleError = true) const;
   const ::std::string& convertEnum2String(const ::std::map< int,
         const std::string* >& list, const int input,
         const bool handleError = true) const;

private:
   ::std::string _description; /**< description */

   void onString2EnumError(const ::std::string& input) const;
   void onEnum2StringError(const int input) const;
};

} //namespace bosch
} //namespace org

#endif //_DBUS_PROPERTIES_H

/** @} */
