/**
 * @file DataProvider.h
 * @author RBEI/ECO3 Akshay Kumar S R
 * @copyright (c) 2020 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */



#ifndef _DATA_PROVIDER_H
#define _DATA_PROVIDER_H

#define WBLCONFIGPATH "/var/opt/bosch/static/connectivity/config/WBL_config.json"

#include "asf/core/Logger.h"
#include "GenericSingleton.h"
#include "WBLConfiguration.h"
namespace org
{
namespace bosch
{
class DataProvider:
public GenericSingleton<DataProvider>
{
public:
   virtual ~DataProvider();
   inline const WBLConfiguration& getWBLConfiguration(void) const
   {
      return _WBLKDSConfiguration;
   }

private:
   DECLARE_CLASS_LOGGER();
   friend class GenericSingleton<DataProvider>;

   DataProvider();
   WBLConfiguration _WBLKDSConfiguration;


   void readConfiguration(WBLConfiguration& configuration, const ::std::string& configurationFile);
};
}
}
#endif
