/**
 * @file WapdmanServerComponent.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief 
 *
 * @{
 */
#include "WapdmanServerComponent.h"
#include "WapdmanClientComponent.h"


namespace Stub 
{ 
namespace server 
{ 

	using namespace ::Proxy::client;
	using namespace ::Stub::WapdmanService;
	using namespace ::Stub::WapdmanServiceTypes;
	WapdmanServerComponent* WapdmanServerComponent::m_poWapdmanServerComponent=NULL;
    DEFINE_CLASS_LOGGER_AND_LEVEL ("Stub/server", WapdmanServerComponent, Info);
	
	WapdmanServerComponent::WapdmanServerComponent():WapdmanServiceStub("wapdmanservice")
    { 
	    LOG_INFO("WapdmanServerComponent::Constructor");
		m_poWapdmanServerComponent = this;
		m_u32act=0;
		m_bool=false;
    }
	
	WapdmanServerComponent::~WapdmanServerComponent()
	{
		LOG_INFO("WapdmanServerComponent::Destructor");
		delete m_poWapdmanServerComponent;
	    m_poWapdmanServerComponent = NULL;
	}
	
	WapdmanServerComponent& WapdmanServerComponent::rfGetServerInstance()
    {
		return *m_poWapdmanServerComponent;
    }

	void WapdmanServerComponent::onSetSSIDRequest(const ::boost::shared_ptr< SetSSIDRequest >& setSSID)
	{
		LOG_INFO("WapdmanServerComponent::onSetSSIDRequest");
		std::vector <uint8> SSID1 = setSSID->getSsid();
		for(std::vector<uint8>::const_iterator i=SSID1.begin(); i !=SSID1.end(); ++i)
		{
			LOG_INFO("Value is %d",*i);
		}	
		/* std::vector <uint8> SSID;
		SSID.push_back(10);
		SSID.push_back(20); */
		m_u32act = setSSID->getAct();
		if(setSSID)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueSetSSIDRequest(setSSID->getSsid() /*SSID*/,setSSID->getUtf_ssid());
		}
		else
		{
			LOG_INFO("setSSID is NULL");
		}
	}

	void WapdmanServerComponent::vGlueonSetSSIDResponse(uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonSetSSIDResponse");
		sendSetSSIDResponse(m_u32act);
	}
	
	/*   DeAuthenticateStation  */
	void WapdmanServerComponent::onDeAuthenticateStationRequest(const ::boost::shared_ptr< DeAuthenticateStationRequest >& DeAuthenticateStation)
	{
		LOG_INFO("WapdmanServerComponent::onDeAuthenticateStationRequest");
		if(DeAuthenticateStation)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueDeAuthenticateStationRequest(DeAuthenticateStation->getAddress());
		}
		else
		{
			LOG_INFO("DeAuthenticateStation is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonDeAuthenticateStationResponse(uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonDeAuthenticateStationResponse");
		sendDeAuthenticateStationResponse(m_u32act);
	} 

	/*   BlacklistStation  */
	void WapdmanServerComponent::onBlacklistStationRequest(const ::boost::shared_ptr< BlacklistStationRequest >& BlacklistStation)
	{
		LOG_INFO("WapdmanServerComponent::onBlacklistStationRequest");
		if(BlacklistStation)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueBlacklistStationRequest(BlacklistStation->getAddress(),BlacklistStation->getAllow());
		}
		else
		{
			LOG_INFO("BlacklistStation is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonBlacklistStationResponse(uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonBlacklistStationResponse");
		sendBlacklistStationResponse(m_u32act);
	} 

	/*   SetOperatingChannels  */
	void WapdmanServerComponent::onSetOperatingChannelsRequest(const ::boost::shared_ptr< SetOperatingChannelsRequest >& SetOperatingChannels)
	{
		LOG_INFO("WapdmanServerComponent::onSetOperatingChannelsRequest");
		m_u32act = SetOperatingChannels->getAct();
		if(SetOperatingChannels)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueSetOperatingChannelsRequest(SetOperatingChannels->getChannels());
		}
		else
		{
			LOG_INFO("SetOperatingChannels is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonSetOperatingChannelsResponse(uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonSetOperatingChannelsResponse");
		sendSetOperatingChannelsResponse(m_u32act);
	}
	
	/* StartWPSPushButton */
	void WapdmanServerComponent::onStartWPSPushButtonRequest(const ::boost::shared_ptr< StartWPSPushButtonRequest >& StartWPSPushButton)
	{
		LOG_INFO("WapdmanServerComponent::onStartWPSPushButtonRequest");
		m_u32act = StartWPSPushButton->getAct();
		if(StartWPSPushButton)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueStartWPSPushButtonRequest();
		}
		else
		{
			LOG_INFO("StartWPSPushButton is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonStartWPSPushButtonResponse(uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonStartWPSPushButtonResponse");
		sendStartWPSPushButtonResponse(m_u32act);
	}
	
	/* CancelWPS */
	void WapdmanServerComponent::onCancelWPSRequest(const ::boost::shared_ptr< CancelWPSRequest >& CancelWPS)
	{
		LOG_INFO("WapdmanServerComponent::onCancelWPSRequest");
		m_u32act = CancelWPS->getAct();
		if(CancelWPS)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueCancelWPSRequest();
		}
		else
		{
			LOG_INFO("CancelWPS is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonCancelWPSResponse(uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonCancelWPSResponse");
		sendCancelWPSResponse(m_u32act);
	}
	
	/*RegisterVendorService*/
	void WapdmanServerComponent::onRegisterVendorServiceRequest (const ::boost::shared_ptr< RegisterVendorServiceRequest >& registerVendorService)
	{
		LOG_INFO("WapdmanServerComponent::onRegisterVendorServiceRequest");
		std::vector <std::vector <uint8> > IEsv_v;
		
		// if in parameter is single ay 
		//std::vector <uint8> IEs1	= registerVendorService->getIEs();
		//IEsv_v.push_back(IEs1);
		::boost::ptr_vector< std::vector <uint8> > IEs1 = registerVendorService->getIEs();
		for(uint8 i=0; i < IEs1.size(); i++)
		{
		LOG_INFO("Value is %d",i);
		IEsv_v.push_back(IEs1[i]);
		}
		/*for(std::vector<uint8>::const_iterator i=IEs1.begin(); i !=IEs1.end(); ++i)
		{
		LOG_INFO("Value is %d",*i);
		(IEsv_v[i]).push_back(i);
		}*/
		/* std::vector <uint8> SSID;
		SSID.push_back(10);
		SSID.push_back(20); */
		m_u32act = registerVendorService->getAct();
		if(registerVendorService)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueRegisterVendorServiceRequest(IEsv_v /*SSID*/);
		}
		else
		{
			LOG_INFO("registerVendorService Request is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonRegisterVendorServiceResponse(uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonRegisterVendorServiceResponse");
	}
	
	/*UnregisterVendorService*/
	void WapdmanServerComponent::onUnregisterVendorServiceRequest (const ::boost::shared_ptr< UnregisterVendorServiceRequest >& unregisterVendorService)
	{
		LOG_INFO("WapdmanServerComponent::onUnregisterVendorServiceRequest");
		std::vector <std::vector <uint8> > IEsv_v;
		
		// if in parameter is single ay 
		//std::vector <uint8> IEs1	= registerVendorService->getIEs();
		//IEsv_v.push_back(IEs1);
		::boost::ptr_vector< std::vector <uint8> > IEs1 = unregisterVendorService->getIEs();
		for(uint8 i=0; i < IEs1.size(); i++)
		{
		LOG_INFO("Value is %d",i);
		IEsv_v.push_back(IEs1[i]);
		}
		/*for(std::vector<uint8>::const_iterator i=IEs1.begin(); i !=IEs1.end(); ++i)
		{
		LOG_INFO("Value is %d",*i);
		(IEsv_v[i]).push_back(i);
		}*/
		/* std::vector <uint8> SSID;
		SSID.push_back(10);
		SSID.push_back(20); */
		m_u32act = unregisterVendorService->getAct();
		if(unregisterVendorService)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueUnregisterVendorServiceRequest(IEsv_v /*SSID*/);
		}
		else
		{
			LOG_INFO("unregisterVendorService Request is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonUnregisterVendorServiceResponse(uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonUnregisterVendorServiceResponse");
	}
	
	/*GetAssociatedStations*/
    void WapdmanServerComponent::onGetAssociatedStationsRequest (const ::boost::shared_ptr< GetAssociatedStationsRequest >& getAssociatedStations)
	{
	    LOG_INFO("WapdmanServerComponent::onGetAssociatedStationsRequest");
		m_u32act = getAssociatedStations->getAct();
		if(getAssociatedStations)
		{
		WapdmanClientComponent::rfGetClientComponentInstance().vGlueGetAssociatedStationsRequest();
		}
		else
		{
		LOG_INFO("getAssociatedStations is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonGetAssociatedStationsResponse(::std::vector< ::Stub::WapdmanServiceTypes::StructASList > Srclist)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonGetAssociatedStationsResponse");
		::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructASList > listassociatedstations;
		if(Srclist.size())
		{
		LOG_INFO("WapdmanServerComponent::vGlueonGetAssociatedStationsResponse11");
		for(uint16 u16Count=0;u16Count<Srclist.size();u16Count++)
		{
		LOG_INFO("WapdmanServerComponent::vGlueonGetAssociatedStationsResponse loop");
		::Stub::WapdmanServiceTypes::StructASList *poAdd = new ::Stub::WapdmanServiceTypes::StructASList();
		StructASList rsInsert = Srclist.at(u16Count);
		if(poAdd)
		{
		LOG_INFO("WapdmanServerComponent::vGlueonGetAssociatedStationsResponse if case");
		std::string ObjectPath = rsInsert.getObjPath();
		LOG_INFO("ObjectPath %s",ObjectPath.c_str());
		std::string accesspoint = rsInsert.getAccesspoint();
		LOG_INFO("accesspoint %s",accesspoint.c_str());
		std::string MAC = rsInsert.getMacAddress();
		LOG_INFO("MAC %s",MAC.c_str());
		std::string interface = rsInsert.getInterface();
		LOG_INFO("interface %s",interface.c_str());
		std::string Ipaddress = rsInsert.getIPAddress();
		LOG_INFO("Ipaddress %s",Ipaddress.c_str());
		std::string Hostname = rsInsert.getHostname();
		LOG_INFO("Hostname %s",Hostname.c_str());
				
		poAdd->setObjPath(rsInsert.getObjPath());
		poAdd->setAccesspoint(rsInsert.getAccesspoint());
		poAdd->setMacAddress(rsInsert.getMacAddress());
		poAdd->setInterface(rsInsert.getInterface());
		poAdd->setIPAddress(rsInsert.getIPAddress());
		poAdd->setHostname(rsInsert.getHostname());
				
		}
		listassociatedstations.push_back(poAdd);
		}	
		
		}
		else
		{
			LOG_INFO("WapdmanServerComponent::vGlueonGetAssociatedStationsResponse No Response");
		}
		sendGetAssociatedStationsResponse(listassociatedstations,m_u32act);
		
		/*LOG_INFO("WapdmanServerComponent::vGlueonGetAssociatedStationsResponse");
		::std::vector< ::Stub::WapdmanServiceTypes::StructASList >::iterator it;
		for(it = Srclist.begin(); it != Srclist.end(); ++it)
		{
		LOG_INFO("WapdmanServerComponent::vGlueonGetAssociatedStationsResponse Iteration");
		std::string ObjectPath = it->getObjPath();
		LOG_INFO("ObjectPath %s",ObjectPath.c_str());
		std::string accesspoint = it->getAccesspoint();
		LOG_INFO("accesspoint %s",accesspoint.c_str());
		std::string MAC = it->getMacAddress();
		LOG_INFO("MAC %s",MAC.c_str());
		std::string interface = it->getInterface();
		LOG_INFO("interface %s",interface.c_str());
		std::string Ipaddress = it->getIPAddress();
		LOG_INFO("Ipaddress %s",Ipaddress.c_str());
		std::string Hostname = it->getHostname();
		LOG_INFO("Hostname %s",Hostname.c_str());
		//Send back the request to TML
		//sendGetAssociatedStationsResponse(*it,m_u32act);
		}
		sendGetAssociatedStationsResponse(*it,m_u32act);
		Srclist.clear();*/
	}
	
	/* SSID -- Get Function Manual */
	void WapdmanServerComponent::onSSIDGetRequest (const ::boost::shared_ptr< SSIDGetRequest >& sSIDGet)
	{
		LOG_INFO("WapdmanServerComponent::onSSIDGetRequest");
		m_u32act = sSIDGet->getAct();
		m_bool = true;
		if(sSIDGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueSSIDGetRequest();
		}
		else
		{
			LOG_INFO("sSIDGet is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonSSIDGetResponse(std::vector<uint8> ssidget,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonSSIDGetResponse");
		LOG_INFO("sendSSIDGetResponse m_bool variable check before how %d",m_bool);
		if(m_bool == true)
		{
		LOG_INFO("sendSSIDGetResponse m_bool variable check before %d",m_bool);
		sendSSIDGetResponse(ssidget,m_u32act);
		m_bool = false;
		LOG_INFO("sendSSIDGetResponse m_bool variable check after %d",m_bool);
		}	
	}
	
	/* Security -- Get Function Manual */
	void WapdmanServerComponent::onSecurityRequest (const ::boost::shared_ptr< SecurityRequest >& security)
	{
		LOG_INFO("WapdmanServerComponent::onSecurityRequest");
		m_u32act = security->getAct();
		if(security)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueSecurityGetRequest();
		}
		else
		{
			LOG_INFO("security is NULL");
		}
	}
	
	void WapdmanServerComponent::vGlueonSecurityResponse(std::string security,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonSecurityResponse");
		sendSecurityResponse(security,m_u32act);
		
	}
	
	/* MacAddress -- Get Function Manual */
	void WapdmanServerComponent::onMacAddressGetRequest (const ::boost::shared_ptr< MacAddressGetRequest >& macAddressGet)
	{
		LOG_INFO("WapdmanServerComponent::onMacAddressGetRequest");
		m_u32act = macAddressGet->getAct();
		if(macAddressGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueMacAddressGetRequest();
		}
		else
		{
			LOG_INFO("macAddressGet is NULL");
		}		
	}
	void WapdmanServerComponent::vGlueonMacAddressGetResponse(std::string macaddress,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonSecurityResponse");
		sendMacAddressGetResponse(macaddress,m_u32act);
	}
	
	/* Interface -- Get Function Manual */
	void WapdmanServerComponent::onInterfaceGetRequest (const ::boost::shared_ptr< InterfaceGetRequest >& interfaceGet)
	{
		LOG_INFO("WapdmanServerComponent::onInterfaceGetRequest");
		m_u32act = interfaceGet->getAct();
		if(interfaceGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueInterfaceGetRequest();
		}
		else
		{
			LOG_INFO("interfaceGet is NULL");
		}		 
	}
	void WapdmanServerComponent::vGlueonInterfaceGetResponse(::std::string interface,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonSecurityResponse");
		sendInterfaceGetResponse(interface,m_u32act);
	}
	
	/* Passphrase -- Get Function Manual */
	void WapdmanServerComponent::onPassphraseGetRequest (const ::boost::shared_ptr< PassphraseGetRequest >& passphraseGet)
	{
		LOG_INFO("WapdmanServerComponent::onPassphraseGetRequest");
		m_u32act = passphraseGet->getAct();
		m_bool = true;
		if(passphraseGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGluePassphraseGetRequest();
		}
		else
		{
			LOG_INFO("passphraseGet is NULL");
		}		 
	}
	void WapdmanServerComponent::vGlueonPassphraseGetResponse(::std::string passphrase,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonPassphraseGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("sendPassphraseGetResponse m_bool variable check before %d",m_bool);
		sendPassphraseGetResponse(passphrase,m_u32act);
		m_bool = false;
		LOG_INFO("sendPassphraseGetResponse m_bool variable check  after %d",m_bool);
		}
	}
	void WapdmanServerComponent::onPassphraseSetRequest (const ::boost::shared_ptr< PassphraseSetRequest >& passphraseSet)
	{
		LOG_INFO("WapdmanServerComponent::onPassphraseSetRequest");
		m_u32act = passphraseSet->getAct();
		//m_bool = true;
		if(passphraseSet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGluePassphraseSetRequest(passphraseSet->getPassphrase());
		}
		else
		{
			LOG_INFO("passphraseSet is NULL");
		}
	}
	/* Powered -- Get Function Manual */
	void WapdmanServerComponent::onPoweredGetRequest (const ::boost::shared_ptr< PoweredGetRequest >& poweredGet)
	{
		LOG_INFO("WapdmanServerComponent::onPoweredGetRequest");
		m_u32act = poweredGet->getAct();
		m_bool = true;
		if(poweredGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGluePoweredGetRequest();
		}
		else
		{
			LOG_INFO("poweredGet is NULL");
		}		 
	}
	void WapdmanServerComponent::vGlueonPoweredGetResponse(bool powered,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonPoweredGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("sendPoweredGetResponse m_bool variable check before %d",m_bool);
		sendPoweredGetResponse(powered,m_u32act);
		m_bool = false;
		LOG_INFO("sendPoweredGetResponse m_bool variable check  after %d",m_bool);
		}	
		
	}
	 
	void WapdmanServerComponent::onPoweredSetRequest (const ::boost::shared_ptr< PoweredSetRequest >& poweredSet)
	{
		LOG_INFO("WapdmanServerComponent::onPoweredSetRequest");
		m_u32act = poweredSet->getAct();
		//m_bool = true;
		if(poweredSet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGluePoweredSetRequest(poweredSet->getPowered());
		}
		else
		{
			LOG_INFO("poweredSet is NULL");
		}
	}
	
	
	/* Hidden -- Get Function Manual */
	void WapdmanServerComponent::onHiddenGetRequest (const ::boost::shared_ptr< HiddenGetRequest >& hiddenGet)
	{
		LOG_INFO("WapdmanServerComponent::onHiddenGetRequest");
		m_u32act = hiddenGet->getAct();
		m_bool = true;
		if(hiddenGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueHiddenGetRequest();
		}
		else
		{
			LOG_INFO("onHiddenGetRequest is NULL");
		}		 
	}
	void WapdmanServerComponent::vGlueonHiddenGetResponse(bool hidden,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonHiddenGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("vGlueonHiddenGetResponse::sendHiddenGetResponse m_bool variable check before %d",m_bool);
		sendHiddenGetResponse(hidden,m_u32act);
		m_bool = false;
		LOG_INFO("sendHiddenGetResponse m_bool variable check  after %d",m_bool);
		}	
	}
	void WapdmanServerComponent::onHiddenSetRequest (const ::boost::shared_ptr< HiddenSetRequest >& hiddenSet)
	{
		LOG_INFO("WapdmanServerComponent::onHiddenSetRequest");
		m_u32act = hiddenSet->getAct();
		//m_bool = true;
		if(hiddenSet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueHiddenSetRequest(hiddenSet->getHidden());
		}
		else
		{
			LOG_INFO("hiddenSet is NULL");
		}	
	}
	/* CurrentOperatingChannel -- Get Function Manual */
    void WapdmanServerComponent::onCurrentOperatingChannelGetRequest (const ::boost::shared_ptr< CurrentOperatingChannelGetRequest >& currentOperatingChannelGet)
	{
		LOG_INFO("WapdmanServerComponent::onCurrentOperatingChannelGetRequest");
		m_u32act = currentOperatingChannelGet->getAct();
		m_bool = true;
		if(currentOperatingChannelGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueCurrentOperatingChannelGetRequest();
		}
		else
		{
			LOG_INFO("currentOperatingChannelGet is NULL");
		}		 
	}
	void WapdmanServerComponent::vGlueonCurrentOperatingChannelGetResponse(uint16 currentoperchannel,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonCurrentOperatingChannelGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("sendCurrentOperatingChannelGetResponse::vGlueonCurrentOperatingChannelGetResponse m_bool variable check before %d",m_bool);
		sendCurrentOperatingChannelGetResponse(currentoperchannel,m_u32act);
		m_bool = false;
		LOG_INFO("sendCurrentOperatingChannelGetResponse m_bool variable check  after %d",m_bool);
		}	
		  
	}
	
    void WapdmanServerComponent::onVendorIEsGetRequest (const ::boost::shared_ptr< VendorIEsGetRequest >& vendorIEsGet)
	{
		LOG_INFO("WapdmanServerComponent::onCurrentOperatingChannelGetRequest");
		m_u32act = vendorIEsGet->getAct();
		if(vendorIEsGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueVendorIEsGetRequest();
		}
		else
		{
			LOG_INFO("vendorIEsGet is NULL");
		}		
	}
	void WapdmanServerComponent::vGlueonVendorIEsGetResponse(uint16 vendorIEs,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonVendorIEsGetResponse");
		// To Do Send the Resposne to TML
	}
	
	/*PowerState -- Get Functionality Manually Added */
	void WapdmanServerComponent::onPowerStateGet(const ::boost::shared_ptr< PowerStateGet >& powerState)
	{
		LOG_INFO("WapdmanServerComponent::onPowerStateGet");
		m_u32act = powerState->getAct();
		m_bool = true;
		if(powerState)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGluePowerStateGetRequest();
		}
		else
		{
			LOG_INFO("onPowerStateGet is NULL");
		}	
	}
	void WapdmanServerComponent::vGlueonPowerStateGetResponse(::std::string powerstate,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonPowerStateGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("vGlueonPowerStateGetResponse::  m_bool variable check before %d",m_bool);
		sendPowerStateGetUpdate(powerstate,m_u32act);
		m_bool = false;
		LOG_INFO("vGlueonPowerStateGetResponse:: m_bool variable check  after %d",m_bool);
		}	
	}
	
	/*PowerFailureReason -- Get Functionality Manually Added */
	void WapdmanServerComponent::onPowerFailureReasonGet(const ::boost::shared_ptr< PowerFailureReasonGet >& powerFailureReason)
	{
		LOG_INFO("WapdmanServerComponent::onPowerFailureReasonGet");
		m_u32act = powerFailureReason->getAct();
		m_bool = true;
		if(powerFailureReason)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGluePowerFailureReasonGetRequest();
		}
		else
		{
			LOG_INFO("onPowerFailureReasonGet is NULL");
		}	
	}
	void WapdmanServerComponent::vGlueonPowerFailureReasonGetResponse(::std::string powerfailurereason,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonPowerFailureReasonGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("vGlueonPowerFailureReasonGetResponse:: m_bool variable check before %d",m_bool);
		sendPowerFailureReasonGetUpdate(powerfailurereason,m_u32act);
		m_bool = false;
		LOG_INFO("vGlueonPowerFailureReasonGetResponse:: m_bool variable check  after %d",m_bool);
		}	
	}
	/*CurrentHwMode -- Get Functionality Manually Added */
	void WapdmanServerComponent::onCurrentHwModeGet(const ::boost::shared_ptr< CurrentHwModeGet >& currentHwMode)
	{
		LOG_INFO("WapdmanServerComponent::onCurrentHwModeGet");
		m_u32act = currentHwMode->getAct();
		m_bool = true;
		if(currentHwMode)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueCurrentHwModeGetRequest();
		}
		else
		{
			LOG_INFO("onCurrentHwModeGet is NULL");
		}	
	}
	void WapdmanServerComponent::vGlueonCurrentHwModeGetResponse(::std::string currenthwmode,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonCurrentHwModeGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("vGlueonCurrentHwModeGetResponse m_bool variable check before %d",m_bool);
		sendCurrentHwModeGetUpdate(currenthwmode,m_u32act);
		m_bool = false;
		LOG_INFO("vGlueonCurrentHwModeGetResponse m_bool variable check  after %d",m_bool);
		}	
	}
	/*MaximumStationsAllowed -- Get Functionality Manually Added */
	void WapdmanServerComponent::onMaximumStationsAllowedGet(const ::boost::shared_ptr< MaximumStationsAllowedGet >& maximumStationsAllowed)
	{
		LOG_INFO("WapdmanServerComponent::onMaximumStationsAllowedGet");
		m_u32act = maximumStationsAllowed->getAct();
		m_bool = true;
		if(maximumStationsAllowed)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueMaximumStationsAllowedGetRequest();
		}
		else
		{
			LOG_INFO("onMaximumStationsAllowedGet is NULL");
		}	
	}
	void WapdmanServerComponent::vGlueonMaximumStationsAllowedGetResponse(uint16 maxstations,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonMaximumStationsAllowedGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("vGlueonMaximumStationsAllowedGetResponse m_bool variable check before %d",m_bool);
		sendMaximumStationsAllowedGetUpdate(maxstations,m_u32act);
		m_bool = false;
		LOG_INFO("vGlueonMaximumStationsAllowedGetResponse m_bool variable check  after %d",m_bool);
		}	
	}
	/*SupportedChannels -- Get Functionality Manually Added */
	void WapdmanServerComponent::onSupportedChannelsGet(const ::boost::shared_ptr< SupportedChannelsGet >& supportedChannels)
	{
		LOG_INFO("WapdmanServerComponent::onSupportedChannelsGet");
		m_u32act = supportedChannels->getAct();
		m_bool = true;
		if(supportedChannels)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueSupportedChannelsGetRequest();
		}
		else
		{
			LOG_INFO("onSupportedChannelsGet is NULL");
		}	
	}
	void WapdmanServerComponent::vGlueonSupportedChannelsGetResponse(::std::vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList > supportedchanllist,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonSupportedChannelsGetResponse");
		::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList > listsupportedchannels;
		if(supportedchanllist.size())
		{
		LOG_INFO("WapdmanServerComponent::vGlueonSupportedChannelsGetResponse1");
		for(uint16 u16Count=0;u16Count<supportedchanllist.size();u16Count++)
		{
		LOG_INFO("WapdmanServerComponent::vGlueonSupportedChannelsGetResponse loop");
		::Stub::WapdmanServiceTypes::SupportedChannelsList *poAdd = new ::Stub::WapdmanServiceTypes::SupportedChannelsList();
		SupportedChannelsList rsInsert = supportedchanllist.at(u16Count);
		if(poAdd)
		{
		  LOG_INFO("WapdmanServerComponent::vGlueonSupportedChannelsGetResponse if case");
		  uint16 channel1 = rsInsert.getChannels1();
		  LOG_INFO("Channel1 %d",channel1);
		  uint16 channel2 = rsInsert.getChannels2();
		  LOG_INFO("Channel2 %d",channel2);
		  uint16 channel3 = rsInsert.getChannels3();
		  LOG_INFO("Channel3 %d",channel3);
		  uint16 channel4 = rsInsert.getChannels4();
		  LOG_INFO("Channel4 %d",channel4);
		  uint16 channel64 = rsInsert.getChannels64();
		  LOG_INFO("Channel64 %d",channel64);
		  poAdd->setChannels1(rsInsert.getChannels1()); poAdd->setChannels2(rsInsert.getChannels2()); poAdd->setChannels3(rsInsert.getChannels3());	poAdd->setChannels4(rsInsert.getChannels4()); poAdd->setChannels5(rsInsert.getChannels5());	poAdd->setChannels6(rsInsert.getChannels6());poAdd->setChannels7(rsInsert.getChannels7());poAdd->setChannels8(rsInsert.getChannels8()); poAdd->setChannels9(rsInsert.getChannels9());		 
		  poAdd->setChannels10(rsInsert.getChannels10());poAdd->setChannels11(rsInsert.getChannels11()); poAdd->setChannels12(rsInsert.getChannels12()); poAdd->setChannels13(rsInsert.getChannels13()); poAdd->setChannels14(rsInsert.getChannels14()); poAdd->setChannels36(rsInsert.getChannels36()); poAdd->setChannels40(rsInsert.getChannels40()); poAdd->setChannels44(rsInsert.getChannels44()); poAdd->setChannels48(rsInsert.getChannels48());
		  poAdd->setChannels52(rsInsert.getChannels52()); poAdd->setChannels56(rsInsert.getChannels56()); poAdd->setChannels60(rsInsert.getChannels60()); poAdd->setChannels64(rsInsert.getChannels64()); poAdd->setChannels100(rsInsert.getChannels100()); poAdd->setChannels104(rsInsert.getChannels104()); poAdd->setChannels108(rsInsert.getChannels108());
		  poAdd->setChannels112(rsInsert.getChannels112());  poAdd->setChannels116(rsInsert.getChannels116());  poAdd->setChannels120(rsInsert.getChannels120());  poAdd->setChannels124(rsInsert.getChannels124());poAdd->setChannels128(rsInsert.getChannels128()); poAdd->setChannels132(rsInsert.getChannels132());
		  poAdd->setChannels136(rsInsert.getChannels136());  poAdd->setChannels140(rsInsert.getChannels140());  poAdd->setChannels144(rsInsert.getChannels144());
		  poAdd->setChannels149(rsInsert.getChannels149());  poAdd->setChannels153(rsInsert.getChannels153());  poAdd->setChannels157(rsInsert.getChannels157());
		  poAdd->setChannels161(rsInsert.getChannels161());  poAdd->setChannels165(rsInsert.getChannels165());
		 
		  //delete(poAdd);
		}
		listsupportedchannels.push_back(poAdd);
		}	
		}
		else
		{
			LOG_INFO("WapdmanServerComponent::vGlueonSupportedChannelsGetResponse No Response");
		}
		if(m_bool == true)
		{
		LOG_INFO("vGlueonSupportedChannelsGetResponse::sendSupportedChannelsGetUpdate m_bool variable check %d",m_bool);
		sendSupportedChannelsGetUpdate(listsupportedchannels,m_u32act);
		m_bool = false;
		LOG_INFO("vGlueonSupportedChannelsGetResponse::sendSupportedChannelsGetUpdate m_bool variable check %d",m_bool);
		}	
	}
	
	/*HWFeatures -- Get Functionality Manually Added */
	void WapdmanServerComponent::onHWFeaturesGet(const ::boost::shared_ptr< HWFeaturesGet >& hWFeatures)
	{
		LOG_INFO("WapdmanServerComponent::onHWFeaturesGet");
		m_u32act = hWFeatures->getAct();
		m_bool = true;
		if(hWFeatures)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueHWFeaturesGetRequest();
		}
		else
		{
			LOG_INFO("onHWFeaturesGet is NULL");
		}	
	}
	void WapdmanServerComponent::vGlueonHWFeaturesGetResponse(::std::vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList > hwfeaturelist,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonHWFeaturesGetResponse");
		::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList > listhwfeatures;
		if(hwfeaturelist.size())
		{
		LOG_INFO("WapdmanServerComponent::vGlueonHWFeaturesGetResponse");
		for(uint16 u16Count=0;u16Count<hwfeaturelist.size();u16Count++)
		{
		LOG_INFO("WapdmanServerComponent::vGlueonHWFeaturesGetResponse loop");
		::Stub::WapdmanServiceTypes::StructHWFeaturesList *poAdd = new ::Stub::WapdmanServiceTypes::StructHWFeaturesList();
		StructHWFeaturesList rsInsert = hwfeaturelist.at(u16Count);
		if(poAdd)
		{
		  LOG_INFO("WapdmanServerComponent::vGlueonHWFeaturesGetResponse if case");
		  uint16 modeB = rsInsert.getModeB();
		  LOG_INFO("modeB %d",modeB);
		  uint16 modeG = rsInsert.getModeG();
		  LOG_INFO("modeG %d",modeG);
		  uint16 modeA = rsInsert.getModeA();
		  LOG_INFO("modeA %d",modeA);
		  poAdd->setModeB(rsInsert.getModeB()); 
		  poAdd->setModeG(rsInsert.getModeG()); 
		  poAdd->setModeA(rsInsert.getModeA());	
		  //delete(poAdd);
		}
		listhwfeatures.push_back(poAdd);
		}	
		}
		else
		{
			LOG_INFO("WapdmanServerComponent::vGlueonHWFeaturesGetResponse No Response");
		}
		if(m_bool == true)
		{
		LOG_INFO("vGlueonHWFeaturesGetResponse::sendHWFeaturesGetUpdate m_bool variable check %d",m_bool);
		sendHWFeaturesGetUpdate(listhwfeatures,m_u32act);
		m_bool = false;
		LOG_INFO("vGlueonHWFeaturesGetResponse::sendHWFeaturesGetUpdate m_bool variable check %d",m_bool);
		}	
	}
		
	
	/*RegisterAgent*/
	void WapdmanServerComponent::onRegisterAgentRequest (const ::boost::shared_ptr< RegisterAgentRequest >& registerAgent)
	{
		LOG_INFO("WapdmanServerComponent::onRegisterAgentRequest");
		if(registerAgent)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueRegisterAgentRequest(registerAgent->getPath());
		}
		else
		{
			LOG_INFO("registerAgent is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonRegisterAgentResponse(uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonDeAuthenticateStationResponse");
		sendRegisterAgentResponse(m_u32act);
	}
	
	/*UnregisterAgent*/
	void WapdmanServerComponent::onUnregisterAgentRequest (const ::boost::shared_ptr< UnregisterAgentRequest >& unregisterAgent)
	{
		LOG_INFO("WapdmanServerComponent::onUnregisterAgentRequest");
		if(unregisterAgent)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueUnregisterAgentRequest(unregisterAgent->getPath());
		}
		else
		{
			LOG_INFO("unregisterAgent is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonUnregisterAgentResponse(uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonUnregisterAgentResponse");
		sendUnregisterAgentResponse(m_u32act);
	}
	
	/*FindAccessPoint*/
	void WapdmanServerComponent::onFindAccessPointRequest (const ::boost::shared_ptr< FindAccessPointRequest >& findAccessPoint)
	{
		LOG_INFO("WapdmanServerComponent::onFindAccessPointRequest");
		if(findAccessPoint)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueFindAccessPointRequest(findAccessPoint->getPattern());
		}
		else
		{
			LOG_INFO("findAccessPoint is NULL");
		} 
	}
	void WapdmanServerComponent::vGlueonFindAccessPointResponse(::std::string accesspoint,uint32 act)
	{
		  LOG_INFO("WapdmanServerComponent::vGlueonFindAccessPointResponse");
		  sendFindAccessPointResponse(accesspoint,m_u32act);
	}
	
	void WapdmanServerComponent::vGlueonAccessPointAddedResponse(::std::string Value)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonAccessPointAddedResponse");
		sendAccessPointAddedEvent(Value);
		 
	}
	void WapdmanServerComponent::vGlueonAccessPointRemovedResponse(::std::string Value)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonAccessPointAddedResponse");
		sendAccessPointRemovedEvent(Value);
		 
	}
	
	/* GetAccessPoints */
	void WapdmanServerComponent::onGetAccessPointsRequest(const ::boost::shared_ptr< GetAccessPointsRequest >& GetAccessPoints)
	{
		LOG_INFO("WapdmanServerComponent::onGetAccessPointsRequest");
		m_u32act = GetAccessPoints->getAct();
		if(GetAccessPoints)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueGetAccessPointsRequest();
		}
		else
		{
			LOG_INFO("GetAccessPoints is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonGetAccessPointsResponse(::std::vector< ::Stub::WapdmanServiceTypes::StructAPList > Srclist)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonGetAccessPointsResponse");
		::std::vector< ::Stub::WapdmanServiceTypes::StructAPList >::iterator it;
		for(it = Srclist.begin(); it != Srclist.end(); ++it)
		{
		LOG_INFO("WapdmanServerComponent::vGlueonGetAccessPointsResponse Iteration");
		std::string ObjectPath = it->getObjPath();
		LOG_INFO("ObjectPath %s",ObjectPath.c_str());
		std::string interface = it->getInterface();
		LOG_INFO("interface %s",interface.c_str());
		std::string MAC = it->getAddress();
		LOG_INFO("MAC %s",MAC.c_str());
		//std::string COP = it->getCurrentOperatingChannel();
		//LOG_INFO("COP %s",COP.c_str());
		std::string HWFeatures = it->getHWFeatures();
		LOG_INFO("HWFeatures %s",HWFeatures.c_str());
		std::string Security = it->getSecurity();
		LOG_INFO("Security %s",Security.c_str());
		std::string SupportedChannels = it->getSupportedChannels();
		LOG_INFO("SupportedChannels %s",SupportedChannels.c_str());
		/*if(it == Srclist.end())
		{
		LOG_INFO("sendGetAccessPointsResponse Will be Send to the TML");
		sendGetAccessPointsResponse(*it,m_u32act);
		}*/
		//LOG_INFO("MacAddress %s",it->getAddress());
		//LOG_INFO("Interface %s",it->getInterface());
		sendGetAccessPointsResponse(*it,m_u32act);
		/*	if(it == (Srclist.end()-1))
		{
		LOG_INFO("sendGetAccessPointsResponse Will be Send to the TML");
		sendGetAccessPointsResponse(*it,m_u32act);
		}*/
		}
		Srclist.clear();
	}
	
	/* Get */
	void WapdmanServerComponent::onGetRequest(const ::boost::shared_ptr< GetRequest >& get)
	{
		LOG_INFO("WapdmanServerComponent::onGetRequest");
		m_u32act = get->getAct();
		if(get)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueGetRequest(get->getInterface_name(),get->getProperty_name());
		}
		else
		{
			LOG_INFO("Get is NULL");
		}
	}
	/*void WapdmanServerComponent::vGlueonGetResponse(std::string value,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonGetResponse");
		//sendGetResponse(value,m_u32act);
	}*/
	
	//getSSIDRequest - JIJI
	/*void WapdmanServerComponent::onGetSSIDRequest (const ::boost::shared_ptr< GetSSIDRequest >& getSSID)
	{
		LOG_INFO("WapdmanServerComponent::onGetSSIDRequest");
		m_u32act = getSSID->getAct();
		if(getSSID)
		{
			WapdmanClientComponentProperties::rfGetClientComponentPropertiesInstance().vGluegetSSIDRequest();
		}
		else
		{
			LOG_INFO("getSSID is NULL");
		}
	}*/
	
	/* MacAddress - Associated Stations -- Get Functionality Manually Added */
	void WapdmanServerComponent::onMacAddressAsGetRequest (const ::boost::shared_ptr< MacAddressAsGetRequest >& macAddressAsGet)
	{
		LOG_INFO("WapdmanServerComponent::onMacAddressAsGetRequest");
		m_u32act = macAddressAsGet->getAct();
		m_bool = true;
		if(macAddressAsGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueMacAddressAsGetRequest();
		}
		else
		{
			LOG_INFO("macAddressAsGet is NULL");
		}		
	}
	void WapdmanServerComponent::vGlueonMacAddressAsGetResponse(::std::string macaddressasget,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonMacAddressAsGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("vGlueonMacAddressAsGetResponse m_bool variable check before %d",m_bool);
		sendMacAddressAsGetResponse(macaddressasget,m_u32act);
		m_bool = false;
		LOG_INFO("vGlueonMacAddressAsGetResponse m_bool variable check  after %d",m_bool);
		}
		
	}
	
	/* Accesspoint - Associated Stations -- Get Functionality Manually Added */
	void WapdmanServerComponent::onAccesspointAsGetRequest (const ::boost::shared_ptr< AccesspointAsGetRequest >& accesspointAsGet)
	{
		LOG_INFO("WapdmanServerComponent::onAccesspointAsGetRequest");
		m_u32act = accesspointAsGet->getAct();
		if(accesspointAsGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueAccesspointAsGetRequest();
		}
		else
		{
			LOG_INFO("accesspointAsGet is NULL");
		}		
	}
	void WapdmanServerComponent::vGlueonAccesspointAsGetResponse(::std::string accesspointobjpath,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonAccesspointAsGetResponse");
		sendAccesspointAsGetResponse(accesspointobjpath,m_u32act);
	}
	
	/* Interface - Associated Stations -- Get Functionality Manually Added */
	void WapdmanServerComponent::onInterfaceAsGetRequest (const ::boost::shared_ptr< InterfaceAsGetRequest >& interfaceAsGet)
	{
		LOG_INFO("WapdmanServerComponent::onInterfaceAsGetRequest");
		m_u32act = interfaceAsGet->getAct();
		m_bool = true;
		if(interfaceAsGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueInterfaceAsGetRequest();
		}
		else
		{
			LOG_INFO("interfaceAsGet is NULL");
		}		
	}
	void WapdmanServerComponent::vGlueonInterfaceAsGetResponse(::std::string interfaceasget,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonInterfaceAsGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("vGlueonInterfaceAsGetResponse m_bool variable check before %d",m_bool);
		sendInterfaceAsGetResponse(interfaceasget,m_u32act);
		m_bool = false;
		LOG_INFO("vGlueonInterfaceAsGetResponse m_bool variable check  after %d",m_bool);
		}
		
	}
	
	/* IPAddress - Associated Stations -- Get Functionality Manually Added */
	void WapdmanServerComponent::onIPAddressAsGetRequest (const ::boost::shared_ptr< IPAddressAsGetRequest >& iPAddressAsGet)
	{
		LOG_INFO("WapdmanServerComponent::onIPAddressAsGetRequest");
		m_u32act = iPAddressAsGet->getAct();
		if(iPAddressAsGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueIPAddressAsGetRequest();
		}
		else
		{
			LOG_INFO("iPAddressAsGet is NULL");
		}		
	}
	void WapdmanServerComponent::vGlueonIPAddressAsGetResponse(::std::string ipaddressasget,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonIPAddressAsGetResponse");
		sendIPAddressAsGetResponse(ipaddressasget,m_u32act);
	}
	
	/* Hostname - Associated Stations -- Get Functionality Manually Added */
	void WapdmanServerComponent::onHostnameAsGetRequest (const ::boost::shared_ptr< HostnameAsGetRequest >& hostnameAsGet)
	{
		LOG_INFO("WapdmanServerComponent::onHostnameAsGetRequest");
		m_u32act = hostnameAsGet->getAct();
		if(hostnameAsGet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueHostnameAsGetRequest();
		}
		else
		{
			LOG_INFO("hostnameAsGet is NULL");
		}		
	}
	void WapdmanServerComponent::vGlueonHostnameAsGetResponse(::std::string hostnameasget,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonHostnameAsGetResponse");
		sendHostnameAsGetResponse(hostnameasget,m_u32act);
	}
	
	/* Tethering -- Get Function Manual */
	void WapdmanServerComponent::onTetheringGet(const ::boost::shared_ptr< TetheringGet >& tethering)
	{
		LOG_INFO("WapdmanServerComponent::onTetheringGetRequest");
		m_u32act = tethering->getAct();
		m_bool = true;
		if(tethering)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueTetheringGetRequest();
		}
		else
		{
			LOG_INFO("tethering is NULL");
		}
		
	}
	void WapdmanServerComponent::vGlueonTetheringGetResponse(bool tethering,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonTetheringGetResponse");
		if(m_bool == true)
		{
		LOG_INFO("vGlueonTetheringGetResponse::sendTetheringGetResponse m_bool variable check before %d",m_bool);
		sendTetheringGetUpdate(tethering,m_u32act);
		m_bool = false;
		LOG_INFO("sendTetheringGetUpdate m_bool variable check  after %d",m_bool);
		}	
	}
	
	void WapdmanServerComponent::onTetheringSetRequest (const ::boost::shared_ptr< TetheringSetRequest >& tetheringSet)
	{
		LOG_INFO("WapdmanServerComponent::onTetheringSetRequest");
		m_u32act = tetheringSet->getAct();
		if(tetheringSet)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueTetheringSetRequest(tetheringSet->getTethering());
		}
		else
		{
			LOG_INFO("tetheringSet is NULL");
		}	
	}
	void WapdmanServerComponent::onIPv4PoolGet(const ::boost::shared_ptr< IPv4PoolGet >& iPv4Pool)
	{
		LOG_INFO("WapdmanServerComponent::onIPv4PoolGetRequest");
		m_u32act = iPv4Pool->getAct();
		m_bool = true;
		if(iPv4Pool)
		{
			WapdmanClientComponent::rfGetClientComponentInstance().vGlueIPv4PoolGetRequest();
		}
		else
		{
			LOG_INFO("iPv4Pool is NULL");
		}
	}
	void WapdmanServerComponent::vGlueonIPv4PoolGetResponse(::std::vector< ::Stub::WapdmanServiceTypes::StructIPv4List > ipv4list,uint32 act)
	{
		LOG_INFO("WapdmanServerComponent::vGlueonIPv4PoolGetResponse");
		::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List > listipv4items;
		if(ipv4list.size())
		{
		LOG_INFO("WapdmanServerComponent::vGlueonIPv4PoolGetResponse");
		for(uint16 u16Count=0;u16Count<ipv4list.size();u16Count++)
		{
		LOG_INFO("WapdmanServerComponent::vGlueonIPv4PoolGetResponse loop");
		::Stub::WapdmanServiceTypes::StructIPv4List *poAdd = new ::Stub::WapdmanServiceTypes::StructIPv4List();
		StructIPv4List rsInsert = ipv4list.at(u16Count);
		if(poAdd)
		{
		  LOG_INFO("WapdmanServerComponent::vGlueonIPv4PoolGetResponse if case");
		std::string startaddress = rsInsert.getStart();
		LOG_INFO("startaddress %s",startaddress.c_str());
		std::string endaddress = rsInsert.getEnd();
		LOG_INFO("endaddress %s",endaddress.c_str());
		std::string Netmask = rsInsert.getNetmask();
		LOG_INFO("Netmask %s",Netmask.c_str());
		std::string Network = rsInsert.getNetwork();
		LOG_INFO("Network %s",Network.c_str());
		std::string Broadcast = rsInsert.getBroadcast();
		LOG_INFO("Broadcast %s",Broadcast.c_str());
		uint32 leasetime = rsInsert.getLeasetime();
		LOG_INFO("leasetime %d",leasetime);
		std::string Router = rsInsert.getRouter();
		LOG_INFO("Broadcast %s",Router.c_str());
		poAdd->setStart(rsInsert.getStart());
		poAdd->setEnd(rsInsert.getEnd());
		poAdd->setNetmask(rsInsert.getNetmask());
		poAdd->setNetwork(rsInsert.getNetwork());
		poAdd->setBroadcast(rsInsert.getBroadcast());
		poAdd->setLeasetime(rsInsert.getLeasetime());
		poAdd->setRouter(rsInsert.getRouter());
		}
		listipv4items.push_back(poAdd);
		}	
		}
		else
		{
			LOG_INFO("WapdmanServerComponent::vGlueonIPv4PoolGetResponse No Response");
		}
		if(m_bool == true)
		{
		LOG_INFO("vGlueonIPv4PoolGetResponse::sendHWFeaturesGetUpdate m_bool variable check %d",m_bool);
		sendIPv4PoolGetUpdate(listipv4items,m_u32act);
		m_bool = false;
		LOG_INFO("vGlueonIPv4PoolGetResponse::sendHWFeaturesGetUpdate m_bool variable check %d",m_bool);
		}	
	}
	
	
} 
} 


