/**
 * @file tech_manager.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_mw\aifi_ap_direct_manager
 * @brief
 *
 * @{
 */

#ifndef TECH_MANAGER_H
#define TECH_MANAGER_H

#include <linux/nl80211.h>

typedef
struct __wireless_driver_ops
{
    const char *name;
    enum nl80211_iftype iftype;
    void* (*add) (unsigned int index,
                  const char *name,
                  const char *address);
    int (*remove) (unsigned int index,
                   const char *name,
                   const char *address);
    int (*start) (void *data);
    int (*stop) (void *data);
} wirelessdriverops;

int wireless_tech_init (char *apdevices, char *p2pdevices);
int wireless_tech_deinit ();
int wireless_tech_driver_register (wirelessdriverops *driver);
int wireless_tech_driver_unregister (wirelessdriverops *driver);
int wireless_tech_handle_orphans (const char *name);

#endif  // TECH_MANAGER_H

/** @} */
