/**
 * @file manager_if.h
 * @author RBEI/ECO3-Karthikeyan Madeswaran
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */


#ifndef DECLARATIONS_H
#define DECLARATIONS_H

#include <glib.h>

#define WAPDMAN_BUS_NAME                    			"org.bosch.wapdman"
#define WAPDMAN_OBJECT_MANAGER_INTERFACE_NAME    		"org.bosch.wapdman.ObjectManager"
#define WAPDMAN_MANAGER_INTERFACE_NAME    				"org.bosch.wapdman.Manager"
#define WAPDMAN_ACCESSPOINT_INTERFACE_NAME    			"org.bosch.wapdman.Accesspoint"
#define WAPDMAN_ASSOCIATEDSTATION_INTERFACE_NAME    	"org.bosch.wapdman.AssociatedStation"
#define WAPDMAN_ACCESSPOINT_DHCPDNSCONF_INTERFACE_NAME  "org.bosch.wapdman.Accesspoint.DHCPDNSConfiguration"
#define WAPDMAN_ACCESSPOINT_TETHERING_SETTINGS_INTERFACE_NAME       "org.bosch.wapdman.Accesspoint.TetheringSettings"
#define ORG_FREEDESKTOP_PROPERTIES                      "org.freedesktop.DBus.Properties"

#define WAPDMAN_BUS_PATH                    			"/org/bosch/wapdman"
#define WAPDMAN_ACCESSPOINT_INTERFACE_PATH    			"AccessPoint"
#define WAPDMAN_ASSOCIATEDSTATION_INTERFACE_PATH    	"AssociatedStation"

#define WAPDMAN_OBJMAN_OBJECT_PATH                      "/"
#define WAPDMAN_MANAGER_OBJECT_PATH                     "/org/bosch/wapdman/Manager"

#define IP_POOL_START		2
#define IP_POOL_END 		12

#define SSID_MAX_LEN 	32
#define MAC_ID_LENGTH   17

/**
 * forward declaration*/
typedef struct _interface_data InterfaceTable;
typedef struct _property_data PropertyTable;
typedef enum _property_flags PropertyFlags;

/**An exported Setter for properties of all interfaces*/
typedef
int (*PropertySet) (const PropertyTable *property,
                    GVariant *value,
                    void *invocation,
                    void *data);

typedef
int (*PropertyGet) (const PropertyTable *property,
                    GVariant **value,
                    void *data);

enum _property_flags {
    PROPERTY_FLAG_NONE,
    PROPERTY_FLAG_READONLY,
    PROPERTY_FLAG_READWRITE
};

struct _property_data {
    char *name;
    char *type;
    PropertyFlags flags;
	PropertySet set;
    PropertyGet get;
};

struct _interface_data {
    char *name;
    const PropertyTable *properties;
    void *userdata;
};

#endif //DECLARATIONS_H

/** @} */
