/**
 * @file dbus-cli.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef DBUS_CLI_H
#define DBUS_CLI_H

#include <glib.h>

typedef void (*connect_func) (char *name, void *userdata);
typedef void (*disconnect_func) (char *name, void *userdata);
typedef void (*dbus_callback) (GVariant *var, void *userdata);

int dbus_cli_init (void);
int dbus_cli_deinit (void);

int dbus_has_name_owner (const char *const name,
                         dbus_callback cb,
                         void *userdata);
int dbus_get_name_owner (const char *const name,
                         dbus_callback cb,
                         void *userdata);
unsigned int dbus_add_service_watch(const char *const service,
                            connect_func connect,
                            disconnect_func disconnect,
                            void *data);
int dbus_rm_service_watch (const char *const service,
                           connect_func connect,
                           disconnect_func disconnect);
int dbus_rm_watch (const unsigned int id);


#endif  //DBUS_CLI_H

/** @} */
