/**
 * @file associatedstation_if.h
 * @author RBEI/ECO3-Karthikeyan Madeswaran
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef ASSOCIATEDSTATION_IF_H
#define ASSOCIATEDSTATION_IF_H

#include <glib.h>

struct access_point;
struct associated_station;

struct associated_station *associated_station_create (GDBusConnection *conn,
                                                      struct access_point *ap,
                                                      const char *macaddress,
                                                      const char *interface);
int associated_station_set_ipaddress (struct associated_station *station,
                                      char *ipaddress);
int associated_station_set_hostname (struct associated_station *station,
                                     char *hostname);

int associated_station_cleanup (gpointer data);

char* associated_station_get_macaddress (const struct associated_station *station);
char* associated_station_get_accesspoint (const struct associated_station *station);
char* associated_station_get_objectpath (const struct associated_station *station);
char* associated_station_get_hostname (const struct associated_station *station);
char* associated_station_get_interface (const struct associated_station *station);
int associated_station_get_properties (struct associated_station *station, GVariantBuilder *builder);

int associated_station_register_interfaces (struct associated_station *station);

#endif //ASSOCIATEDSTATION_IF_H

/** @} */
