/**
 * @file accesspoint_if.h
 * @author RBEI/ECO3-Karthikeyan Madeswaran
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef ACCESSPOINT_IF_H
#define ACCESSPOINT_IF_H

#include <glib.h>
#include <gio/gio.h>
#include "inc/declarations.h"

struct access_point;
struct apdbuservice;
struct associated_station;

typedef
enum _change_reason {
    STATION_CHANGE_NONE,
    STATION_CHANGE_ADDED,
    STATION_CHANGE_NOCHANGE,
    STATION_CHANGE_CHANGED,
    STATION_CHANGE_REMOVED
} changereason;

struct station_changed
{
    changereason reason;
    struct associated_station *station;
};

struct set_ssid_data
{
    char ssid [SSID_MAX_LEN];
    size_t length;
};

struct set_operating_channels
{
    unsigned int length;
    char *hwmode;
    gboolean is5ghz;
    unsigned int *channels;
};

struct vendor_element
{
    char *ies;
    unsigned long length;
};

char *access_point_get_objpath (struct apdbuservice *ap);
int access_point_update_property (struct apdbuservice *service, const char *property);
int access_point_emit_stationsChanged (void *added, void *removed, struct apdbuservice *ap);
int access_point_get_properties (struct apdbuservice *ap, GVariantBuilder *builder);
void *access_point_get_approxy (struct apdbuservice *ap);
int access_point_handle_results (struct apdbuservice *ap, GDBusMethodInvocation *invocation,
                                 int result, int opcode, void *data);
struct apdbuservice* access_point_create_service (GDBusConnection *conn, struct access_point *ap);
int access_point_service_destroy (struct apdbuservice *service);

#endif //ACCESSPOINT_IF_H

/** @} */
