/**
 * @file rttables.c
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <glib.h>
#include "inc/utils.h"
#include <log.h>

#define SYS_CONFIGURATION           "/etc"
#define IP_ROUTE2_CONFIGURATION     SYS_CONFIGURATION "/" "iproute2"
#define IP_ROUTE2_RTTABLES          IP_ROUTE2_CONFIGURATION "/" "rt_tables"

#define RT_NAME_MAX_LEN             512

char*
get_rt_table_name_from_id (unsigned int table)
{
    int ret, avail = 0;
    FILE *fp;
    char line [RT_NAME_MAX_LEN],
            *temp, name [RT_NAME_MAX_LEN];
    unsigned int id = 0;

    ret = file_exists (IP_ROUTE2_RTTABLES, FILE_TYPE_REG);
    return_val_if_fail (ret == 1, NULL);

    fp = fopen (IP_ROUTE2_RTTABLES, "r");
    return_val_if_fail (fp, NULL);

    memset (line, 0, sizeof (line));
    memset (name, 0, sizeof (name));
    while (fgets (line, sizeof (line), fp)) {

        temp = line;
        while (*temp == ' ' || *temp == '\t')
            temp++;

        if (*temp == '#' || *temp == '\n' || *temp == 0)
            continue;

        if (sscanf (temp, "0x%x %s\n", &id, name) != 2 &&
                sscanf (temp, "0x%x %s #", &id, name) != 2 &&
                sscanf (temp, "%d %s\n", &id, name) != 2 &&
                sscanf (temp, "%d %s #", &id, name) != 2)
            continue;

        (void) sscanf (temp, "%d %s", &id, name);
        if (id == table) {
            avail = 1;
            break;
        }

        memset (line, 0, sizeof (line));
        memset (name, 0, sizeof (name));
    }

    fclose (fp);
    return avail == 0 ? NULL : g_strdup (name);
}

/** @} */
