/**
 * @file ipconfig.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef IPCONFIG_H
#define IPCONFIG_H

typedef
enum __ip_config_type
{
    IPCONFIG_TYPE_UNKNOWN,
    IPCONFIG_TYPE_IPV4,
    IPCONFIG_TYPE_IPV6,
    IPCONFIG_MAX_TYPES
} ipconfigtype;

typedef
struct __ip_address {
    int family;
    unsigned char prefixlen;
    char *local;
    char *peer;
    char *broadcast;
    char *gateway;
} ipaddress;

typedef
struct __ipconfig_ops
{
    const char *name;
    void (*dev_up) (const char *name);
    void (*dev_lower_up) (const char *name);
    void (*dev_down) (const char *name);
    void (*dev_lower_down) (const char *name);
    int (*addr_added) (int index, const char *name, int family, const char *address);
    int (*addr_removed) (int index, const char *name, int family, const char *address);
} ipconfig_ops;

const char* ipconfig_type2str (const ipconfigtype type);
int ipconfig_newlink (int index,
                      unsigned int flags,
                      const char *name);
int ipconfig_dellink (int index);
int ipconfig_add_address (unsigned int index,
                          unsigned char family,
                          const char *address,
                          const char *peer,
                          unsigned char prefixlen,
                          const char *broadcast);
int ipconfig_delete_address (unsigned int index,
                             unsigned char family,
                             const char *address,
                             const char *peer,
                             unsigned char prefixlen,
                             const char *broadcast);
char* ipconfig_get_address (unsigned int index);
int ipconfig_notifier_register (ipconfig_ops *ops);
int ipconfig_notifier_unregister (ipconfig_ops *ops);
int ipconfig_init ();
int ipconfig_deinit ();


#endif //IPCONFIG_H

/** @} */
