/**
 * @file fib.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef FIB_H
#define FIB_H

typedef struct _routing_rule routing_rule_t;

typedef
struct __fib_ops
{
    int (*rule_added) (routing_rule_t *rule);
    int (*rule_deleted) (routing_rule_t *rule);
} fib_ops;

int fib_init ();
int fib_deinit ();

#define fib_rule_ref(rule) fib_rule_ref_impl(rule, __FILE__, __LINE__, __func__)
#define fib_rule_unref(rule) fib_rule_unref_impl(rule, __FILE__, __LINE__, __func__)

routing_rule_t *fib_rule_ref_impl (routing_rule_t *rule, const char *file,
                                   int line, const char *caller);
void fib_rule_unref_impl (routing_rule_t *rule, const char *file, int line,
                          const char *caller);
int fib_modify_ip_rule (const char *rule);

#endif // FIB_H
/** @} */
