/**
 * @file device.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef DEVICE_H
#define DEVICE_H

struct net_device;

typedef
enum __device_type
{
    DEVICE_TYPE_NONE,
    DEVICE_TYPE_BLUETOOTH,
    DEVICE_TYPE_BOND,
    DEVICE_TYPE_BRDIGE,
    DEVICE_TYPE_CELLULAR,
    DEVICE_TYPE_ETHERNET,
    DEVICE_TYPE_GADGET,
    DEVICE_TYPE_HSR,
    DEVICE_TYPE_VLAN,
    DEVICE_TYPE_WIMAX,
    DEVICE_TYPE_WLAN,
    DEVICE_TYPE_VXLAN,
    DEVICE_TYPE_MAX
} devicetype;

typedef
enum {
    DEVSTATE_UNKNOWN,
    DEVSTATE_UNMANAGED,
    DEVSTATE_UNAVAILABLE,
    DEVSTATE_MANAGED,
    DEVSTATE_PREPARING,
    DEVSTATE_STARTING,
    DEVSTATE_CONFIGURING_IP,
    DEVSTATE_ACTIVATED,
    DEVSTATE_DEACTIVATING,
    DEVSTATE_FAILED
} devicestate;

typedef
struct __device_watch {
    char *client;
    int (*device_added) (unsigned int index,
                         const char *name,
                         const char *address);
    int (*device_removed) (unsigned int index,
                           const char *name,
                           const char *address);
} deviceops;

const char *device_get_name (const struct net_device *device);
const char *device_get_qdisc (const struct net_device *device);
const char *device_get_address (const struct net_device *device);
const char *device_get_bcastaddress (const struct net_device *device);
unsigned int device_get_family (const struct net_device *device);
unsigned int device_get_arptype (const struct net_device *device) ;
unsigned int device_get_index (const struct net_device *device);
unsigned int device_get_flags (const struct net_device *device);
unsigned int device_get_mtu (const struct net_device *device);
unsigned int device_get_txqlen (const struct net_device *device);
unsigned int device_get_numtxqueues (const struct net_device *device);
unsigned int device_get_numrxqueues (const struct net_device *device);
unsigned int device_get_group (const struct net_device *device);
unsigned int device_get_carrier (const struct net_device *device);
unsigned int device_get_operstate (const struct net_device *device);
devicetype device_get_type (const struct net_device *device);
const char *device_type2str (const devicetype type);
const char *device_state2str (const devicestate state);
struct net_device *device_get (const unsigned int index);

int device_init ();
int device_deinit ();
int device_can_manage (int index);
int device_notifier_register (deviceops *ops);
int device_notifier_unregister (deviceops *ops);


#endif //DEVICE_H
