/**
 * @file session.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef SESSION_H
#define SESSION_H

typedef
enum __session_state
{
    /* invalid state */
    STATE_INVALID,

    /* Session is in Disconnected
     * state */
    STATE_DISCONNECTED,

    /* Session is in Connected state */
    STATE_CONNECTED,

    /* Session has active internet
     * connection */
    STATE_ONLINE
} Session_state;

typedef
struct __ipv4_info
{
    /* ipv4 address */
    char *address;

    /* netmask */
    char *netmask;

    /* gateway ipv4 address */
    char *gw;
} ipv4;

typedef
struct __technology
{
    /* type of the tech */
    char *bearer;

    /* name of the active
     * service */
    char *service;

    /* interface name */
    char *interface;

    /* current state of the
     * tech */
    Session_state state;

    /* ipv4 details if the tech is
     * connected */
    ipv4 *ipdetails;
} techinfo;

typedef
struct session_notifier {
    const char *name;
    void (*default_changed) (techinfo *defaulttech);
} notifier_ops;

/* exported functions */
int session_init ();
int session_deinit ();
int session_notifier_register (notifier_ops *ops);
int session_notifier_unregister (notifier_ops *ops);

#endif //SESSION_H


/** @} */
