/**
 * @file log_file.c
 * @author RBEI/ECO3-Murali Kakkanavar
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <time.h>
#include <main.h>
#include <log.h>
#include <log_file.h>

static logops
file_utils = {
        .util_name = "FILE",
        .util_open = file_open,
        .util_close = file_close,
        .util_log = file_log
};

static FILE *debug_file = NULL;

int
log_open_debug_file (const char *path)
{
    int ret;
    FILE *fp;

    if (!path)
        return 0;

    if (debug_file) {
        fclose (debug_file);
        debug_file = NULL;
    }

    fp = fopen (path, "w+");
    if (!fp)
        return -errno;

    ret = setvbuf (fp, NULL, _IOLBF, 0);
    if (ret != 0) {
        fclose (fp);
        return -errno;
    }

    debug_file = fp;
    return 0;
}

int
log_close_debug_file ()
{
    int ret = 0;

    if (debug_file) {
        ret = fclose (debug_file);
        if (ret != 0)
            return -errno;
        debug_file = NULL;
    }

    return ret;
}

int
log_file_init()
{
    const char *debugfile;

    if(NULL != (debugfile = get_log_file())) {
        (void) log_open_debug_file (debugfile);
        log_util_register(&file_utils);
    }

    return 0;
}

int
log_file_deinit()
{
    const char *debugfile;

    if(NULL != (debugfile = get_log_file())) {
        log_util_unregister(&file_utils);
        (void) log_close_debug_file ();
    }

    return 0;
}

int
file_open()
{
    return 0;
}

int
file_close()
{
    return 0;
}

int
file_log(int log_level, const char *str, va_list args)
{
    struct timeval tmval;
    char tme [TIMESTAMP], buf [BUFFER];

    (void)log_level;
    memset (tme, 0, sizeof (tme));
    memset (buf, 0, sizeof (buf));

    if ( !timestamp (tme) ) {
        if ( !gettimeofday (&tmval, NULL) ) {
            snprintf(buf, BUFFER, "%s.%06lu ", tme,
                     tmval.tv_usec);
            if (debug_file)
                fprintf (debug_file, "%s ", buf);
        } else {
            if (debug_file)
                fprintf (debug_file, "%s ", tme);
        }
    }

    if (debug_file) {
        vfprintf (debug_file, str, args);
        fprintf (debug_file, "\n");
    }

    return 0;
}

/** @} */
