/**
 * @file iptables-wrapper.c
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#include <errno.h>
#include <glib.h>
#include <iptables-wrapper.h>
#include <sys/capability.h>
#include <capabilities.h>
#include <firewall.h>
#include <log.h>
#include <capabilities.h>
#include <wifi_rootdaemon_client.h>

static int
iptw_commit_rule (const char *const rule)
{
    int err = 0;
    CmdData result;
    char *r;

    return_val_if_fail (rule, -EINVAL);

	r = g_strdup (rule);

    result = execRootCommand (WIFI_CLIENT_NAME, IPT_COMMIT_RULE, r);

    if (result.errorNo == ERR_NONE) {
        INFO ("\"%s\" rule committed successfully", r);
    } else {
        ERROR ("Failed to commit rule : \"%s\"", r);
        err = -EIO;
    }

    g_free (r);
    return err;
}

static firewall_ops
iptw_firewall_ops = {
    .name		= "iptables_wrapper",
    .commitrule	= iptw_commit_rule,
};

int
iptw_init (void)
{
    DEBUG ("");

    /* do not register the driver if we already have the
     * NET_ADMIN capabilities */
    if (get_capabilities (CAP_NET_ADMIN, CAP_EFFECTIVE) == 1)
        return 0;

    return firewall_driver_register (&iptw_firewall_ops);
}

int
iptw_deinit (void)
{
    DEBUG ("");

    if (get_capabilities (CAP_NET_ADMIN, CAP_EFFECTIVE) == 1)
        return 0;

    return firewall_driver_unregister (&iptw_firewall_ops);
}

/** @} */
