/**
 * @file firewall.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef FIREWALL_H
#define FIREWALL_H

typedef
struct __wapman_firewall_ops
{
    const char *name;
    int (*commitrule) (const char *const rule);
} firewall_ops;

typedef
struct __fw_context
{
    GList *rules;
} fwcontext;

int firewall_driver_register (firewall_ops *ops);
int firewall_driver_unregister (firewall_ops *ops);
int firewall_init (void);
int firewall_deinit (void);
fwcontext* firewall_create_context (void);
void firewall_cleanup_context (fwcontext *ctx);
int firewall_add_rule (fwcontext *ctx, const char *table,
                       const char *chain, const char *rule_fmt, ...);
int firewall_remove_rule (fwcontext *ctx, const unsigned int id);
int firewall_enable_rule (fwcontext *ctx, const int commit, const unsigned int id);
int firewall_disable_rule (fwcontext *ctx,const int commit, const unsigned int id);
int firewall_enable (fwcontext *ctx);
int firewall_disable (fwcontext *ctx);

#endif // FIREWALL_H

/** @} */
