/**
 * @file task.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef TASK_H
#define TASK_H

typedef
enum {
    TASK_TYPE_INVALID,
    TASK_TYPE_AP,
    TASK_TYPE_P2P,
    MAX_TASKS
} tasktype;

typedef
enum {
    TASK_STATE_INVALID,
    TASK_STATE_IDLE,
    TASK_STATE_REQUESTED,
    TASK_STATE_INTERRUPTED,
    TASK_STATE_COMPLETED
} taskstate;

struct wapdman_task;

typedef void (*timeout_func) (struct wapdman_task *task,
                              void *data);

int task_get_next_subtask (struct wapdman_task *task);
int task_add_subtask (struct wapdman_task *task, int opcode);
int task_rm_subtask (struct wapdman_task *task,int opcode);
gboolean task_is_ongoing (GList **queue);
int task_remove (GList **queue, struct wapdman_task *task);
void *task_get_invocation (struct wapdman_task *task);
int task_get_opcode (struct wapdman_task *task);
void *task_get_data(struct wapdman_task *task);
int task_set_state (struct wapdman_task *task, taskstate state);
int task_get_state (struct wapdman_task *task);
int task_set_ongoingoperation (struct wapdman_task *task, int opcode);
int task_get_ongoingoperation (struct wapdman_task *task);
const char* task_type2string (tasktype type);
struct wapdman_task *task_find (GList **queue, tasktype type, int opcode);
void task_cleanup (struct wapdman_task *task);
int task_add_toqueue (GList **taskqueue, struct wapdman_task *task);
struct wapdman_task* task_process_next (GList **queue);
struct wapdman_task *task_create (tasktype type, int opcode,
                                  int priority, void *invocation,
                                  void *value, void *userdata,
                                  timeout_func func);

#endif //TASK_H

/** @} */
