/**
 * @file inotifier.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */


#ifndef INOTIFIER_H
#define INOTIFIER_H

struct inotify_event;

typedef
void (* inotify_cb) (struct inotify_event *event, const char *dir, void *userdata);

int inot_init (void);
int inot_deinit (void);
int inotify_register (const char *const path, inotify_cb callback,
                      const char *const file, void *userdata);
int inotify_unregister (const char *const path, inotify_cb callback,
                        const char *const file);

#endif //INOTIFIER_H

/** @} */
