/**
 * @file wifi_rootdaemon_client.c
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#include <stdio.h>
#include <syslog.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <IClientSharedlib.h>
#include <wifi_rootdaemon_client.h>
#include <dirent.h>

using namespace std;

/* No such user or group, just temporary and to be changed 
 * as soon as possible */
static const char *WIFI_USERNAME = "aid_wifi_bl";
static const char *WIFI_GROUPNAME = "aid_wifi_bl";
static const char *CONNMAN_DIR_PATH = "/var/opt/bosch/dynamic/connman/";

static const char*
command_to_string (const int cmd)
{
    switch (cmd) {
    case IPT_COMMIT_RULE:
        return "IPT_COMMIT_RULE";
    case DEL_CONNMAN_CONTENT:
       return "DEL_CONNMAN_CONTENT";
    }
    return "UNKNOWN";
}

const char*
getClientName()
{
    return WIFI_CLIENT_NAME;
}

const char*
getClientGroupName()
{
    return WIFI_USERNAME;
}

const char*
getClientUserName ()
{
    return WIFI_GROUPNAME;
}

CmdData command(const int cmdNum, std::string args)
{
    CmdData result;
    (void) args;
    memset(&result , 0 , sizeof(CmdData));
    switch (cmdNum)
    {
    /* The case of IP_TABLE_COMMIT rule not handled currently because of sensitive changes.
      As the application WAPDMAN  currently runs with root privileges.
      And this part of code won't be executed in any case in the system. This will be handled later in upcoming releases */
    case IPT_COMMIT_RULE:
            {
                if(!args.empty())
                {
                    syslog (LOG_INFO, "%s:command(),dynamic arg[%s]", WIFI_CLIENT_NAME,args.c_str());
                    #define TEMP_ARR_LEN 200
                    char buff[TEMP_ARR_LEN];
                    memset(buff, 0, TEMP_ARR_LEN);
                    sprintf (buff,"%s %s", IPTABLES, args.c_str());
                    std::string rule = buff;

                    syslog (LOG_INFO, "%s:command(),executing[%s]", WIFI_CLIENT_NAME,
                            rule.c_str());
                    if(true/*0 == system(rule.c_str())*/)
                    {
                        syslog (LOG_INFO, "%s:command(),Successful operation [%s]", WIFI_CLIENT_NAME,
                                rule.c_str());
                        result.errorNo = ERR_NONE;
                    }
                    else
                    {
                        syslog (LOG_INFO, "%s:command(),unsuccessful operation [%s]", WIFI_CLIENT_NAME,
                                rule.c_str());
                        result.errorNo = ERR_CANNOT_EXEC_CMD;
                    }
                }
                else
                {
                    result.errorNo = ERR_INVALID_CMD_ARGS;
                }
            }
            break;
    case DEL_CONNMAN_CONTENT:
    {
        std::string dirPath=CONNMAN_DIR_PATH;
        std::string wifiDirectoryFilePath;
        struct dirent *directoryEntry=NULL;
        struct dirent *wifiDirectoryFiles=NULL;
        bool validation=true;
        DIR *directory = opendir(CONNMAN_DIR_PATH);
        if (directory)
        {
            while ((directoryEntry = readdir(directory)) != NULL)
            {
                std::string dirFileName=directoryEntry->d_name;
                if(dirFileName.find("wifi_") == 0)
                {
                    dirPath.append(directoryEntry->d_name);
                    dirPath.append("/");
                    wifiDirectoryFilePath=dirPath;
                    DIR * wifiDirectory= opendir(dirPath.c_str());
                    if (wifiDirectory)
                    {
                        while ((wifiDirectoryFiles= readdir(wifiDirectory)) != NULL)
                        {
                            wifiDirectoryFilePath.append(wifiDirectoryFiles->d_name);
                            if(0== remove(wifiDirectoryFilePath.c_str()))
                            {
                                syslog(LOG_INFO, "%s:command(),File in wifi directory deleted successfully", WIFI_CLIENT_NAME);
                            }
                            wifiDirectoryFilePath=dirPath;
                        }
                        closedir(wifiDirectory);
                    }
                    if(0==remove(dirPath.c_str()))
                    {
                        syslog(LOG_INFO, "%s:command(),Wifi Directory deleted successfully", WIFI_CLIENT_NAME);
                    }
                    else
                    {
                        validation=false;
                        syslog(LOG_INFO, "%s:command(),Unsuccessful operation",WIFI_CLIENT_NAME);
                        result.errorNo = ERR_CANNOT_EXEC_CMD;
                    }
                    dirPath=CONNMAN_DIR_PATH;
                }
            }
            if(validation==true)
            {
                syslog(LOG_INFO, "%s:command(),Successful operation",WIFI_CLIENT_NAME);
                result.errorNo = ERR_NONE;
            }
            closedir(directory);
        }
    }
    break;
    default:
        result.errorNo = ERR_UNKNOWN_CMD;
        return result;
    }

    return result;
}

CmdData
execRootCommand (const char * clientName,
                 const int cmdNum,
                 const char * args)
{
    syslog (LOG_INFO, "WIFI Calling performRootOp() of root daemon, clientname[%s], cmdnum[%s], args[%s]",clientName, command_to_string (cmdNum), args);
    return RootDaemonHelper::performRootOp (clientName, cmdNum, std::string(args));
}
