#include "iap_bt_plugin_common.h"
#include "iap1_bt_plugin.h"
#include <adit_typedef.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <poll.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <termios.h>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_IAP_PLUGIN_IAP1
#include "trcGenProj/Header/iap1_bt_plugin.c.trc.h"
#endif

S32 iap1_bt_device_fd = -1;
U8 iap1_bt_device_name[DEV_NAME_BUFFERSIZE + 1];

S32 iPodBTComInit (IPOD_DATACOM_FUNC_TABLE* data_com_function, U32 num_devices)
{
    ETG_TRACE_USR3(("iPodBTComInit::entered"));
    S32 rc = IPOD_DATACOM_SUCCESS;

    /* avoid lint warnings */
	num_devices = num_devices;

    if (data_com_function != NULL)
    {
        data_com_function->open = &iPodiAP1BTOpenPlugin;
        data_com_function->close = &iPodiAP1BTClosePlugin;
        data_com_function->abort = &iPodiAP1BTCloseMsgHandling;
        data_com_function->write = &iPodiAP1BTSendMessage;
        data_com_function->read = &iPodiAP1BTReceiveMessage;
        data_com_function->ioctl = &iPodiAP1BTDeviceIoCtl;
        data_com_function->property = &iPodiAP1BTGetProperty;
    }
    else
    {
        rc = IPOD_DATACOM_BAD_PARAMETER;
    }
    
    ETG_TRACE_USR3(("iPodBTComInit::leaving"));
    return rc;
}

S32 iPodBTComDeinit (IPOD_DATACOM_FUNC_TABLE* data_com_function)
{
    ETG_TRACE_USR3(("iPodBTComDeinit::entered"));
    S32 rc = IPOD_DATACOM_SUCCESS;

    if (data_com_function != NULL)
    {
        data_com_function->open = NULL;
        data_com_function->close = NULL;
        data_com_function->abort = NULL;
        data_com_function->write = NULL;
        data_com_function->read = NULL;
        data_com_function->ioctl = NULL;
        data_com_function->property = NULL;
    }

    ETG_TRACE_USR3(("iPodBTComDeinit::leaving"));
    return rc;
}

S32 iPodiAP1BTOpenPlugin (const U8* device_name, S32 flags, S32 mode)
{
    ETG_TRACE_USR3(("iPodiAP1BTOpenPlugin::entered"));
    S32 rc = IPOD_DATACOM_SUCCESS;

    /* avoid lint warnings */
    flags = flags;
    mode = mode;

    /* copy device_name */
    strncpy ((char *)iap1_bt_device_name, (char *)device_name, DEV_NAME_BUFFERSIZE);
    iap1_bt_device_name[DEV_NAME_BUFFERSIZE] = 0;
    
    rc = iAPBTOpenPlugin (device_name);
    if (rc >= 0)
    {
        iap1_bt_device_fd = rc;
    }

    ETG_TRACE_USR3(("iPodiAP1BTOpenPlugin::leaving"));
    return rc;
}

S32 iPodiAP1BTClosePlugin (S32 fd)
{
    ETG_TRACE_USR3(("iPodiAP1BTClosePlugin::entered"));
    S32 rc;

    if (fd == iap1_bt_device_fd)
    { 
        rc = iAPBTClosePlugin (iap1_bt_device_fd);

        // reset file descriptor
        iap1_bt_device_fd = -1;
    }
    else
    {
        rc = IPOD_DATACOM_BAD_PARAMETER;
    }

    ETG_TRACE_USR3(("iPodiAP1BTClosePlugin::leaving"));
    return rc;
}

S32 iPodiAP1BTCloseMsgHandling (S32 fd)
{
    ETG_TRACE_USR3(("iPodiAP1BTCloseMsgHandling::entered"));
    S32 rc = IPOD_DATACOM_ERROR;

    if (fd == iap1_bt_device_fd)
    {
        // a pending read/write request must be terminated here
        rc = IPOD_DATACOM_SUCCESS;
    }
    else
    {
        rc = IPOD_DATACOM_BAD_PARAMETER;
    }

    ETG_TRACE_USR3(("iPodiAP1BTCloseMsgHandling::leaving"));
    return rc;
}

S32 iPodiAP1BTGetProperty (S32 fd, IPOD_DATACOM_PROPERTY *property)
{
    ETG_TRACE_USR3(("iPodiAP1BTGetProperty::entered"));
    S32 rc = IPOD_DATACOM_SUCCESS;

    if ((fd == iap1_bt_device_fd) && (property != NULL))
    {
        property->maxSize = IPOD_DATACOM_PROPERTY_MAX_SIZE;
    }
    else
    {
        rc = IPOD_DATACOM_BAD_PARAMETER;
    }
    
    ETG_TRACE_USR3(("iPodiAP1BTGetProperty::leaving"));
    return rc;
}

S32 iPodiAP1BTDeviceIoCtl (S32 fd, S32 request, U8* argp)
{
    ETG_TRACE_USR3(("iPodiAP1BTDeviceIoCtl::entered"));
    S32 rc = IPOD_DATACOM_SUCCESS;

    /* avoid lint warnings */
    fd = fd;

    if (argp != NULL)
    {
        rc = iAPBTDeviceIoCtl(request, argp);
    }
    else
    {
        rc = IPOD_DATACOM_BAD_PARAMETER;
    }

    ETG_TRACE_USR3(("iPodiAP1BTDeviceIoCtl::leaving"));
    return rc;
}
S32 iPodiAP1BTSendMessage (S32 fd, U32 msgLenTotal, const U8 *iPod_msg, S32 flags)
{
    ETG_TRACE_USR3(("iPodiAP1BTSendMessage::entered"));
    S32 rc = IPOD_DATACOM_SUCCESS;

    /* avoid lint warnings */
    flags = flags;

    if ((fd == iap1_bt_device_fd) && (iPod_msg != NULL) && (msgLenTotal > 0))
    {
        rc = iAPBTSendMessage (iap1_bt_device_fd, msgLenTotal, iPod_msg);
    }
    else  /* wrong fd or buf == NULL or sendInfo == NULL */
    {
        rc = IPOD_DATACOM_BAD_PARAMETER;
    }
    ETG_TRACE_USR3(("iPodiAP1BTSendMessage::leaving"));
    return rc;
}

S32 iPodiAP1BTReceiveMessage (S32 fd, U32 buffer_size, U8 *msgBuffer, S32 flags)
{
    ETG_TRACE_USR3(("iPodiAP1BTReceiveMessage::entered"));
    S32 rc = IPOD_DATACOM_SUCCESS;
    S32 bytes_read = -1;
    S32 res;
    fd_set fdSet;

    /* avoid lint warnings */
    flags = flags;

    if((fd == iap1_bt_device_fd) && (msgBuffer != NULL))
    {
        FD_ZERO (&fdSet);
        FD_SET (iap1_bt_device_fd, &fdSet);
        res = select(iap1_bt_device_fd+1, &fdSet, NULL, NULL, NULL);

        /* error? */
        if (res == -1) // error in select
        { 
            ETG_TRACE_ERR(("iPodiAP1BTReceiveMessage::select-error on read request errno=%d", errno));
            rc = IPOD_DATACOM_ERROR;
        } 
        
        else if (res > 0)  // value read 
        { 
            /* read the value */
            bytes_read = iAPBTReceiveMessage(iap1_bt_device_fd, buffer_size, msgBuffer);
            
            if (bytes_read > 0)
            {
                ETG_TRACE_USR3(("iPodiAP1BTReceiveMessage::BytesRead=%d", bytes_read));
                rc = bytes_read;
            }
            else if (bytes_read == 0) 
            {
                ETG_TRACE_USR3(("iPodiAP1BTReceiveMessage::EOF received"));
                rc = IPOD_DATACOM_ERROR;
            }
            else
            {
                ETG_TRACE_USR3(("iPodiAP1BTReceiveMessage::Read error"));
                rc = IPOD_DATACOM_ERROR;
            }
        }
    }
    else
    {
        rc = IPOD_DATACOM_BAD_PARAMETER;
    }

    ETG_TRACE_USR3(("iPodiAP1BTReceiveMessage::leaving"));
    return rc;
}



