/*
 * FC_Bluetooth_rootdaemon_client.cpp
 *
 *  This file implements IClientSharedlib.h (the client side of the root daemon)
 *  it should be compiled as shared library and copied to the sharedlibs loading area to be loadable from the root daemon server side
 *
 *  Created on: Nov 3, 2014
 *      Author: Mohamed Mostafa
 */

#include <IClientSharedlib.h>
#include <FC_Bluetooth_rootdaemon_client.h>
#include <stdlib.h> //system()
#include <syslog.h>
#include <stdio.h> //fopen
#include <sys/stat.h> //stat()
#include <stdarg.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

inline bool isValidMACAddress(const std::string &args)
{
   //Valid:    32:25:F2:1A:24:64, 32:05:F2:1A:24:64
   //Invalid:  32:2:F2:1A:24:64,  32:05:G0:1A:24:64
   if(args.empty() || (args.length() != 17))
   {
      return false;
   }

   for(int i=0;i<17;i++)
   {
      if(0 == ((i+1)%3))
      {
         if(args[i] != ':')
         {
            return false;
         }
      }
      else
      {
         if(!isxdigit(args[i]))
         {
            return false;
         }
      }
   }

   return true;
}

#ifdef __cplusplus
extern "C"
{
#endif

const char * getClientName()
{
   return "FC_Bluetooth";//TODO put it in header file
}

const char * getClientGroupName()
{
   return (char *)"aid_btsettings";
}

const char * getClientUserName()
{
   return (char *)"aid_btsettings";
}

int32_t execCommandSimple(const char *Cmd, ...)
{
   char *const env[]={ strdup("HOME=/"), strdup("PATH=/bin:/usr/bin:/sbin:/usr/sbin:/opt/bosch/base/bin"), NULL };
   va_list     arglst;
   char        **args = NULL;
   int         argnum = 0;
   char        *next_arg = NULL;
   pid_t       pid = -1;
   int         ret = 0, status = 0;

   va_start(arglst, Cmd);

   args = (char **)malloc(sizeof(char *));

   if(NULL != args)
   {
      args[0] = strdup(Cmd);
   }

   for(next_arg = va_arg(arglst, char *); next_arg; next_arg=va_arg(arglst, char *))
   {
      args = (char **)realloc(args, sizeof(char *)*(++argnum+2));

      if(NULL != args)
      {
         args[argnum] = strdup(next_arg);
      }
   }

   args[argnum+1] = NULL;

   va_end(arglst);

   pid = fork();

   if(pid == -1)
   {
      for(int i = 0; env[i]; ++i)
         free(env[i]);

      for(int i = 0; args[i]; ++i) {
         free(args[i]);
         args[i] = 0;
      }

      free(args);
      return 32001;
   }
   else if(pid)
   {
      while((ret=waitpid(pid, &status, 0)) == -1)
      {
         if(errno != EINTR)
            break;
      }

      for(int i = 0; env[i]; ++i)
         free(env[i]);

      for(int i = 0; args[i]; ++i) {
         free(args[i]);
         args[i] = 0;
      }

      free(args);
      args = 0;

      return WEXITSTATUS(status);
   }
   else
   {
      if(execvpe(args[0], args, env) == -1)
      {
         _Exit(127);
      }
   }

   for (int i = 0; env[i]; ++i)
      free(env[i]);
   for (int i = 0; args[i]; ++i) {
      free(args[i]);
      args[i] = 0;
   }

   free(args);
   args = 0;

   return 32002;
}

CmdData command(const int cmdNum, std::string args)
{
   CmdData result;

   size_t found = args.find(' ');
   if (found == string::npos)
   {
      switch(cmdNum)
      {
         case GET_SIGNAL_NOISE:
         case GET_LINK_QUALITY:
         {
            if(isValidMACAddress(args))
            {
               const char * res_file_name    = "/tmp/test.txt";
               const char * res_file_name_bk = "/tmp/test.txt.bak";
               int tmp1 = 0;
               int tmp2 = 0;
               FILE * res_fp = NULL;

               syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:command(): %s %s", args.c_str(), res_file_name);

               int fd; /*file descriptor to the file we will redirect ls's output*/

               if((fd = open( "/tmp/test.txt", O_RDWR | O_CREAT, S_IRWXU )) != -1) /*open the file */
               {
                  if(dup2(fd,1) != -1) /*copy the file descriptor fd into standard output*/
                  {
                     if(close(fd) == 0) /* close the file descriptor as we don't need it more  */
                     {
                        int32_t ret = execCommandSimple("/opt/bosch/connectivity/bt_module/bt_tool_helper.sh", (GET_SIGNAL_NOISE == cmdNum) ? "80211SignalNoise" : "lq", args.c_str(), NULL);
                        if(0 == ret)
                        {
                           syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:command(),Successful operation ");
                           res_fp = fopen(res_file_name,"r");
                           if(res_fp != NULL)
                           {
                              if(!feof(res_fp))
                              {
                                 result.errorNo = ERR_CANNOT_PARSE_RESULT_FILE;

                                 if(GET_SIGNAL_NOISE == cmdNum)
                                 {
                                    if(2 == fscanf(res_fp,"%d %d",(int*)&tmp1, (int*)&tmp2)) //tmp1 is signal, tmp2 is noise
                                    {
                                       memcpy(result.message, &tmp1, sizeof(tmp1));
                                       memcpy(result.message+sizeof(tmp1), &tmp2, sizeof(tmp2));
                                       result.errorNo = ERR_NONE;
                                    }
                                 }
                                 else if(GET_LINK_QUALITY == cmdNum)
                                 {
                                    if(1 == fscanf(res_fp,"%d",(int*)&tmp1)) //tmp1 is link quality
                                    {
                                       memcpy(result.message, &tmp1, sizeof(tmp1));
                                       result.errorNo = ERR_NONE;
                                    }
                                 }
                                 else
                                    result.errorNo = ERR_UNKNOWN_CMD;
                              }
                              else
                              {
                                 result.errorNo = ERR_CANNOT_PARSE_RESULT_FILE;
                              }

                              fclose(res_fp);

                              if(0 != rename(res_file_name, res_file_name_bk))
                              {
                                 syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:File name could not be renamed");
                              }
                              else
                              {
                                 syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:File Renamed successfully");
                              }

                           }
                           else
                           {
                              result.errorNo = ERR_CANNOT_OPEN_RESULT_FILE;
                           } // file could not be opened
                        }
                        else
                        {
                           result.errorNo = ERR_CANNOT_EXEC_CMD;
                           syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:Could not execute ExecCommand");
                        } //execCommandSimple unsuccessfull
                     }
                     else
                     {
                        result.errorNo = ERR_CANNOT_EXEC_CMD;
                        syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:File could not be closed");
                     }//close  the file descripter
                  }
                  else
                  {
                     if(close(fd) != 0)
                     {
                        result.errorNo = ERR_CANNOT_EXEC_CMD;
                        syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: Failed to close the file");
                     }
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:Dup2 command failed to execute");
                  }//execute dup2 command

               } //open tmp/text.txt
               else
               {
                  result.errorNo = ERR_CANNOT_EXEC_CMD;
                  syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:File not created");
               }
            }
            else
            {
               result.errorNo = ERR_INVALID_CMD_ARGS;
            } //valid mac address
         }
         break;
         case SET_WIFI_TX_PWR:
         {
            if(!args.empty())
            {
               syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:command(),executing");

               int32_t ret = execCommandSimple("/opt/bosch/connectivity/wifi/ugkz7_wifi_pwr_att_diag.sh", args.c_str());
               syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:command(),executing[%d]", ret);

               if(0 == ret)
               {
                  syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:command(),Successful operation");
                  result.errorNo = ERR_NONE;
               }
               else
               {
                  syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:command(),unsuccessful operation");
                  result.errorNo = ERR_CANNOT_EXEC_CMD;
               }
            }
            else
            {
               result.errorNo = ERR_INVALID_CMD_ARGS;
            }
         }
         break;
         case BT_STATE_OFF:
         {
            if(!args.empty())
            {
               int fd; /* file descriptor to the file */
               const char *file_name = "/var/opt/bosch/dynamic/connectivity/bt_state_off";

               if("create" == args)
               {
                  if((fd = open( file_name, O_RDWR | O_CREAT, S_IRWXU )) != -1) /* open the file */
                  {
                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:File created successfully");
                     result.errorNo = ERR_NONE;

                     if(close(fd) != 0) /* close the file descriptor as we don't need it more  */
                     {
                        result.errorNo = ERR_CANNOT_EXEC_CMD;
                        syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:File could not be closed");
                     }//close  the file descripter
                  } //open tmp/text.txt
                  else
                  {
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:File not created");
                  }
               }
               else if("delete" == args)
               {
                  if(0 != remove(file_name))
                  {
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:File name could not be removed");
                  }
                  else
                  {
                     result.errorNo = ERR_NONE;
                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:File removed successfully");
                  }
               }
            }
            else
            {
               result.errorNo = ERR_INVALID_CMD_ARGS;
            }
         }
         break;
         case EVOLUTION_STACK:
         {
            if(!args.empty())
            {
               if("start" == args)
               {
                  // Bug 1043111 : [inf4cv] Bluetooth cannot be activated with Random Source selection
                  // Scenario: BT is OFF and Perform SW flashing via USB
                  // After SW flashing, all the files inside the folder(/var/opt/bosch/dynamic/connectivity/bt_module) will be
                  // deleted and evo.cfg(contains Chip ID - 11(UGKZ7 module by default)) will be copied in that folder during
                  // system startup and also Evolution stack will not run due to bt_state_off file. Because of that chip ID(UGXZE - 9)
                  // will be not changed for INF4CV. Hence after deleting the bt_state_off file(while switching ON the BT),
                  // btmodule-config service should be restarted.

                  int32_t ret = execCommandSimple("systemctl", "restart", "btmodule-config", NULL);

                  syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: systemctl command(btmodule-config) executing[%d]", ret);

                  if(0 == ret)
                  {
                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: btmodule-config service is started");

                     ret = execCommandSimple("systemctl", "restart", "rbcm-bluetooth", NULL);

                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: systemctl command(genivi) executing[%d]", ret);

                     if(0 == ret)
                     {
                        syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: evo_genivi and evo_hli_socket processes are started");
                        result.errorNo = ERR_NONE;
                     }
                     else
                     {
                        syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: evo_genivi and evo_hli_socket processes are not started");
                        result.errorNo = ERR_CANNOT_EXEC_CMD;
                     }
                  }
                  else
                  {
                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: btmodule-config service is not started");
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
               }
               else if("stop" == args)
               {
                  int32_t ret = execCommandSimple("systemctl", "stop", "rbcm-bluetooth", NULL);

                  syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: systemctl command(genivi) executing[%d]", ret);

                  if(0 == ret)
                  {
                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: evo_genivi process stopped");
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: evo_genivi process is not stopped");
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }

                  if(ERR_NONE == result.errorNo)
                  {
                     ret = execCommandSimple("systemctl", "stop", "rbcm-bluetooth-socket", NULL);
                     syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client: systemctl command(socket) executing[%d]", ret);

                     if(0 == ret)
                     {
                        syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:evo_hli_socket process is stopped");
                        result.errorNo = ERR_NONE;
                     }
                     else
                     {
                        syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:evo_hli_socket process is not stopped");
                        result.errorNo = ERR_CANNOT_EXEC_CMD;
                     }
                  }
               }
            }
            else
            {
               result.errorNo = ERR_INVALID_CMD_ARGS;
            }
         }
         break;
         default:
            result.errorNo = ERR_UNKNOWN_CMD;
      }
   }
   else
   {
      result.errorNo = ERR_INVALID_CMD_ARGS;
      syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:Space between arguments");
   }

   syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:command() [errorNo:%d]", result.errorNo);
   return result;
}

#ifdef __cplusplus
}
#endif

CmdData execRootCommand(const char * clientName, const int cmdNum, const char * args)
{
   uid_t euid = geteuid();

   if(0 == euid)
   {
      //User is root: execute root operation directly
      syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:execRootCommand() calling command(), clientname[%s],cmdnum[%d], args[%s]",clientName, cmdNum, args);
      return command(cmdNum, std::string(args));
   }
   else
   {
      //use root daemon to perform root operation
      syslog(LOG_INFO, "FC_Bluetooth_rootdaemon_client:execRootCommand() calling calling performRootOp(), clientname[%s],cmdnum[%d], args[%s]",clientName, cmdNum, args);
      return RootDaemonHelper::performRootOp(clientName, cmdNum, std::string(args));

   }

}


