/*******************************************************************************
*
* FILE:          .h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:

* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_PHONEBOOK_VCARD_PROPERTY_
#define _FC_PHONEBOOK_VCARD_PROPERTY_

#include "FC_PhoneBook_VCard_Document.h"


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class FC_PhoneBook_VCard_Property
{
public:
  enum Type
  {
    Plain,
    Compound,
    List,
    Binary,
    Document
  };

  FC_PhoneBook_VCard_Property();
  FC_PhoneBook_VCard_Property(const FC_PhoneBook_VCard_Property& other);
  ~FC_PhoneBook_VCard_Property();

  FC_PhoneBook_VCard_Property& operator=(const FC_PhoneBook_VCard_Property& other);
  bool operator==(const FC_PhoneBook_VCard_Property& other) const;
  bool operator!=(const FC_PhoneBook_VCard_Property& other) const;

  void setGroups(const QStringList& groups);
  QStringList groups() const;

  void setName(const QString& name);
  QString name() const;

  void insertParameter(const QString& name, const QString& value);
  void removeParameter(const QString& name, const QString& value);
  void removeParameters(const QString& name);

  void setParameters(const QMultiHash<QString,QString>& parameters);
  QMultiHash<QString,QString> parameters() const;

  void setValue(const QVariant& value);
  QVariant variantValue() const;

  template <typename T> T value() const
  {
    return variantValue().value<T>();
  }

  QString value() const;

  void setType(Type type);
  Type getType() const;

  bool isEmpty() const;
  void clear();

private:
  QStringList m_Groups;
  QString m_Name;
  QMultiHash<QString,QString> m_Parameters;
  QVariant m_Value;
  FC_PhoneBook_VCard_Property::Type m_Type;
};

uint qHash(const FC_PhoneBook_VCard_Property& key);

#endif // _FC_PHONEBOOK_VCARD_PROPERTY_
