/*******************************************************************************
*
* FILE:          .h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:

* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef FC_PHONEBOOK_VCARD_LINEREADER_H
#define FC_PHONEBOOK_VCARD_LINEREADER_H

#include <QtCore/QtCore>

#include "FC_PhoneBook_VCard_ByteArray.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class FC_PhoneBook_VCard_LineReader
{
public:
  FC_PhoneBook_VCard_LineReader(QIODevice* device, QTextCodec* codec, int chunkSize = 1000);
  void appendLine(const QByteArray& line);
  int bytesProcessed();
  bool atEnd();
  QTextCodec* codec();
  FC_PhoneBook_VCard_ByteArray readLine();

private:
  void readOneLine(FC_PhoneBook_VCard_ByteArray* cursor);
  bool tryReadLine(FC_PhoneBook_VCard_ByteArray* cursor, bool blAtEnd);

  QIODevice* const m_Device;
  QTextCodec* const m_Codec;
  int m_ChunkSize;
  QList<QByteArrayMatcher> m_CrlfList;
  QStack<QByteArray> m_AppendedLines;
  FC_PhoneBook_VCard_ByteArray m_Buffer;
  int m_BytesProcessed;
  int m_SearchFrom;

  const QByteArray m_Colon;
  const QByteArray m_Equals;
  const QByteArray m_Space;
  const QByteArray m_Tab;
  const QByteArray m_LineFeed;
};



#endif // FC_PHONEBOOK_VCARD_LINEREADER_H
