/*******************************************************************************
*
* FILE:          .h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:

* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_PHONEBOOK_VCARD_DOCUMENT_
#define _FC_PHONEBOOK_VCARD_DOCUMENT_

#include <QtCore/QtCore>

class FC_PhoneBook_VCard_Document_Private;
class FC_PhoneBook_VCard_Property;

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class FC_PhoneBook_VCard_Document
{
public:
  enum CardType
  {
    Invalid,
    VCard21,
    VCard30
  };

  FC_PhoneBook_VCard_Document();
  FC_PhoneBook_VCard_Document(const FC_PhoneBook_VCard_Document& other);
  FC_PhoneBook_VCard_Document(CardType oCardtype);
  ~FC_PhoneBook_VCard_Document();

  FC_PhoneBook_VCard_Document& operator=(const FC_PhoneBook_VCard_Document& other);
  bool operator==(const FC_PhoneBook_VCard_Document& other) const;
  bool operator!=(const FC_PhoneBook_VCard_Document& other) const;

  void setType(CardType oCardtype);
  CardType type() const;

  // The componentType is the value of the BEGIN property
  void setComponentType(QString str_componentType);
  QString componentType() const;

  // The content
  void addProperty(const FC_PhoneBook_VCard_Property& property);
  void removeProperty(const FC_PhoneBook_VCard_Property& property);
  void removeProperties(const QString& name);
  QList<FC_PhoneBook_VCard_Property> properties() const;

  void addSubDocument(const FC_PhoneBook_VCard_Document& subdocument);
  void setSubDocuments(const QList<FC_PhoneBook_VCard_Document>& documents);
  QList<FC_PhoneBook_VCard_Document> subDocuments() const;

  bool isEmpty() const;
  void clear();

private:

  FC_PhoneBook_VCard_Document::CardType m_CardType;
  QString m_ComponentType;
  QList<FC_PhoneBook_VCard_Property> m_Properties;
  QList<FC_PhoneBook_VCard_Document> m_SubDocuments;
};

uint qHash(const FC_PhoneBook_VCard_Document& key);

Q_DECLARE_METATYPE(FC_PhoneBook_VCard_Document)

#endif // _FC_PHONEBOOK_VCARD_DOCUMENT_
