/*******************************************************************************
*
* FILE:          .h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:

* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef FC_PHONEBOOK_VCARD_BYTEARRAY_H
#define FC_PHONEBOOK_VCARD_BYTEARRAY_H

#include <QByteArray>

static const int FC_PB_MAX_OLD_BYTES_TO_KEEP = 8192;


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
/*!
 * An FC_PhoneBook_VCard_ByteArray has a subset of QByteArray's interface, plus an efficient chopLeft function
 *
 * It stores a QByteArray internally, plus a marker of where it starts and where it ends.
 */
class FC_PhoneBook_VCard_ByteArray
{
public:
  FC_PhoneBook_VCard_ByteArray();
  explicit FC_PhoneBook_VCard_ByteArray(const QByteArray& data);
  FC_PhoneBook_VCard_ByteArray(const QByteArray& data, int start, int end);

  bool isEmpty() const;
  char at(int i) const;
  QByteArray toByteArray() const;
  void chopLeft(int n);
  QByteArray left(int n);
  int indexOf(const QByteArray& needle);
  int size() const;
  const char* constData() const;
  bool contains(const QByteArray& ba) const;
  bool endsWith(const QByteArray& ba) const;
  FC_PhoneBook_VCard_ByteArray& operator=(const QByteArray& ba);
  bool operator==(const QByteArray& ba);
  bool operator!=(const QByteArray& ba);

private:
  void dropOldData();
  void setBounds(int start, int end);

  QByteArray mData;
  int mStart;
  int mEnd;
  friend class FC_PhoneBook_VCard_LineReader;
};

#endif // FC_PHONEBOOK_VCARD_BYTEARRAY_H
