#ifndef _QT_EXCEPTION_H_
#define _QT_EXCEPTION_H_

/*
* Include this file as last include in XXX_main.cpp of every process who is dealing with Qt.
* Add the following line in "extern "C" OSAL_DECL tS32 vStartApp(tS32 cPar, tString aPar[])" 
* "qInstallMsgHandler(emOutput);"     // for Qt Version <  5.0
* "qInstallMessageHandler(emOutput);" // for Qt Version >= 5.0
* right at start. That's all!
*/

#if QT_VERSION >= 0x050000
static void emOutput(QtMsgType type, const QMessageLogContext &context, const QString &qtmsg)
#else
static void emOutput(QtMsgType type, const char *msg)
#endif
{

#if QT_VERSION >= 0x050000
   // CMG3G-8447. Clearing the LINT warning
   fprintf(stdout, "Context: Category: %s\n", context.category);
   fprintf(stdout, "Context: File: %s\n", context.file);
   fprintf(stdout, "Context: Function: %s\n", context.function);
   fprintf(stdout, "Context: Line: %d\n", context.line);
   fprintf(stdout, "Context: Version: %d\n", context.version);

  QByteArray localMsg = qtmsg.toLocal8Bit();
  const char *msg = localMsg.constData();
#endif

	switch (type)  
	{
		case QtDebugMsg:
			fprintf(stderr, "Debug: %s\n", msg);
			break;
		case QtWarningMsg:
			fprintf(stderr, "Warning: %s\n", msg);
			break;
		case QtCriticalMsg:
			{
				FILE *fd_emtrace = fopen("/dev/errmem", "wa");
				fprintf(fd_emtrace ? fd_emtrace : stderr, "Qt-Critical: %s\n", msg);
				if (fd_emtrace)
				   fclose(fd_emtrace);
			}
			break;
		case QtFatalMsg:
			{
				FILE *fd_emtrace = fopen("/dev/errmem", "wa");
				fprintf(fd_emtrace ? fd_emtrace : stderr, "Qt-Fatal: %s\n", msg);
				if (fd_emtrace)
				   fclose(fd_emtrace);
			}
			abort();
			break;
		default:
		{
		   fprintf(stderr, "Info: %s\n", msg);
		}
	}
}

#endif // _QT_EXCEPTION_H_
