/*******************************************************************************
*                                                                               
* FILE:          FC_PhoneBook_DBusInterface.h
*                                                                               
* SW-COMPONENT:  FC_PhoneBook application
*                                                                               
* PROJECT:                                                                      
*                                                                               
* DESCRIPTION:   Interface definition for DBusClient_CallBack.
*                                                                               
* AUTHOR:
*                                                                               
* COPYRIGHT:
*                                                                               
*******************************************************************************/
#ifndef _FC_PHONEBOOK_DBUSINTERFACE_H_
#define _FC_PHONEBOOK_DBUSINTERFACE_H_
#include "../FC_PhoneBook_main.h"
#include "../FC_PhoneBook_Device_Details.h"
#include "../Common/FC_PhoneBook_Global.h" //c++11 compatibility

#define HWADRESS_LENGTH       25
#define MAX_DEVICE_CONNECTION_SUPPORTED 2

#define FC_PB_LB_FID_BASE                   0x01
#define FC_PB_LB_FID_CONNECT                ( FC_PB_LB_FID_BASE + 1)
#define FC_PB_LB_FID_DISCONNECT             ( FC_PB_LB_FID_BASE + 2)
#define FC_PB_LB_FID_GET_CAPABILITIES_CB    ( FC_PB_LB_FID_BASE + 3)
#define FC_PB_LB_FID_DNL_PREPARE_CB         ( FC_PB_LB_FID_BASE + 4)
#define FC_PB_LB_FID_DNL_START_CB           ( FC_PB_LB_FID_BASE + 5)
#define FC_PB_LB_FID_DNL_COMPLETE_CB        ( FC_PB_LB_FID_BASE + 6)
#define FC_PB_LB_FID_CONNECTION_LOST_SIG    ( FC_PB_LB_FID_BASE + 7)
#define FC_PB_LB_FID_DNL_STOP_CB            ( FC_PB_LB_FID_BASE + 8)
#define FC_PB_LB_FID_INCOMING_CALL_SIG      ( FC_PB_LB_FID_BASE + 9)
#define FC_PB_LB_FID_CALL_STATUS_SIG        ( FC_PB_LB_FID_BASE + 10)
#define FC_PB_LB_FID_DATA_COMPLETE_SIG      ( FC_PB_LB_FID_BASE + 11)
#define FC_PB_LB_FID_DEVICE_DELETED         ( FC_PB_LB_FID_BASE + 12)
#define FC_PB_LB_FID_EVO_CONNECT            ( FC_PB_LB_FID_BASE + 13)
#define FC_PB_LB_FID_EVO_DISCONNECT         ( FC_PB_LB_FID_BASE + 14)
#define FC_PB_LB_FID_RESUME_SUSPENDED_DWNLD ( FC_PB_LB_FID_BASE + 15)


class FC_Device_Details;

enum FC_PhoneBookDwldCallType
{
   DownLoadPBSim = 0,
   DownLoadPBLocal,
   DownloadOutGoingCallHistorySimLocal,
   DownloadMissedCallHistorySimLocal,
   DownloadIncomingCallHistorySimLocal,
   DownloadCombinedCallHistorySimLocal,
   DownloadPBSpeedDial,
   DownloadPBFavorites
};
enum FC_PhoneBookSupportedCallType
{
   PBAPNotSupported = 0x00,
   PBInSIM = 0x01,
   PBInLocal = 0x02,
   OutgoingCallHistory = 0x04,
   MissedCallHistory = 0x08,
   IncomingCallHistory = 0x10,
   CombinedCallHistory = 0x20,
   DownloadAll = 0x3F
};


typedef struct
{
   bool blFailed;
   bool blRingtone;
   guchar ucErrorCode;
   guchar ucCallState;
   guchar ucCallTotal;
   guchar ucStatus;
   guchar ucDnlType;
   tU8 ucMissedCalls;
   guchar ucConnectionID;
   guchar ucDeviceHandle;
   guint32 u16FunctionID;
   guchar ucCallHandle;
   gchar ucDevAddr[HWADRESS_LENGTH];
   guchar ucCallDirection;
   gchar aucPhoneNumber[25];
   guint32 u32PhoneNumberCount;
} PhBk_Loopback_Data;

typedef struct _PhBK_CCA_Dbus_If
{
   tVoid (*vPhoneBook_DownloadInitiated)(FC_Device_Details*);
   tVoid (*vPhoneBook_PostLoopback)(guint32);
   tVoid (*vPhoneBook_PushLoopbackData)(PhBk_Loopback_Data*);
} PhBK_CCA_Dbus_If;


#define CALLSTATUS_IDLE 		0
#define CALLSTATUS_ACTIVE		1
#define CALLSTATUS_HELD			2
#define CALLSTATUS_DIALING		3
#define CALLSTATUS_ALERTING	4
#define CALLSTATUS_INCOMING	5
#define CALLSTATUS_WAITING		6
#define CALLSTATUS_RESPONSE_HOLD	7
#define CALLSTATUS_UNKNOWN		8

#define CALLDIRECTION_UNKNOWN   0
#define CALLDIRECTION_OUTGOING	1
#define CALLDIRECTION_INCOMING 	2

typedef struct
{
   tU8 u8CallStatus;
   tU8 u8CallDirection;
} RecentCallInfo;

class RecentCallStatus
{
public:
   static QMap<QString, RecentCallInfo> map;
   static QMap<QString, RecentCallInfo>::Iterator it;

public:
   static bool bDownloadMissedCall;
   static bool bDownloadIncomingCall;
   static bool bDownloadOutgoingCall;

   static void setCurrentState(PhBk_Loopback_Data* poRecentCallData);
   // -bn: Removed the implementation here and moved to
   //      FC_PhoneBook_DBusIfCallbacks.cpp so that we can use ETG traces.

};

PhBK_CCA_Dbus_If *pGetCCAPhoneBookDBusIf(tVoid);
// Declare all the functions interface here
tVoid FcPhoneBookDbusCallback_DownloadInitiated( FC_Device_Details* DeviceDetails );
tVoid FcPhoneBookDbusCallback_PostLoopback( guint32 u32FuncID);
tVoid FcPhoneBookDbusCallback_PushLoopbackData(PhBk_Loopback_Data* LB_Data);

#endif
