/*******************************************************************************
*                                                                               
* FILE:          FC_PhoneBook_DBusIfCallBacks.cpp
*                                                                               
* SW-COMPONENT:  FC_PhoneBook application
*                                                                               
* PROJECT:                                                                      
*                                                                               
* DESCRIPTION:   CCA service PhoneBook.
*                                                                               
* AUTHOR:
*                                                                               
* COPYRIGHT:
*                                                                               
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../FC_PhoneBook_Debug.h"
#include "../FC_PhoneBook_main.h"
#include "../FC_PhoneBook_service_PhoneBook.h"
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONEBOOK_DBUS
#include "trcGenProj/Header/FC_PhoneBook_DBusIfCallbacks.cpp.trc.h"
#endif

#include "FC_PhoneBook_DBusInterface.h"

static PhBK_CCA_Dbus_If rPhBkCCA_DBusIf =
{
   FcPhoneBookDbusCallback_DownloadInitiated,
   FcPhoneBookDbusCallback_PostLoopback,
   FcPhoneBookDbusCallback_PushLoopbackData
};

/*******************************************************************************
 * FUNCTION: pGetCCAPhoneDBusIf
 *
 * DESCRIPTION: Suplies CCA_DBusInterface
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
PhBK_CCA_Dbus_If *pGetCCAPhoneBookDBusIf(tVoid)
{
    return(&rPhBkCCA_DBusIf);
}


/*******************************************************************************
* FUNCTION: FcPhoneBookDbusCallback_DownloadInitiated
*
* DESCRIPTION: 
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid FcPhoneBookDbusCallback_DownloadInitiated( FC_Device_Details* DeviceDetails )
{
   fc_phonebook_tclService_PhoneBook *poPhoneBookService = NULLPTR;
   poPhoneBookService = fc_phonebook_tclService_PhoneBook::pGetInstance();
   if(poPhoneBookService)
   {
      poPhoneBookService->vPhoneBook_DownloadInitiated(DeviceDetails);
   }
}
/*******************************************************************************
* FUNCTION: FcPhoneBookDbusCallback_PostLoopback
*
* DESCRIPTION: Posts a loop back message for the given function ID
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid FcPhoneBookDbusCallback_PostLoopback(guint32 u32FuncID)
{
   fc_phonebook_tclService_PhoneBook *poPhoneBookService = NULLPTR;
   poPhoneBookService = fc_phonebook_tclService_PhoneBook::pGetInstance();
   if(poPhoneBookService)
   {
      poPhoneBookService->vPrepareandsendLoopBackMsg(u32FuncID);
   }
}

/*******************************************************************************
* FUNCTION: FcPhoneBookDbusCallback_PushLoopbackData
*
* DESCRIPTION: Pushes loopback data into the queue
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid FcPhoneBookDbusCallback_PushLoopbackData(PhBk_Loopback_Data* LB_Data)
{
   fc_phonebook_tclService_PhoneBook *poPhoneBookService = NULLPTR;
   poPhoneBookService = fc_phonebook_tclService_PhoneBook::pGetInstance();
   if(poPhoneBookService)
   {
      poPhoneBookService->vPush_Back_LB_Data(*LB_Data);
   }
}

/*******************************************************************************
 * FUNCTION: setCurrentState
 *
 * DESCRIPTION: Sets latest recent call info and finds lists to be downloaded.
 *
 * PARAMETER:
 *    [IN]: poRecentCallData:- Latest recent call info.
 *    [OUT]: None.
 * RETURNVALUE: None.
 *
 ********************************************************************************/
void RecentCallStatus::setCurrentState( PhBk_Loopback_Data* poRecentCallData )
{
   // -bn: Implementation moved from FC_Phonebook_DBusInterface.h
   //      to here, so that we can activate ETG traces.

   ETG_TRACE_USR1(("Phone number ::%s",poRecentCallData->aucPhoneNumber));

   if ((poRecentCallData->ucCallHandle != 0)
            && (poRecentCallData->ucCallState != CALLSTATUS_IDLE))
   {
      RecentCallInfo oRecentCallInfo;

      oRecentCallInfo.u8CallStatus = poRecentCallData->ucCallState;
      oRecentCallInfo.u8CallDirection = poRecentCallData->ucCallDirection;

      it = map.find(poRecentCallData->aucPhoneNumber);
      if (it == map.end())
      {
         // Insert it first time
         ETG_TRACE_USR4(("  Insert it first time, CallStatus= %d, CallDirection= %d, PhoneNumber = '%s' ",
               oRecentCallInfo.u8CallStatus, oRecentCallInfo.u8CallDirection,
               poRecentCallData->aucPhoneNumber ));

         map.insert(poRecentCallData->aucPhoneNumber, oRecentCallInfo);
      }
      else
      {
         ETG_TRACE_USR4(("  Modifying the status, OLD: CallStatus= %d, CallDirection= %d, PhoneNumber = '%s' ",
               it->u8CallStatus, it->u8CallDirection, poRecentCallData->aucPhoneNumber ));

         if ((it->u8CallStatus == CALLSTATUS_WAITING)
                  && (oRecentCallInfo.u8CallStatus == CALLSTATUS_WAITING))
         {
            bDownloadMissedCall = true;
         }

         it->u8CallDirection = oRecentCallInfo.u8CallDirection;
         it->u8CallStatus = oRecentCallInfo.u8CallStatus;

         ETG_TRACE_USR4(("  Modifying the status, NEW: CallStatus= %d, CallDirection= %d, PhoneNumber = '%s' ",
               it->u8CallStatus, it->u8CallDirection, poRecentCallData->aucPhoneNumber ));
      }
   }
   else if ((poRecentCallData->ucCallHandle == 0)
            && (poRecentCallData->ucCallState == CALLSTATUS_IDLE))
   {
      ETG_TRACE_USR2(( "  The RecentCallStatus::map has currently %d entries.  ", map.count() ));
      //Fix for GMMY15-5877 Clone ticket: Exception in "phonebook.out"
      // -bn: Rework of GMNGA-55966, more details see below.
      //for (it = map.begin(); it != map.end(); /*it++*/)  // for loop with 'it++' removed and replaced by while loop
      it = map.begin();
      while( it != map.end() )
      {
         ETG_TRACE_USR4(("  in loop,  CallDirection= %d, it->u8CallStatus= %d  ", it->u8CallDirection, it->u8CallStatus ));
         if (it->u8CallDirection == CALLDIRECTION_OUTGOING)  // In this line we crashed in callstack of GMNGA-55966), more details see below.
         {
            bDownloadOutgoingCall = true;
         }
         else if (it->u8CallDirection == CALLDIRECTION_INCOMING)
         {
            switch (it->u8CallStatus)
            {
               case CALLSTATUS_ACTIVE:
               case CALLSTATUS_HELD:
               case CALLSTATUS_RESPONSE_HOLD:
                  bDownloadIncomingCall = true;
                  break;

               case CALLSTATUS_INCOMING:
               case CALLSTATUS_WAITING:
                  bDownloadMissedCall = true;
                  bDownloadIncomingCall = true;
                  break;

               default:
                  break;
            }
         }

         //Fix for GMMY15-5877 Clone ticket: Exception in "phonebook.out"
         // Erase the entry from map

         // -bn: Rework of MV's original fix for GMNGA-55966 - Nullpointerexception in "phonebook.out"
         //      Note: - MV's original fix adds several checks 'if(LBData == NULL) {  return  }' in file
         //              'FC_PhoneBook_Dnl_Manager.cpp'.
         //            - These pseudo fixes by MV ignore the relevant details of the given callstack of issue GMNGA-55966
         //              as the callstack show that we crash in statement 'it->u8CallDirection == CALLDIRECTION_OUTGOING',
         //              due to the fact that the iterator 'it' is not valid.
         //              Consequence: The mentioned pseudo fixes by MV of type 'if(LBData == NULL) {  return  }'
         //              in file 'FC_PhoneBook_Dnl_Manager.cpp' are useless regarding the ticket.
         //            - In addition these "early returns" would skip relevant processing steps (which could affect
         //              needed "state changes" etc.) without printing out a FATAL trace or doing an EmTrace entry.
         //            - Note: I have now added related fatal traces and EmTrace entries in case of 'LBData == NULL'.
         //              This allows to track if there is any situation where we really come suffer from 'LBData == NULL'.
         //
         //      Clarification: The real issue (based on the given callstack of GMNGA-55966 is that a map entry is
         //                     erased and a iterator becomes invald with an erase() operation. This dangling iterator is
         //                     continued to be to used in the for loop and causes the reset (if someone else gets assigned
         //                     this memory).
         //      Fix: Replaced 'map.erase(it);' by 'it = map.erase(it);' and do not increase 'it++' in the loop

         //map.erase(it);
         it = map.erase(it);
         // --:
      }  // end of: while( it != map.end() )
   }
}
