/*******************************************************************************
*                                                                               
* FILE:          FC_PhoneBook_main.h                                     
*                                                                               
* SW-COMPONENT:  FC_PhoneBook application                                  
*                                                                               
* PROJECT:                                                                      
*                                                                               
* DESCRIPTION:   CCA Application.                                               
*                                                                               
* AUTHOR:        Arun Choudhary                                                               
*                                                                               
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim                          
*                                                                               
*******************************************************************************/

#ifndef _FC_PHONEBOOK_MAIN_H_
#define _FC_PHONEBOOK_MAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define FC_PHONEBOOK_S_IMPORT_INTERFACE_MSG
#include "FC_PhoneBook_if.h"
#include "Common/FC_PhoneBook_Global.h" //c++11 compatibility
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

enum tenTrcTraceClassFC_PhoneBook {
  TR_CLASS_FC_PHONEBOOK_APPLICATION = TR_COMP_CONNECTIVITY + 48,        // traceclass: 0x3b30
  TR_CLASS_FC_PHONEBOOK_SERVICE     = TR_COMP_CONNECTIVITY + 48 + 1,    // traceclass: 0x3b31
  TR_CLASS_FC_PHONEBOOK_SQLITE      = TR_COMP_CONNECTIVITY + 48 + 2,    // traceclass: 0x3b32
  TR_CLASS_FC_PHONEBOOK_DBUS        = TR_COMP_CONNECTIVITY + 48 + 3     // traceclass: 0x3b33  LINT Fix -Info 726: Extraneous comma
};

#include "../Configuration/PhoneBook/Pbk_FeatureConfig.h"

#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"

#define PHONEBOOK_TIMER_ID_1 0x00
#define PHONEBOOK_TIMER_ID_2 0x01

#ifdef CONNECTIVITY_PROCESS_STARTUP_GEN3
#define FC_PHBK_THREAD_ID                 "PHNBOOK"
#define FC_PHBK_DEFAULT_PRIORITY           105
#define FC_PHBK_DEFAULT_STACK_SIZE         16384
#endif  //CONNECTIVITY_PROCESS_STARTUP_GEN3

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;

class fc_phonebook_tclClientHandler_StreamRouter;

class fc_phonebook_tclClientHandler_BluetoothSetings;

class fc_phonebook_tclService_PhoneBook;

class fc_phonebook_tclClientHandler_Phone;

class FC_PhoneBook_Database;

class Phonebook_DefSetHandler;

class fc_phonebook_tclApp FINAL : public ahl_tclBaseOneThreadApp
{


  public:
	static fc_phonebook_tclApp* m_poMainAppInstance;
    fc_phonebook_tclApp(tVoid);
    virtual ~fc_phonebook_tclApp(tVoid);

    //This is new function defined to enable/disable service of Phonebook 
    static tVoid fc_phonebook_set_service(tBool on);
    
    // Assingment Operater, will not be implemented.
    // Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
    // 'fc_phonebook_tclApp' which has no assignment operator.
    // NOTE: This is a technique to disable the assignment operator for this
    // class. So if an attempt for the assignment is made compiler complains.
    
    fc_phonebook_tclApp& operator= (const fc_phonebook_tclApp &oFC_PhoneBook);

    // Copy Constructor, will not be implemented.
    // Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
    // 'fc_phonebook_tclApp' which has no copy constructor.
    // NOTE: This is a technique to disable the copy constructor for this
    // class. So if an attempt for the assignment is made compiler complains.
    
    fc_phonebook_tclApp(const fc_phonebook_tclApp &oFC_PhoneBook); 
   
    // Overriding ahl_tclBaseOneThreadApp methods.
    /**
     * TODO: vOnNewAppState: temporary workaround for NCG3D-67384
     */
    tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState) OVERRIDE;
    
    tBool bOnInit() OVERRIDE;
    tVoid vOnApplicationClose() OVERRIDE;
    tVoid vOnTimer(tU16 nTimerId) OVERRIDE;
    tVoid vOnLoadSettings() OVERRIDE;
    tVoid vOnSaveSettings() OVERRIDE;
    using ahl_tclBaseOneThreadApp::vOnLoopback;
    tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage) OVERRIDE;
    void vProceedWithFavoritesProviderRegister();

#ifdef CONNECTIVITY_PROCESS_STARTUP_GEN3
   static fc_phonebook_tclApp* theServer();
   tVoid vInitializeThread();
   static tVoid vStartMainLoop();
#endif //CONNECTIVITY_PROCESS_STARTUP_GEN3
    diaglib::tclServiceDiaglib*            m_poDiaglibService;

    fc_phonebook_tclClientHandler_BluetoothSetings* m_poClientHandlerBluetoothSetings;
  private:

    fc_phonebook_tclClientHandler_StreamRouter* m_poClientHandlerStreamRouter;


    fc_phonebook_tclClientHandler_Phone* m_poClientHandlerPhone;

    fc_phonebook_tclService_PhoneBook* m_poPhoneBook;

    Phonebook_DefSetHandler *m_poDefSet;

#ifdef CONNECTIVITY_PROCESS_STARTUP_GEN3
	OSAL_tThreadID							m_hRxThreadId;
#endif //CONNECTIVITY_PROCESS_STARTUP_GEN3

}; 

#endif //_FC_PHONEBOOK_MAIN_H_
