/*******************************************************************************
*
* FILE:          FC_PhoneBook_clienthandler_Phone.h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:   CCA client-handler for the service Telephone
*
* AUTHOR:        Balasubramani
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_PHONEBOOK_CLIENTHANDLER_PHONE_H_
#define _FC_PHONEBOOK_CLIENTHANDLER_PHONE_H_

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

//Include FI interface of used service
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_SERVICEINFO

#include "conn_most_fi_if.h"
#include "Common/FC_PhoneBook_Global.h" //c++11 compatibility

/*******************************************************************************
*                                   PROTOTYPES
******************************************************************************/

class FC_Phonebook_tclFavorite_Provider;

/*******************************************************************************
*                                  START OF CODE
******************************************************************************/
class fc_phonebook_tclClientHandler_Phone
   : public ahl_tclBaseOneThreadClientHandler
{

   // Message map definition macro
   DECLARE_MSG_MAP(fc_phonebook_tclClientHandler_Phone)

public:
   tU16 m_CurrentCallInstance;
   tU8 m_u8ActivecallCount;

   //For EVO stack, store the call status received and the call direction.
   most_telfi_tclMsgCallStatusNoticeExtendedStatus m_oCallStatusNoticeExtendedStatus;
   tU8 m_au8CallDirection[4];

   fc_phonebook_tclClientHandler_Phone(tVoid);
   fc_phonebook_tclClientHandler_Phone(fc_phonebook_tclApp* poMainAppl);
   virtual ~fc_phonebook_tclClientHandler_Phone();

   // Assingment Operater, will not be implemented.
   fc_phonebook_tclClientHandler_Phone& operator=
      (const fc_phonebook_tclClientHandler_Phone &oClientHandler);

   // Application specific methods.
   // tVoid vProcessTimer(tU16 u16TimerId);

   // Overriding ahl_tclBaseOneThreadClientHandler methods.
   tVoid vOnServiceAvailable() OVERRIDE;
   tVoid vOnServiceUnavailable() OVERRIDE;

   tVoid vRegisterFavoritesProviderInstance(
      FC_Phonebook_tclFavorite_Provider* pFavoritesProvider);
   tVoid vTrigger_Dial_MethodStart(const char* PhoneNumber);
   tVoid vTrigger_SendDTMFMethodStart(tU16 u16CallInstance, const char* sDTMFChar);

   //FIX GMNGA-56482 Favorite not highlighted when Call active
   tVoid vTrigger_QueryTelephoneNumber_MethodStart(tU16 u16CallInstance);
   tVoid vHandle_ActivePhoneDevice_Status(amt_tclServiceData* poMessage);

   //FIX GMMY16-9895 Pressing the favorite button that was used to place an outgoing call does not end the call
   tVoid vTrigger_Hangup_MethodStart(tU16 u16CallInstance);
   tVoid vTrigger_CancelOutgoingCall_MethodStart(tU16 u16CallInstance);
   tVoid vTrigger_IgnoreCall_MethodStart(tU16 u16CallInstance);
   //End of FIX GMMY16-9895

private:
   FC_Phonebook_tclFavorite_Provider* m_poFavoritesProvider;

   // Handler function declarations used by message map.
   // Add your CCA message handler function prototypes here.
   tVoid vHandle_CallStatusNoticeExtended_Status(amt_tclServiceData* poMessage);
   tVoid vHandle_Dial_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_Dial_Error(amt_tclServiceData* poMessage);
   tVoid vHandle_SendDTMF_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_SendDTMF_Error(amt_tclServiceData* poMessage);

   //FIX GMMY15-56482 Favorite not highlighted when Call active
   tVoid	vHandle_QueryTelephoneNumber_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_QueryTelephoneNumber_Error(amt_tclServiceData* poMessage);

   // FIX GMMY16-9895 Pressing the favorite button that was used to place an outgoing call does not end the call
   tVoid vHandle_HangUpCall_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_HangUpCall_Error(amt_tclServiceData* poMessage);
   tVoid vHandle_CancelOutgoingCall_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_CancelOutgoingCall_Error(amt_tclServiceData* poMessage);
   tVoid vHandle_IgnoreCall_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_IgnoreCall_Error(amt_tclServiceData* poMessage);
   //End of FIX GMMY16-9895
};

#endif // _FC_PHONEBOOK_CLIENTHANDLER_PHONE_H_
