/************************************************************************
* FILE:         Phonebook_DefSetHandler.h
* PROJECT:      
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: Example implementation of a system set listener.
* This handler sets the demodata value used for IncreaseDecrease demo
* back to default on a DefSet request.
* Take this class as a template for your own listener classes and
* adjust the parts marked with
* // +++ comment +++
*
* - ccademo_diaghandler.x              => // +++ Comment +++
* - ccademo_IncreaseDecreaseHandler.x  => // +++ Comment +++
* - Phonebook_DefSetHandler.x            => // +++ Comment +++
* - ccademo_main.x                     => // +++diaglib+++ comment
* - ccademo_msgtypes.h                 => // +++diaglib+++ comment
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author                 | Modification
* 02.10.08  | CM-AI/PJ-FO45 Evers    | Inital version
*
*************************************************************************/
// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
#ifndef PHONEBOOK_DEFSET_HANDLER_H
#define PHONEBOOK_DEFSET_HANDLER_H

#include "Common/FC_PhoneBook_Global.h" //c++11 compatibility
/**
 * Message are received by implementing ListenerInterfaces and registering 
 * them with diagnosis library. This demo shows two ways to achieve this.
 * SystemSets are handled in this class. For RoutineControl we create an
 * extra classe that handles requests for two different routines.
 */
// +++ Adjust class prefix +++
class Phonebook_DefSetHandler: public diaglib::tclSystemSetListenerIF
{
public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   Phonebook_DefSetHandler(diaglib::tclServiceDiaglib* pDiaglibService);
   virtual ~Phonebook_DefSetHandler() FINAL;

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++
   /***************************************************************************
    * SystemSetListener methods
    ***************************************************************************/
   virtual tU32 vOnSystemSet ( 
                               tU32 u32SystemSetID, 
                               diaglib::tenSystemSetType u32SystemSetType,
                               diaglib::tContext MsgContext
                             ) OVERRIDE;

	virtual tU32 vOnSystemSetFinished ( 
                                       tU32 u32SystemSetID, 
                                       diaglib::tenSystemSetType u32SystemSetType,
                                       diaglib::tContext MsgContext
                                     ) OVERRIDE;

	virtual tU32 vOnSystemSetPrepare ( 
                                       tU32 u32SystemSetID, 
                                       diaglib::tenSystemSetType u32SystemSetType,
                                       diaglib::tContext MsgContext
                                    ) OVERRIDE;

	virtual tU32 vOnSystemSetCheck ( 
                                    tU32 u32SystemSetID, 
                                    diaglib::tenSystemSetType u32SystemSetType,
                                    diaglib::tContext MsgContext
                                   ) OVERRIDE;
private:
   diaglib::tclServiceDiaglib* mpDiaglibService;

   Phonebook_DefSetHandler();//lint !e1704 Info 1704 , eliminating lint warnings 

};
#endif // CCADEMO_DEFSET_HANDLER_H
