/*******************************************************************************
*
 * FILE:          FC_PhoneBook_Dnl_Manager.h
 *
 * SW-COMPONENT:  FC_PhoneBook application
 *
 * PROJECT:
 *
 * DESCRIPTION:
 *
 * AUTHOR:        Balasubramani.V
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#include "../Interface/FC_PhoneBook_DBusInterface.h"//CMG3G-14314
#include "DbusClient/FC_PhoneBook_EvoDbusClient.h"//CMG3G-14314
#include "Common/FC_PhoneBook_Global.h" //c++11 compatibility

#ifndef _FC_PHONEBOOK_DNL_MANAGER_H_
#define _FC_PHONEBOOK_DNL_MANAGER_H_

class fc_phonebook_tclService_PhoneBook;

#define RETRY_TIMER_INITIAL  5000 //in msec
#define RETRY_TIMER_INC_STEP 1000 //in msec
#define RETRY_MAX_RETRY_TIME 20 //in sec
#define NO_OF_RETRIES 3
#define NO_OF_CH_RETRIES 1

class FC_PhoneBook_RetryDetails
{
private:
public:
   enum enRetry_Messages
   {
      RETRY_GET_CAPABILITIES = 0,
      RETRY_PREPARE,
      RETRY_START_PBDL,
      RETRY_DNL_COMPLETE,
      RETRY_ANY_MESSAGE,
      RETRY_STOP_PBDL,
      RETRY_EVO_DEVICECONNECT,
      RETRY_EVO_DEVICEDISCONNECT,
      RETRY_DOWNLOAD_SEQUENCE,
      RETRY_PBAP_CONNECT_VIA_BM_APPL,
      RETRY_CH_DOWNLOAD
   };

   enum enRetry_Type
   {
      RETRY_TYPE_INCREMENTAL = 0,
      RETRY_TYPE_CONSTANT
   };

   bool blRetryActive;
   bool blCHRetryActive;
   bool blIncrementalRetry;
   enRetry_Messages enMsgRetried;
   quint32 u32CurrentRetryDur;

   FC_PhoneBook_RetryDetails() :
      blRetryActive(0), blCHRetryActive(0), blIncrementalRetry(0), enMsgRetried(RETRY_GET_CAPABILITIES), u32CurrentRetryDur(0)
   {
   }
   ~FC_PhoneBook_RetryDetails()
   {
   }
};

class FC_PhoneBook_Dnl_Manager
{
public:
   FC_PhoneBook_Dnl_Manager();
   ~FC_PhoneBook_Dnl_Manager();
   void vSetPhonebookServiceInstance(fc_phonebook_tclService_PhoneBook*);

   void vGetCapabilitiesCallback(PhBk_Loopback_Data* LBData);
   void vPrepareCallback(PhBk_Loopback_Data* LBData);
   void vDnlStartCallback(PhBk_Loopback_Data* LBData);
   void vConnectionLost(PhBk_Loopback_Data* LBData);
   void vDataCompleteCallback(PhBk_Loopback_Data* LBData);
   void vDnlCompleteCallback(PhBk_Loopback_Data* LBData);
   void vNewDeviceConnected(quint8 u8DeviceHandle);
   void vDeviceDisconnected(quint8 u8ConnectionID);
   void vDnlConnectionLostSignal(PhBk_Loopback_Data* LBData);
   void vIncomingCall(PhBk_Loopback_Data* LB_Data);
   void vCallStatus(PhBk_Loopback_Data* LB_Data);
   void ConstructDownloadArrayForSeparateCallList(FC_Device_Details *deviceObject, guchar pbDownlaodType);

   static quint8 getCurDownloadTypeForConnectionID(quint8 u8ConnectionID);
   void vDownloadCallHistory(FC_Device_Details *deviceObject, tU8 u8CallDirection, tBool bDownloadMCH);
   void PhoneBook_vTimerExpired(quint16 u16TimerID);
   void PhoneBook_vStartRetry(FC_PhoneBook_RetryDetails::enRetry_Messages RetryMsg, quint8 u8ConnectionID, FC_PhoneBook_RetryDetails::enRetry_Type RetryType);
   void CallHistory_vStartRetry(FC_PhoneBook_RetryDetails::enRetry_Messages RetryMsg, quint8 l_u8ConnectionID, FC_PhoneBook_RetryDetails::enRetry_Type RetryType); // NCG3D-103980
   void PhoneBook_vStopRetry(FC_PhoneBook_RetryDetails::enRetry_Messages RetryMsg, quint8 u8ConnectionID);
   void CallHistory_vStopRetry(FC_PhoneBook_RetryDetails::enRetry_Messages RetryMsg, quint8 l_u8ConnectionID); // NCG3D-103980
   bool PhoneBook_blIsRetryActive(quint8 u8ConnectionID, FC_PhoneBook_RetryDetails::enRetry_Messages RetryMsg);
   void vListDownloadComplete(FC_Device_Details *l_poFC_Device_Details);

   bool bIs_PBSim_inDownloadArray(FC_Device_Details *deviceObject); // -bn-PBDL.S: added
   //FIX CMG3G-3262 Download State property implementation
   bool bIsCHDownloadComplete(FC_Device_Details *deviceObject);
   //End of fix

   void vFillPendingManualPBCommandList(FC_Device_Details *deviceObject, tU8 u8DownloadType);
   bool m_bContactDlNeeded;
   void vStartDnlTime();
   void PhoneBook_PrintAllDownloadTypes(FC_Device_Details *deviceObject);

   tU8 u8GetRetryCount();
   tU8 u8GetCHRetryCount();// NCG3D-103980
   
   //Fix : CMG3G-12880
   tVoid vCheckWhetherProbablyLockedDevice(quint8 u8DeviceHandle);
   tU8 bCheckIfAnyDownloadIsInProgress();
   //End fix : CMG3G-12800
private:
   fc_phonebook_tclService_PhoneBook* m_poPhonebookService;
   _CCA_dbus_interfaces_pb * m_pDbus_Cca_ApiList;
   quint8 m_NoOfActiveCalls; //Fix for GMMY16-6072
   QTime dnlTime;
   tU8 m_u8Retry_Count;
   tU8 m_u8GetCHRetryCount;// NCG3D-103980

   FC_PhoneBook_RetryDetails m_oRetryDetails[FC_PB_TOTAL_NUMBER_OF_CH];

   void vStartDnlForTheGivenType(FC_Device_Details* DevDetails, quint8 pbDownlaodType);
   void PhoneBook_findDownloadType(FC_Device_Details *deviceObject, guchar pbDownlaodType);
   void PhoneBook_DlStart_Failed(FC_Device_Details* DevDetails, PhBk_Loopback_Data* LBData);
   void PhoneBook_FetchingCapabilitiesFailed(FC_Device_Details* DevDetails);
   void PhoneBook_FetchingCapabilitiesSucess(FC_Device_Details* DevDetails);
   void PhoneBook_FillCallHistoryDnlTypes(FC_Device_Details* DevDetails, quint8 pbDownlaodType, quint8& u8ArrIndex);
   void PhoneBook_vRetryMsg(quint8 u8ConnectionID, FC_PhoneBook_RetryDetails::enRetry_Messages RetryMsg);

   void SendDummyListChange(tU8 u8DeviceHandle, int DownloadType);

};

#endif //_FC_PHONEBOOK_DNL_MANAGER_H_


