/*******************************************************************************
*
* FILE:          FC_PhoneBook_Usage.cpp
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
*
* AUTHOR:		 Balasubramani.V
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "FC_PhoneBook_Usage.h"
#include "FC_PhoneBook_SQLite.h"
#include "../FC_PhoneBook_main.h"
#include "../FC_PhoneBook_clienthandler_BluetoothSetings.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONEBOOK_APPLICATION
#include "trcGenProj/Header/FC_PhoneBook_Usage.cpp.trc.h"
#endif

/*******************************************************************************
*
* FUNCTION: FC_PhoneBook_MemoryUsage::FC_PhoneBook_MemoryUsage()
*
* DESCRIPTION: Constructor
*
*
* PARAMETER: None.
*
* RETURNVALUE: None
*
*******************************************************************************/
FC_PhoneBook_MemoryUsage::FC_PhoneBook_MemoryUsage()
{
   ETG_TRACE_USR4(("FC_PhoneBook_MemoryUsage Constructor entered."));

   m_u32TotallyUsedContactMemory = 0;
   m_u32TotallyUsedPhotoMemory   = 0;
}


/*******************************************************************************
*
* FUNCTION: FC_PhoneBook_MemoryUsage::~FC_PhoneBook_MemoryUsage()
*
* DESCRIPTION: Destructor
*
*
* PARAMETER: None.
*
* RETURNVALUE: None
*
*******************************************************************************/
FC_PhoneBook_MemoryUsage::~FC_PhoneBook_MemoryUsage()
{
   ETG_TRACE_USR4(( "FC_PhoneBook_MemoryUsage Destructor entered." ));
}


bool FC_PhoneBook_MemoryUsage::bCheckMemoryPoolForContacts(quint32 u32ContactMemoryToBeAdded)
{
   ETG_TRACE_USR2(( " bCheckMemoryPoolForContacts entered, u32ContactMemoryToBeAdded= %d", u32ContactMemoryToBeAdded ));

   if(PHONEBOOK_CONTACT_MEMORY_LIMIT >= (m_u32TotallyUsedContactMemory + u32ContactMemoryToBeAdded))
   {
      return true;   // Contact memory available
   }
   else
   {
      return false;  // Contact memory NOT available
   }
}


void FC_PhoneBook_MemoryUsage::vUpdateMemoryPoolForContacts(quint32 u32ContactMemoryToBeAdded)
{
   ETG_TRACE_USR2(( " bUpdateMemoryPoolForContacts,  : u32ContactMemoryToBeAdded= %d", u32ContactMemoryToBeAdded ));

   if(PHONEBOOK_CONTACT_MEMORY_LIMIT >= (m_u32TotallyUsedContactMemory + u32ContactMemoryToBeAdded))
   {
      m_u32TotallyUsedContactMemory += u32ContactMemoryToBeAdded;
   }
   else
   {
      // Contact memory is over LIMIT. Never expected to come here.
      ETG_TRACE_FATAL((  " PHBK_NEVER_EXPECTED:  m_u32TotallyUsedContactMemory= %u, u32ContactMemoryToBeAdded= %u ",
                         m_u32TotallyUsedContactMemory, u32ContactMemoryToBeAdded ));
      ETG_TRACE_ERRMEM(( " PHBK_NEVER_EXPECTED:  m_u32TotallyUsedContactMemory= %u, u32ContactMemoryToBeAdded= %u ",
                         m_u32TotallyUsedContactMemory, u32ContactMemoryToBeAdded ));
   }
}


bool FC_PhoneBook_MemoryUsage::bCheckMemoryPoolForPhoto(quint32 u32photoSizeNew, quint32 u32photoSizeOld)
{
   bool bRet = false;

   if ((m_u32TotallyUsedPhotoMemory + u32photoSizeNew) >= u32photoSizeOld)
   {
      if( (m_u32TotallyUsedPhotoMemory + u32photoSizeNew - u32photoSizeOld) <= APL2_PHOTO_MEMORY_LIMIT )
      {
         bRet = true;
      }
   }
   else
   {
      ETG_TRACE_FATAL((  " PHBK_NEVER_EXPECTED:  m_u32UsedPhotoMemory= %u, u32photoSizeNew= %u, u32photoSizeOld= %u ",
                         m_u32TotallyUsedPhotoMemory, u32photoSizeNew, u32photoSizeOld ));
      ETG_TRACE_ERRMEM(( " PHBK_NEVER_EXPECTED:  m_u32UsedPhotoMemory= %u, u32photoSizeNew= %u, u32photoSizeOld= %u ",
                         m_u32TotallyUsedPhotoMemory, u32photoSizeNew, u32photoSizeOld ));
   }

   return bRet;
}


void FC_PhoneBook_MemoryUsage::vUpdateMemoryPoolForPhoto(quint32 u32photoSizeNew, quint32 u32photoSizeOld)
{
   if ((m_u32TotallyUsedPhotoMemory + u32photoSizeNew) >= u32photoSizeOld)
   {
      m_u32TotallyUsedPhotoMemory += (u32photoSizeNew - u32photoSizeOld);
   }
   else
   {
      m_u32TotallyUsedPhotoMemory = 0;
      ETG_TRACE_FATAL((  " PHBK_NEVER_EXPECTED:  m_u32UsedPhotoMemory= %u, u32photoSizeNew= %u, u32photoSizeOld= %u ",
                         m_u32TotallyUsedPhotoMemory, u32photoSizeNew, u32photoSizeOld ));
      ETG_TRACE_ERRMEM(( " PHBK_NEVER_EXPECTED:  m_u32UsedPhotoMemory= %u, u32photoSizeNew= %u, u32photoSizeOld= %u ",
                         m_u32TotallyUsedPhotoMemory, u32photoSizeNew, u32photoSizeOld ));
   }
}


bool FC_PhoneBook_MemoryUsage::bRemoveLeastRecentlyUsedPhonebook()
{ 
   ETG_TRACE_USR2(( " bRemoveLeastRecentlyUsedPhonebook entered " ));

   bool bSuccess = false;

   FC_PhoneBook_SQLite *poSqlite = FC_PhoneBook_SQLite::GetSQLiteInstance();
   if(poSqlite)
   {
      quint8 u8LRUDeviceHandle = poSqlite->u8GetLRUDeviceHandle();
      ETG_TRACE_USR2(( " GetLeastRecentlyUsedDevice returns u8DeviceHandle= %d ", u8LRUDeviceHandle ));

      // Don't delete currently active/connected device. 
      if( false == fc_phonebook_tclClientHandler_BluetoothSetings::vIsDeviceConnected(u8LRUDeviceHandle) )
      {
         quint32 u32LRUDeviceContactMemory = 0;
         quint32 u32LRUDevicePhotoMemory   = 0;
         if( true == poSqlite->bCalculateUsedMemoryFromOnePhoneBookTable(u8LRUDeviceHandle, u32LRUDeviceContactMemory, 
                                                                         u32LRUDevicePhotoMemory) )
         {
            ETG_TRACE_USR2(( " u32LRUDeviceContactMemory= %u", u32LRUDeviceContactMemory ));

            // Remove all contacts of the LRU device from the database
            if( true == poSqlite->DeletePhoneBookContacts(u8LRUDeviceHandle) )
            {
               // Update the current total contact memory usage after deleting the LRU Device.
               if(u32LRUDeviceContactMemory <= m_u32TotallyUsedContactMemory)
               {
                  m_u32TotallyUsedContactMemory -= u32LRUDeviceContactMemory;
               }
               else
               {
                  ETG_TRACE_FATAL((  " PHBK_NEVER_EXPECTED:  m_u32TotallyUsedContactMemory= %u, u32LRUDeviceContactMemory= %u ",
                                     m_u32TotallyUsedPhotoMemory, u32LRUDeviceContactMemory ));
                  ETG_TRACE_ERRMEM(( " PHBK_NEVER_EXPECTED:  m_u32TotallyUsedContactMemory= %u, u32LRUDeviceContactMemory= %u ",
                                     m_u32TotallyUsedPhotoMemory, u32LRUDeviceContactMemory ));
                  m_u32TotallyUsedContactMemory = 0;
               }
               bSuccess = true;
            }
            else
            {
               bSuccess = false;
            }
         }
      }
      else
      {
         // Not really expected to come here, as this means that 1 connected phone exceeds the Contact memory limit...
         ETG_TRACE_FATAL(( " WARNING: Found LRUD device is the currently conntected device. " ));
         bSuccess = false;
      }
   }
   else
   {
      ETG_TRACE_FATAL(( " poSqlite is NULL " ));
   }

   return bSuccess;
}


void FC_PhoneBook_MemoryUsage::CalculateMemoryUsageFromDB()
{
   ETG_TRACE_USR2(( " CalculateMemoryUsageFromDB entered. " ));

   QTime MemTime;
   MemTime.start();

   m_u32TotallyUsedContactMemory = 0;
   m_u32TotallyUsedPhotoMemory   = 0;

   FC_PhoneBook_SQLite *poSqlite = FC_PhoneBook_SQLite::GetSQLiteInstance();
   if(poSqlite)
   {
      // Calculate the sum of the used Contact and Photo memory from all relevant PhoneBook_DHx tables in the database
      poSqlite->CalculateUsedMemoryFromPhoneBookTables(m_u32TotallyUsedContactMemory, m_u32TotallyUsedPhotoMemory);

      ETG_TRACE_USR2((" Fetched Total Memory usage [bytes]: Contact= %u, Photo= %u ", m_u32TotallyUsedContactMemory, m_u32TotallyUsedPhotoMemory ));
   }

   ETG_TRACE_USR2(( " -PBDL.Perf- 'CalculateMemoryUsageFromDB' exited after %d ms ", MemTime.elapsed() ));
}
