/*******************************************************************************
*
* FILE:          FC_PhoneBook_ListChange_Handler.h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:   File contains list change handling related functionality
*
* AUTHOR:		 Balasubramani.V
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_PHONEBOOK_LISTCHANGE_HANDLER_H_
#define _FC_PHONEBOOK_LISTCHANGE_HANDLER_H_

#include "../Common/FC_PhoneBook_Global.h" //c++11 compatibility
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

struct FC_PhoneBook_List_Data
{
   QList<FC_PhoneBook_Contact_Detail_Short> contactList;

   quint8 u8DeviceHandle;
   quint8 sortType;
   quint8 listType;
};

struct FC_CallHistory_List_Data
{
   QList<FC_PhoneBook_Callhistory_Detail> callhistoryList;

   quint8 sortType;
   quint8 callHistoryTpye;
   quint8 ConnectionID;
};

enum Action_Done
{
   enAction_Contact_Added=0,
   enAction_Contact_Edited,
   enAction_Contact_Deleted,
   enAction_Content_Refreshed,
   enAction_Content_Cleared,
   enAction_Dummy
};

enum List_Change_Type
{
   enContent_Changed=0,
   enItems_Added,
   enItems_removed,
   enItems_changed,
   enInvalid_List_Change_Type
};

enum List_Type
{
   enPhoneBook_list=0,
   enCallHistory_list,
   enInvalid_List_Type
};

class fc_phonebook_tclService_PhoneBook;

class ListChange_Handler
{

public:
   ListChange_Handler();
   ~ListChange_Handler();
   //Coverity Fix-CMG3G-14313
   void MapPhonBkListType(most_fi_tcl_e8_PhonBkListType &enListType);
   void MapPhonBkListChangeType(most_fi_tcl_e8_PhonBkListChangeType &enListChangeType);
   //end of fix
   // Return type of QHash made const to avoid LINT Warning 1536 (CMG3G-4848)
   void UpdateList(const QHash<quint16, FC_PhoneBook_List_Data*>* phashPbList, quint8 u8ActionDone, quint8 u8DeviceHandle, quint32 ContactHandle, FC_PhoneBook_SQLite::enListType u8PBListType = FC_PhoneBook_SQLite::ListType_ALL);
   void UpdateList(const QHash<quint16, FC_CallHistory_List_Data*>* phashChList, quint8 u8ActionDone, quint8 u8ConnectionID, quint32 u32NewContactHandle, quint32 u32OldContactHandle, quint8 callHistoryTpye = 0);

   // Speech Support
   // Return type of QHash made const to avoid LINT Warning 1536 (CMG3G-4848)
   void TriggerDummyListChange(const QHash<quint16, FC_PhoneBook_List_Data*>* phashPbList, quint16 u16ListHandle);
   void DummyListChange(const QHash<quint16, FC_PhoneBook_List_Data*>* phashPbList, quint8 u8DeviceHandle);

   bool FindIndexOfContactHandle(QList<FC_PhoneBook_Contact_Detail_Short>& PBookList, quint32 u32ContactHandle, quint32& u32Index);

private:

   List_Change_Type enList_Change_Type;
   List_Type enList_Type;
   FC_PhoneBook_SQLite *m_poSqlite;
   fc_phonebook_tclService_PhoneBook *m_poservice_phonebook;

   // Return type of QHash made const in several of the following methods to avoid LINT Warning 1536 (CMG3G-4848)
   void GetListofMatchingListHandles(const QHash<quint16, FC_PhoneBook_List_Data*>* pPbHash, quint8 u8DeviceHandle, quint8 u8ListType, QList<quint16>& FilteredListHandles);
   void GetListofMatchingListHandles(const QHash<quint16, FC_CallHistory_List_Data*>* pChHash, quint8 u8ConnectionID, QList<quint16>& FilteredListHandles);
   void NewContactAdded(const QHash<quint16, FC_PhoneBook_List_Data*>* phashPbList, quint8 u8DeviceHandle, quint32 u32ContactHandle, quint8 u8ListType);
   void SingleContactEdited(const QHash<quint16, FC_PhoneBook_List_Data*>* phashPbList, quint8 u8DeviceHandle, quint32 u32ContactHandle, quint8 u8ListType);
   void SingleContactEdited(const QHash<quint16, FC_CallHistory_List_Data*>* phashChList, quint8 u8ConnectionID, quint32 u32NewContactHandle, quint32 u32OldContactHandle);
   void SingleContactDeleted(const QHash<quint16, FC_PhoneBook_List_Data*>* phashPbList, quint8 u8DeviceHandle, quint32 u32ContactHandle, quint8 u8ListType);
   void ContentRefreshed(const QHash<quint16, FC_CallHistory_List_Data*>* phashChList, quint8 u8ConnectionID, quint8 callHistoryTpye);
   bool CreateNewList(tU8 u8ListType ,quint8 u8DeviceHandle, quint8 u8SortType, QList<FC_PhoneBook_Contact_Detail_Short>& PBook_List);

   void UpdateNewContactList(FC_PhoneBook_List_Data* pPBookListData, QList<FC_PhoneBook_Contact_Detail_Short>& PBookList);
   void SendListChangeToClients(quint16 u16ListHandle, quint16 u16ListLength, quint32 u32ChangedItem = 0);
   void ContentCleared(const QHash<quint16, FC_PhoneBook_List_Data*>* pPbHash, quint8 u8DeviceHandle, quint8 u8PBListType);
   void ContentRefreshed(const QHash<quint16, FC_PhoneBook_List_Data*>* pPbHash, quint8 u8DeviceHandle, quint8 u8PBListType);
   void ContentCleared(const QHash<quint16, FC_CallHistory_List_Data*>* pChHash, quint8 u8ConnectionID);

};

#endif /* _FC_PHONEBOOK_LISTCHANGE_HANDLER_H_ */
