/*******************************************************************************
*
* FILE:          FC_PhoneBook_List.h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_PHONEBOOK_LIST_
#define _FC_PHONEBOOK_LIST_

//we need this define to avoid conflit between the overloaded
//new and delete operators when using Qt.
//Ref:- developer's handbook v0.17
#ifndef __PLACEMENT_NEW_INLINE
#define __PLACEMENT_NEW_INLINE 1
#endif

#include <QtCore/QtCore>
#include <glib.h>
#include "FC_PhoneBook_SQLite.h"
#include "FC_PhoneBook_ListChange_Handler.h"
#include "../FC_PhoneBook_Device_Details.h"
#include "../Common/FC_PhoneBook_Global.h" //c++11 compatibility

#define FC_PHONEBOOK_PROP_N_LASTNAME_INDEX  0
#define FC_PHONEBOOK_PROP_N_FIRSTNAME_INDEX 1
#define FC_PHONEBOOK_PHOTO_SIZE_TRANSCODING_LIMIT_BYTES 20000  // -FastPhotoHandling-

class most_phonbkfi_tclMsgBaseMessage;
class most_phonbkfi_tclMsgCreatePhoneBookListMethodStart;
class most_phonbkfi_tclMsgCreatePhoneBookListMethodResult;
class most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart;
class most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult;

class most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart;
class most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult;

class most_phonbkfi_tclMsgReleasePhoneBookListMethodStart;
class most_phonbkfi_tclMsgReleasePhoneBookListMethodResult;
class most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart;
class most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult;
class most_fi_tcl_PhonBkPhoneBookListSliceResultItem;

class most_fi_tcl_PhonBkPhoneBookListSliceResultExtendedItem;

class most_fi_tcl_e8_PhonBkPhoneBookSortType;
class most_phonbkfi_tclMsgSearchPhoneBookMethodStart;
class most_phonbkfi_tclMsgSearchPhoneBookMethodResult;
class most_phonbkfi_tclMsgSearchContactsMethodStart;
class most_phonbkfi_tclMsgSearchContactsMethodResult;
class most_phonbkfi_tclMsgAddContactMethodStart;
class most_phonbkfi_tclMsgAddContactMethodResult;
class most_phonbkfi_tclMsgEditContactMethodStart;
class most_phonbkfi_tclMsgEditContactMethodResult;
class most_phonbkfi_tclMsgDeleteContactMethodStart;
class most_phonbkfi_tclMsgDeleteContactMethodResult;

class most_phonbkfi_tclMsgGetContactDetailsMethodStart;
class most_phonbkfi_tclMsgGetContactDetailsMethodResult;

class most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart;
class most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult;
class most_phonbkfi_tclMsgGetContactPhotoMethodStart;
class most_phonbkfi_tclMsgGetContactPhotoMethodResult;
class most_fi_tcl_e8_PhonBkContactListType;
class most_fi_tcl_e8_PhonBkContactSortType;



class most_phonbkfi_tclMsgListChangeStatus;
class FC_PhoneBook_VCard_Property;
class FC_PhoneBook_CallHistory_List;
class FC_Phonebook_tclFavorite_Provider;
class most_fi_tcl_e8_PhonBkNumberType;
class most_fi_tcl_e8_PhonBkContactType;
class most_fi_tcl_PhonBkPhoneNumberItem;

class most_phonbkfi_tclMsgCreateContactListMethodStart;
class most_phonbkfi_tclMsgCreateContactListMethodResult;
class most_phonbkfi_tclMsgSetContactPositionMethodStart;
class most_phonbkfi_tclMsgSetContactPositionMethodResult;

class most_phonbkfi_tclMsgAddContactExtendedMethodStart;
class most_phonbkfi_tclMsgAddContactExtendedMethodResult;

class most_phonbkfi_tclMsgEditContactExtendedMethodStart;
class most_phonbkfi_tclMsgEditContactExtendedMethodResult;

class most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart;
class most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult;

class most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart;
class most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult;


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

#define CONTACTNAME_TAG  (quint32)0
#define FIRSTNAME_TAG	 (quint32)1
#define LASTNAME_TAG	 (quint32)2
#define POINAME_TAG	     (quint32)3
#define PREFNUMBER_TAG	 (quint32)4
#define CELLNUMBER1_TAG	 (quint32)5
#define CELLNUMBER2_TAG	 (quint32)6
#define HOMENUMBER1_TAG	 (quint32)7
#define HOMENUMBER2_TAG	 (quint32)8
#define WORKNUMBER1_TAG	 (quint32)9
#define WORKNUMBER2_TAG	 (quint32)10
#define OTHERNUMBER_TAG  (quint32)11
#define EMAILADD1_TAG    (quint32)12
#define EMAILADD2_TAG	 (quint32)13
#define EMAILADD3_TAG	 (quint32)14
#define HOMEADD_TAG		 (quint32)15
#define WORKADD_TAG		 (quint32)16
#define OTHERADD_TAG	 (quint32)17
#define CATEGORY_TAG	 (quint32)18
#define NOTES_TAG		 (quint32)19

#define MAXIMUM_REPORTED_MATCHES 50

// CMG3G-7853: Phonebook list slice result to have the number and email details
typedef enum
{
   PHONE_NUMBER_NONE = 0,
   PHONE_NUMBER_PREFERRED,
   PHONE_NUMBER_CELL,
   PHONE_NUMBER_HOME,
   PHONE_NUMBER_WORK,
   PHONE_NUMBER_OTHER
}tenPhonBkNumberType;

typedef struct PhonBkPhoneNumberItem
{
   QString qsPhoneNumber;
   tenPhonBkNumberType enPhoneNumberType;
}PbkPhoneNoItem;



class FC_PhoneBook_List
{
public:
   //FIX GMMY15-1578 Bosch Internal: Proper usage of SQLite database instead of RAM -- removing redundant objects which are created in RAM for different clients & sorted lists.
   bool CreatePhoneBookList(
      const most_phonbkfi_tclMsgCreatePhoneBookListMethodStart* methodStart,
      most_phonbkfi_tclMsgCreatePhoneBookListMethodResult* methodResult,
      tU32 registerID);


   bool CreateContactList(
      const most_phonbkfi_tclMsgCreateContactListMethodStart* methodStart,
      most_phonbkfi_tclMsgCreateContactListMethodResult* methodResult,
      tU32 registerID);

   bool RequestSlicePhoneBookList(
      const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart* methodStart,
      most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult* methodResult );

   bool RequestSlicePhoneBookListExtended(
      const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart* methodStart,
      most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult* methodResult );

   bool ReleasePhoneBookList(
      const most_phonbkfi_tclMsgReleasePhoneBookListMethodStart* methodStart,
      most_phonbkfi_tclMsgReleasePhoneBookListMethodResult* methodResult,
      tU32 registerID);  //FIX GMMY15-1578 RegisterID is passed to identify the requested client

   bool SearchKeyboardPhoneBookList(
      const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart* methodStart,
      most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult* methodResult );

   bool SearchPhoneBook(
      const most_phonbkfi_tclMsgSearchPhoneBookMethodStart* methodStart,
      most_phonbkfi_tclMsgSearchPhoneBookMethodResult* methodResult);

   bool SearchContacts(
      const most_phonbkfi_tclMsgSearchContactsMethodStart* methodStart,
      most_phonbkfi_tclMsgSearchContactsMethodResult* methodResult);

   bool AddContact(
      const most_phonbkfi_tclMsgAddContactMethodStart* methodStart,
      most_phonbkfi_tclMsgAddContactMethodResult* methodResult );

   bool EditContact(
      const most_phonbkfi_tclMsgEditContactMethodStart* methodStart,
      most_phonbkfi_tclMsgEditContactMethodResult* methodResult );

   bool DeleteContact(
      const most_phonbkfi_tclMsgDeleteContactMethodStart* methodStart,
      most_phonbkfi_tclMsgDeleteContactMethodResult* methodResult );

   bool ClearPhoneBookData();//FIX GMMY16-23858
   bool ClearVehiclePhoneBook(tU8 u8DeviceHandle);
   bool bClearVehiclePhonebookExtended(tU8 u8DeviceHandle); //Fix CMG3G-9334

   bool GetContactDetails(
      const most_phonbkfi_tclMsgGetContactDetailsMethodStart* methodStart,
      most_phonbkfi_tclMsgGetContactDetailsMethodResult* methodResult );

   bool GetContactPhotoInfo(
      const most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart* methodStart,
      most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult* methodResult,
      tU16& u16ErrorCode);

   bool GetContactPhoto(
      const most_phonbkfi_tclMsgGetContactPhotoMethodStart* methodStart,
      most_phonbkfi_tclMsgGetContactPhotoMethodResult* methodResult,
      tU16& u16ErrorCode);

   void AddNewVCardData(
      GByteArray* data,
      int phonebookType,
      unsigned char deviceHandle
      );

   FC_PhoneBook_SQLite::SortType GetSortTypeForDevice(quint8 u8DeviceHandle);

   bool DeleteRecordsOFDevice(quint8 u8DeviceHandle);
   void FindingNumbertypeOfNumber(quint32 u32ContactHandle,QString qsnumber,quint8 u8numbertype,most_phonbkfi_tclMsgGetContactDetailsMethodResult* methodResult);

   void MethodResultPosted(const guint16 u16FuntionID,
      const most_phonbkfi_tclMsgBaseMessage* MethodStart,
      const most_phonbkfi_tclMsgBaseMessage* MethodResult);

   void DownloadCompleted(quint8 u8DeviceHandle);
   void DeviceDisconnected(FC_Device_Details* DeviceDetails);
   void PhoneBookDownloadInitiated(FC_Device_Details* DeviceDetails);
   void DeviceDeleted(guint8 u8DeviceHandle);
   void DownloadAborted(tU8 u8DeviceHandle);
   void RegisterFavoritesProvider(FC_Phonebook_tclFavorite_Provider* pFavoritesProvider);
   void InitializeDatabase();
   void DeviceConnected(FC_Device_Details* DeviceDetails);
   const QHash< quint16, FC_PhoneBook_List_Data* >* poGetHashTable()   // Return type const to avoid LINT Warning 1536 (CMG3G-4848)
   {
      return &m_hashPbList;
   }

   quint32 GetListSize(QList<FC_PhoneBook_Contact_Detail>& PBContactList);
   bool UpdateSortView(quint8 u8DeviceHandle);
   bool bUpdateDlCompletedOnceValue(quint8 u8DeviceHandle, bool bValue);

   // CLONE TICKET FIX - GMMY15-1545 - Singleton creation for FC_PhoneBook_List and FC_PhoneBook_CallHistory_List
   // Provide static public function to create and destroy instance
   static FC_PhoneBook_List* pGetInstance();
   static tVoid vDestroyInstance();

   void SearchPhoneNumberEntriesInPB(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart* methodStart,
      most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult* methodResult,guint8 u8DeviceHandle);
   //FIX CMG3GB-505 Upon disconnecting a call/call is established/entering numbers in dialpad, resets when doing handsfree operation was observed
   tU8 AutoCompletePhNoSearchIndex;
   //End of fix

   //FIX GMMY15-1578 Bosch Internal: Proper usage of SQLite database instead of RAM -- removing redundant objects which are created in RAM for different clients & sorted lists.
   void vClearPBListAndHashListEntriesForListHandle(tU16 u16ListHandle, tU8 u8DeviceHandle);
   //End of fix GMMY15-1578

   //FIX CMG3G-8367 IS2424_DownloadOnOff behaviour@FC_Phonebook
   // The user shall have possibility to switch the phonebook and call history list download On or Off individual for each paired phone device.
   bool bClearPBRecords(quint8 u8DeviceHandle);
   //End of fix FIX CMG3G-8367

   //Fix CMG3G-8365 IS2421_Configurable phone number type representation@FC_Phonebook
   bool AddContactExtended(
      const most_phonbkfi_tclMsgAddContactExtendedMethodStart* methodStart,
      most_phonbkfi_tclMsgAddContactExtendedMethodResult* methodResult );

   bool EditContactExtended(
      const most_phonbkfi_tclMsgEditContactExtendedMethodStart* methodStart,
      most_phonbkfi_tclMsgEditContactExtendedMethodResult* methodResult);

   bool GetContactDetailsExtended(
      const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart* methodStart,
      most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult* methodResult);
   //End of Fix CMG3G-8365 IS2421_Configurable phone number type representation@FC_Phonebook

   void MapContactDetailTypeToFItype(quint8& u8NumberType);
   QString StripTelephoneNumber(QString sTelephoneNumber);

   void ExtractingOfFirstNPhoneNumbers(
        quint8 u8numbertype,
        FC_PhoneBook_Contact_Detail* contact,
        QString qsPhoneNumber);

   bool GetPositionForContactHandle(
      const most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart * methodStart,
      most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult* methodResult );

private:

   struct FC_PhoneBook_PngImageCache
   {
      quint32     m_u32ContactHandle;
      quint16     m_u16PhotoDlCRC;
      QByteArray  m_qbaPhotoData;
   };


   tBool bValidateSearchString(QString &sSearchString);
   tBool bValidateDeviceHandles(QList<tU8>& DeviceHandleList);

   // CLONE TICKET FIX - GMMY15-1545 - Singleton creation for FC_PhoneBook_List and FC_PhoneBook_CallHistory_List
   // Make constructor, copy constructor and destructor private
   FC_PhoneBook_List();
   ~FC_PhoneBook_List();
   FC_PhoneBook_List(const FC_PhoneBook_List &);

   static FC_PhoneBook_List* m_self;

   bool bCheckForContactMemory(FC_PhoneBook_MemoryUsage* poPbMemUsage, quint32 u32ContactMemoryToBeAdded);

   void Convert( const FC_PhoneBook_Contact_Detail_Short* contact,
      most_fi_tcl_PhonBkPhoneBookListSliceResultItem* item );
   void ConvertExtended( const FC_PhoneBook_Contact_Detail_Short* contact, most_fi_tcl_PhonBkPhoneBookListSliceResultExtendedItem* item,
         const PbkAdditionalContactInfo *pbkcontact);

   void ConvertExtended( const FC_PhoneBook_Contact_Detail_Short* contact, most_fi_tcl_PhonBkPhoneBookListSliceResultExtendedItem* item );

   void AddPropertyToPhoneBookContact(
      const FC_PhoneBook_VCard_Property* prop,
      FC_PhoneBook_Contact_Detail* contact,
      const int& phonebookType);

   bool ParseVCards(
      QByteArray ba,
      int phonebookType,
      unsigned char deviceHandle,
      QList<FC_PhoneBook_Contact_Detail> & list);

   FC_PhoneBook_SQLite::SortType getSortType( const most_fi_tcl_e8_PhonBkPhoneBookSortType* type );
   FC_PhoneBook_SQLite::SortType getSortType( const most_fi_tcl_e8_PhonBkSearchSortType* type );
   FC_PhoneBook_SQLite::SortType getSortType( const most_fi_tcl_e8_PhonBkContactSortType* type );
   void CompareAndInsertIntoDatabase(QList<FC_PhoneBook_Contact_Detail>& PBContactList,
      quint8 u8DeviceHandle);
   void vTranscodePhotoIfBig(FC_PhoneBook_Contact_Detail& ContactDetail);  // -FastPhotoHandling-
   quint8 MapTelTypeToInteger(QString numType);
   void InsertContactsIntoDatabase(
      QList<FC_PhoneBook_Contact_Detail>& PBContactList, quint8 u8DeviceHandle);


   void vShiftRAMContentToDatabaseBasedOnMemThresholds(quint8 u8DeviceHandle,
      quint32 u32ContactsNumberThreshold, quint32 u32PhotoNumberThreshold);

private:
   //key = ListHandle, value = the contact list
   QHash< quint16, FC_PhoneBook_List_Data* > m_hashPbList;
   FC_PhoneBook_SQLite* m_sqlite;
   FC_Phonebook_tclFavorite_Provider* m_poFavoritesProvider;

   //FIX GMMY15-1578 Bosch Internal: Proper usage of SQLite database instead of RAM -- removing redundant objects which are created in RAM for different clients & sorted lists.
   //Key:List Handle, Value: Client Register ID
   QMultiHash<tU16, tU32> m_multiHashPBClientRequests;
   //End of fix GMMY15-1578

};

#endif//_FC_PHONEBOOK_LIST_
