/*******************************************************************************
 *
 * FILE:			FC_Phone_WorkQueueScheduler.h
 *
 * SW-COMPONENT:	FC_Phone application
 *
 * PROJECT:			BOSCH-GM-NEXTGEN
 *
 * DESCRIPTION:		Contains functions to 1)Lock and unlock mutex 2)Initialize and destroy mutex 3) Work Queue Scheduler
 *
 * AUTHOR:			Priya Sekhar
 *
 * COPYRIGHT:		(c) 2013 Robert Bosch Coimbatore
 *
 *******************************************************************************/

#define FC_Phone_S_IMPORT_INTERFACE_MSG
#include "FC_Phone_if.h"

#include "pthread.h"

#ifndef FC_Phone_WORKQUEUESCHEDULER_H_
#define FC_Phone_WORKQUEUESCHEDULER_H_

#define FC_PHONE_WORK_QUEUE_TIMER_VALUE 5

class fc_phone_tclPhoneMutex
{
private:
   static fc_phone_tclPhoneMutex* m_poPhoneMutexObject;
   pthread_mutex_t m_PhoneDbusMutex;
   static pthread_t m_WorkQueueThreadID;
public:
   fc_phone_tclPhoneMutex();
   ~fc_phone_tclPhoneMutex();

   static fc_phone_tclPhoneMutex* PhoneMutexInit();
   static void PhoneMutexDestroy();
   static int PhoneMutexTrylock(struct Job *f_poJob, tU8 u8TimerValue = FC_PHONE_WORK_QUEUE_TIMER_VALUE);
   static int PhoneMutexUnlock();
   static void *WorkQueueScheduler(void *ptr);
};

#endif /* FC_Phone_WORKQUEUESCHEDULER_H_ */
