/*******************************************************************************
 *
 * FILE:			FC_Phone_WorkQueue.h
 *
 * SW-COMPONENT:	FC_Phone application
 *
 * PROJECT:			BOSCH-GM-NEXTGEN
 *
 * DESCRIPTION:		Contains functions to 1)Create and destroy a fc_phone_tclWorkQueue 2)Insert and fetch jobs from the queue
 *
 * AUTHOR:			Priya Sekhar
 *
 * COPYRIGHT:		(c) 2013 Robert Bosch Coimbatore
 *
 *******************************************************************************/

#ifndef FC_PHONE_WORKQUEUE_H_
#define FC_PHONE_WORKQUEUE_H_

#include "../FC_Phone_main.h"
#include "pthread.h"
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include <qmutex.h>

typedef tVoid (fc_phone_tclService_Telephone::*MethodStart)(
      amt_tclServiceData* poMessage, struct Job* poMethodStart);

struct Job
{
   MethodStart m_pfMethod;
   tU16 u16SourceAppID;
   tU16 u16RegisterID;
   tU16 u16CmdCounter;
   tU16 u16FunctionID;
   tVoid* m_poMethodStart;
};

struct jobNode
{
   Job* m_poJob;
   jobNode* next;
};

class fc_phone_tclWorkQueue
{
private:
   fc_phone_tclWorkQueue();
   ~fc_phone_tclWorkQueue();

   jobNode* head;
   jobNode* tail;
   tU8 m_u8Size;
   QMutex m_WorkQueueLock;
   tU16 m_u16CurrentFID;
   static fc_phone_tclWorkQueue *m_pWorkQueueInstance;

public:
   static fc_phone_tclWorkQueue* getWorkQueueInstance();
   void createWorkQueue();
   static void destroyWorkQueue();
   void insertNewJob(struct Job *f_poJob);
   void fetchNextJob(tBool f_bDoINeedToCallMethod);
   //FIX GMMY16-7888 [CT][MY16 D1BL Telephone] HMI reset observed when calls were swapped and then end call selected immediately.
   //Posting loop back message for methods retrieved from work queue instead of accessing using worker thread.
   tVoid vSendToCCAThread(Job* jobToBeSent, tBool bMethodError = FALSE);
   //End of fix

   tVoid vSetCurrentRequestFID(tU16); //Fix for task CMG3G-5839
   tVoid vUpdateList(jobNode* temp, struct Job * f_poJob);
};

#endif /* FC_PHONE_WORKQUEUE_H_ */
