/*******************************************************************************
 *
 * FILE:			FC_Phone_WorkQueue.cpp
 *
 * SW-COMPONENT:	FC_Phone application
 *
 * PROJECT:			BOSCH-GM-NEXTGEN
 *
 * DESCRIPTION:		Contains functions to 1)Create and destroy a WorkQueue 2)Insert and fetch jobs from the queue
 *
 * AUTHOR:			Priya Sekhar
 *
 * COPYRIGHT:		(c) 2013 Robert Bosch Coimbatore
 *
 *******************************************************************************/

#include "FC_Phone_WorkQueue.h"
#include "../FC_Phone_service_Telephone.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_WorkQueue.cpp.trc.h"
#endif

fc_phone_tclWorkQueue* fc_phone_tclWorkQueue::m_pWorkQueueInstance = NULLPTR;

/*******************************************************************************
 * FUNCTION:  	createWorkQueue
 * DESCRIPTION:  function is used to create fc_phone_tclWorkQueue object.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
void fc_phone_tclWorkQueue::createWorkQueue()
{
   head = NULLPTR;
   tail = NULLPTR;
   m_u8Size = 0;
   m_u16CurrentFID = 0;
}

/*******************************************************************************
 * FUNCTION:  	destroyWorkQueue
 * DESCRIPTION:  function is used to destroy fc_phone_tclWorkQueue object.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
void fc_phone_tclWorkQueue::destroyWorkQueue()
{
   ETG_TRACE_USR4(("destroyWorkQueue : Called"));

   if(m_pWorkQueueInstance)
   {
      delete m_pWorkQueueInstance;
      m_pWorkQueueInstance = NULLPTR;
   }
}

/*******************************************************************************
 * FUNCTION:  	fc_phone_tclWorkQueue
 * DESCRIPTION:  constructor
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
fc_phone_tclWorkQueue::fc_phone_tclWorkQueue()
{
   ETG_TRACE_USR4(("fc_phone_tclWorkQueue : Called"));
   // CMG3G-8447. Lint fix.
   head = NULLPTR;
   tail = NULLPTR;
   m_u8Size = 0;
   m_u16CurrentFID = 0;
}

/*******************************************************************************
 * FUNCTION:  	~fc_phone_tclWorkQueue
 * DESCRIPTION:  destructor
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
fc_phone_tclWorkQueue::~fc_phone_tclWorkQueue()
{
   ETG_TRACE_USR4(("~fc_phone_tclWorkQueue : Called"));

   jobNode* temp;
   while (head)
   {
      ETG_TRACE_USR4(("Deleting the node from work queue"));
      temp = head;
      head = head->next;
      delete temp;
   }

   head = NULLPTR;
   tail = NULLPTR;
   m_u8Size = 0;
   m_u16CurrentFID = 0;
}

/*******************************************************************************
 * FUNCTION:  	getWorkQueueInstance
 * DESCRIPTION: Get work queue instance
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
fc_phone_tclWorkQueue* fc_phone_tclWorkQueue::getWorkQueueInstance()
{
   if(!m_pWorkQueueInstance)
      m_pWorkQueueInstance = new fc_phone_tclWorkQueue();

   return m_pWorkQueueInstance;
}

/*******************************************************************************
 * FUNCTION:  	insertNewJob
 * DESCRIPTION:  function is used to insert new job in queue.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
void fc_phone_tclWorkQueue::insertNewJob(struct Job *f_poJob)
{
   ETG_TRACE_USR4(("insertNewJob : Called"));

   QMutexLocker lock(&m_WorkQueueLock);

   jobNode* temp;

   temp = new jobNode;
   if(temp)
   {
      vUpdateList(temp,f_poJob);
      m_u8Size++;
      ETG_TRACE_USR2(("Job in work queue is::%u",m_u8Size));
   }
}

/*******************************************************************************
 * FUNCTION:  	fetchNextJob
 * DESCRIPTION:  function is used to fetch job in queue.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
void fc_phone_tclWorkQueue::fetchNextJob(tBool f_bDoINeedToCallMethod)
{
   ETG_TRACE_USR4(("fetchNextJob : Called"));

   QMutexLocker lock(&m_WorkQueueLock);

   if(!head)
   {
      ETG_TRACE_USR4(("Queue is empty"));
      return;
   }

   jobNode* temp;
   temp = head;
   head = head->next;

   if(f_bDoINeedToCallMethod)
   {
      if (temp->m_poJob)
      {
         // call using function pointer
         ETG_TRACE_USR4(("call using function pointer"));
         //gmmy15-11360
         (fc_phone_tclService_Telephone::pGetInstance())->vResetStoredCallInstance(temp->m_poJob->u16FunctionID);

         //FIX GMMY16-7888 [CT][MY16 D1BL Telephone] HMI reset observed when calls were swapped and then end call selected immediately.
         //Posting loop back message for methods retrieved from work queue instead of accessing using worker thread.
         vSendToCCAThread(temp->m_poJob);
         //End of fix
      }
   }

   m_u8Size--;
   delete temp;

   ETG_TRACE_USR2(("Job in work queue is::%u",m_u8Size));
}

//FIX GMMY16-7888 [CT][MY16 D1BL Telephone] HMI reset observed when calls were swapped and then end call selected immediately.
/*******************************************************************************
 * FUNCTION:  	vSendToCCAThread
 * DESCRIPTION:  function is used to send a job from worker thread to CCA thread.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
tVoid fc_phone_tclWorkQueue::vSendToCCAThread(Job* jobToBeSent, tBool bSendMethodError)
{
   ETG_TRACE_USR4(("vSendToCCAThread entered"));
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if (TRUE == poTelService->m_bServerAvailable)
      {
         LoopBackData LB_data_from_workqueue;

         if (!bSendMethodError)
         {
            LB_data_from_workqueue.job.m_pfMethod = jobToBeSent->m_pfMethod;
            LB_data_from_workqueue.job.u16SourceAppID = jobToBeSent->u16SourceAppID;
            LB_data_from_workqueue.job.u16RegisterID = jobToBeSent->u16RegisterID;
            LB_data_from_workqueue.job.u16CmdCounter = jobToBeSent->u16CmdCounter;
            LB_data_from_workqueue.job.u16FunctionID = jobToBeSent->u16FunctionID;
            LB_data_from_workqueue.job.m_poMethodStart = (tVoid*) jobToBeSent->m_poMethodStart;

            LB_data_from_workqueue.u16FunctionID = FC_PHONE_LB_FROM_WQ_FOR_QUEUED_METHODS;

            poTelService->push_back_LB_data(LB_data_from_workqueue);
            poTelService->vPrepareLoopBackMsg(FC_PHONE_LB_FROM_WQ_FOR_QUEUED_METHODS);
         }
         else
         {
            LB_data_from_workqueue.job.u16FunctionID = m_u16CurrentFID;
            LB_data_from_workqueue.u16FunctionID = FC_PHONE_LB_FROM_WQ_FOR_FAILED_METHODS;
            poTelService->push_back_LB_data(LB_data_from_workqueue);
            poTelService->vPrepareLoopBackMsg(FC_PHONE_LB_FROM_WQ_FOR_FAILED_METHODS);
         }
      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: vSendToCCAThread poTelService is NULL "));
      }
   }
}
//End of fix

//Fix for task CMG3G-5839
tVoid fc_phone_tclWorkQueue::vSetCurrentRequestFID(tU16 u16CurrentFID)
{
   ETG_TRACE_USR4(("vSetCurrentRequestFID entered FID: %d", u16CurrentFID));
   m_u16CurrentFID = u16CurrentFID;
}

/*******************************************************************************
 * FUNCTION:   vUpdateList
 * DESCRIPTION:  function is used to update the list with jobs added.
 *
 * PARAMETER: jobNode, Job
 *
 * RETURNVALUE: none
 ********************************************************************************/
tVoid fc_phone_tclWorkQueue::vUpdateList(jobNode* temp, struct Job * f_poJob)
{
   ETG_TRACE_USR4(("updateList for new job"));
   temp->next = NULLPTR;
   temp->m_poJob = f_poJob;

   if(!head)
   {
      head = temp;
      tail = head;
   }
   else
   {
      if (tail)
      {
         tail->next = temp;
         tail = temp;
      }
   }
}
