/******************************************************************************
 *
 * FILE:          FC_Phone_SMVRSession.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:        Vignesh R
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"
#include "../FC_Phone_clienthandler_MediaPlayer.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SMVRSession.cpp.trc.h"
//#include "HelperClasses/FC_Phone_PhoneData.h"
#endif

fc_phone_tclSMVRSession * fc_phone_tclSMVRSession::m_poVRInstance = NULLPTR;

// CMG3G-7982- Extend VR session
tVoid vExtendVRSessionTimerCallBack(tU16 u16TimerID);

tVoid vAudioCallBackVR(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" ENTER: vAudioCallBackVR %d",u16AudioReqID));

   switch (u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_SPEECH:
      {
         ETG_TRACE_USR4((" u16AudioChannelId::FC_PHONE_AUDIOCHANNEL_SPEECH"));

         fc_phone_tclSMManager* m_poSMManagerVR = fc_phone_tclSM::m_poSMManager;

         if (m_poSMManagerVR)
         {
            if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
            {
               ETG_TRACE_USR4((" u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED"));
               m_poSMManagerVR->vProcessVREvent(FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK);
            }
            else
            {
               ETG_TRACE_USR4((" u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED"));
               m_poSMManagerVR->vProcessVREvent(FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK);
            }
         }
      }
      break;

      default:
         break;
   }
   ETG_TRACE_USR4((" EXIT: vAudioCallBackVR"));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMVRSession
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMVRSession::fc_phone_tclSMVRSession():fc_phone_tclSM()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMVRSession::fc_phone_tclSMVRSession"));

   m_poVRInstance = this;
   m_bAVinterrupt = FALSE;
   m_u16State = STATE_IDLE;
   ETG_TRACE_USR4((" State initialized: STATE_IDLE "));
   m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
   bActivationFromDevice = FALSE;
   m_bBTVRProcessingRelease = FALSE;

// CMG3G-7982- Extend VR session
   m_bExtendVRSessionTimerRunning = FALSE;

   m_u16TimerId = FC_PHONE_TIMER_ID_INVALID;
   m_u16SubState = FC_PHONE_VR_STATE_GET_REQUEST;
   m_u8VRRelStatus = EN_VR_IDLE;

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMVRSession::fc_phone_tclSMVRSession"));
}

/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclSMVRSession
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclSMVRSession::~fc_phone_tclSMVRSession()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMVRSession::~fc_phone_tclSMVRSession"));

}



/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMVRSession::vCancel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMVRSession::vCancel(tVoid)
{
   ETG_TRACE_USR4((" State Reset: STATE_IDLE "));
   m_u16State = STATE_IDLE;
   m_u16SubState = FC_PHONE_VR_STATE_GET_REQUEST;
   m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
   bActivationFromDevice = FALSE;
   m_bBTVRProcessingRelease = FALSE;

   // CMG3G-7982- Extend VR session
   m_bExtendVRSessionTimerRunning = FALSE;

   m_u8VRRelStatus = EN_VR_IDLE;
}



/*******************************************************************************
 *
 * FUNCTION: FC_Bluetooth_SMAvpSession:: poGetInstance
 *
 * DESCRIPTION: Get the curent VRSession instance
 *
 * PARAMETER:None
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMVRSession* fc_phone_tclSMVRSession:: poGetInstance(void)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMVRSession:: poGetInstance"));
   return m_poVRInstance;
}

/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMVRSession::bProcessEvent(tU16 u16EventId,tVoid *varg)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMVRSession::bProcessEvent with arg"));

   tBool bRetVal= FALSE ;

   FcPhone_processEventArg   *ptProcessEventArg = (FcPhone_processEventArg *) varg;
   //if dbus call is not success , update the error code

   if (FC_PHONE_SM_EVENT_SLC_OFF == u16EventId)
   {
      ETG_TRACE_USR4((" FC_PHONE_SM_EVENT_SLC_OFF"));
      bRetVal = bHandleEventSLCOFF(varg);
      return bRetVal;
   }


   if (TRUE == ptProcessEventArg->bIsItDbusAck )
   {
      ETG_TRACE_USR4((" Status :: %d  Code :: 0x%x",ptProcessEventArg->Status,ptProcessEventArg->Code));

      if (FC_PHONE_DBUS_STATUS_SUCCESS != ptProcessEventArg->Code)
      {
         ETG_TRACE_USR4((" DBUS Call is not succeed "));

         fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
         fc_phone_tclService_Telephone *poTelService = fc_phone_tclService_Telephone::pGetInstance();

         if ((!poTelService) || (!p_clientHndler_bluetooth))
         {
            ETG_TRACE_USR4(("poTelService or p_clientHndler_bluetooth is NULL. Hence returning"));
            return false;
         }

         tU8 u8BDAddressId = p_clientHndler_bluetooth->u8GetBTAddressIdFromDeviceHandle(poTelService->u8GetActiveDeviceHandle());
         tU8 u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(u8BDAddressId))); //CMG3G-4847 - To solve Lint
         ETG_TRACE_USR4((" u8SCOConnectionStatus = %u ",u8SCOConnectionStatus));

         if (FC_PHONE_VR_STATE_WAITFOR_STOPVR_FROMBT == m_u16SubState)
         {
            if (FC_PHONE_VR_STATUS_DEACTIVATE == ptProcessEventArg->Status)
            {
               if (FC_PHONE_DBUS_SCO_CONN_ESTABLISHED == u8SCOConnectionStatus)
               {
                  m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
               }
               vProcessEvent(FC_PHONE_SM_EVENT_DBUS_VOICEREC_WAITFOR_STOPVR_DEACTIVATION_ACK_OK);
            }
            else
            {
               // Activation itself got failed. Hence skipping the stop VR sequence and proceeding with the Start VR for the Passive device
               ETG_TRACE_USR4(("Proceed with VR Activation for the Other HFP connected device"));
               vProcessVRRequestForOtherDevice();
            }
         }
         else
         {
            ETG_TRACE_USR4((" DBUS Call is not succeed, updating error code"));
            vHandleDbusError(ptProcessEventArg->u16DbusAckType, ptProcessEventArg->Code);

            //GMMY15-11744 - if activation is comming as error from device, Phone F-Block should release the LC_SPEECH_REG channel which is already acquired.
            if(m_u16AudioChannel == FC_PHONE_AUDIOCHANNEL_SPEECH && ptProcessEventArg->Status == FC_PHONE_VR_STATUS_ACTIVATE )
            {
               ETG_TRACE_USR4((" FC_PHONE_VR_STATUS_ACTIVATE"));

               // Fixed as a part of NCG3D-79618.
               // If SCO is established in this scenario, then it implies that it should be VR-ReActivation request failure

               // If Error is received for ReActivating VR session (Sending VR Activation request when VR session is already ACTIVE),
               // the SCO channel alone is released as of now and the VR session is ENDED from HMI perspective.

               if (FC_PHONE_DBUS_SCO_CONN_ESTABLISHED == u8SCOConnectionStatus)
               {
                  m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
               }

               vEndVoiceSesion();
            }
            //GMMY15-11744 - if de-activation is comming as error from device, continue with the vr session.
            else if(m_u16AudioChannel ==FC_PHONE_AUDIOCHANNEL_ID_UNUSED && ptProcessEventArg->Status == FC_PHONE_VR_STATUS_DEACTIVATE)
            {
               ETG_TRACE_USR4((" FC_PHONE_VR_STATUS_DEACTIVATE"));
               vHandleVoiceRecActive();
            }
         }
      }
      else
      {
         ETG_TRACE_USR4((" DBUS Call is  succeeded "));

         tU16 u16EventIdtoBeProcessed = u16EventId;

         if ((FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACTIVATION_ACK_OK == u16EventIdtoBeProcessed) && (FC_PHONE_VR_STATE_WAITFOR_STOPVR_FROMBT == m_u16SubState))
         {
            u16EventIdtoBeProcessed = FC_PHONE_SM_EVENT_DBUS_VOICEREC_WAITFOR_STOPVR_DEACTIVATION_ACK_OK;
         }

         vProcessEvent(u16EventIdtoBeProcessed);
      }
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMVRSession::bProcessEvent with arg"));

   return bRetVal ;
}

/*******************************************************************************
 *
 * FUNCTION: vProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vProcessEvent(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vProcessEvent : %u", u16EventId));

   switch ( m_u16State )
   {
      case STATE_IDLE:
      {
         ETG_TRACE_USR2(("STATE_IDLE"));
         vHandleEventInIdleState(u16EventId);
      }
      break;

      case STATE_ACTIVE:
      {
         ETG_TRACE_USR2(("STATE_ACTIVE"));
         vHandleEventInActiveState(u16EventId);
      }
      break;
        default:
           {
              ETG_TRACE_USR3(("IN DEFAULT "));
           }
   }

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_CCX_VR_SA_ON:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_VR_SA_ON"));
         vHandleSourceActvityOn();
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_VR_SA_OFF:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_VR_SA_OFF"));
         vHandleSourceActvityOff();
      }
      break;

      default:
      {
         ETG_TRACE_USR3(("IN DEFAULT "));
      }
      break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMVRSession::vProcessEvent"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInIdleState
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
void fc_phone_tclSMVRSession::vHandleEventInIdleState(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleEventInIdleState : %u", u16EventId));

   switch ( m_u16SubState )
   {
      case FC_PHONE_VR_STATE_GET_REQUEST:
      {
         ETG_TRACE_USR3(("FC_PHONE_VR_STATE_GET_REQUEST"));
         vHandleEventInGetRequest(u16EventId);
      }
      break;

      case FC_PHONE_VR_STATE_RELEASE_REQUEST:
      {
         ETG_TRACE_USR3(("FC_PHONE_VR_STATE_RELEASE_REQUEST"));
         vHandleEventInReleaseRequest(u16EventId);
      }
      break;

      default:
         ETG_TRACE_USR4((" default %u", m_u16SubState));
         break;
   }

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_ACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_ACTIVE"));
         vHandleVoiceRecActive();
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_INACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_INACTIVE"));

         //Fixed as a part of PSARCCB-5362.
         //On receiving SA_OFF as an external trigger, the ExtendVRSessionTimer should be ended if running.
         vStopExtendedVRSession();

         vSendBtVRStatus();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_ACTIVATION_IND:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_ACTIVATION_IND"));
         vHandleVoiceRecActivationInd();
      }
      break;

      default:
         ETG_TRACE_USR3((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMVRSession::vHandleEventInIdleState"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInGetRequest
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
void fc_phone_tclSMVRSession::vHandleEventInGetRequest(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleEventInGetRequest : %d", u16EventId));

   switch ( u16EventId )
   {
      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK"));
         vHandleSpeechGetRequestOk();
      }
      break;

      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK"));
         vHandleSpeechGetRequestNOk();
      }
      break;

      //GMMY15-10532 - Handling HfVoiceRecognitionActivationInd OFF in Idle state
      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACTIVATION_IND:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACTIVATION_IND"));
         vHandleVoiceRecDeActivationInd();
      }
      break;

      default:
         ETG_TRACE_USR4((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMVRSession::vHandleEventInGetRequest"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInReleaseRequest
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
void fc_phone_tclSMVRSession::vHandleEventInReleaseRequest(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleEventInReleaseRequest : %d", u16EventId));

   switch ( u16EventId )
   {
      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK"));
         vHandleSpeechReleaseRequestOk();
      }
      break;

      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK"));
         vHandleSpeechReleaseRequestNOk();
      }
      break;

      default:
         ETG_TRACE_USR4((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMVRSession::vHandleEventInReleaseRequest"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInWaitForStopVR
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
void fc_phone_tclSMVRSession::vHandleEventInWaitForStopVR(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleEventInWaitForStopVR : %d", u16EventId));

   switch ( u16EventId )
   {
      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_WAITFOR_STOPVR_DEACTIVATION_ACK_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_WAITFOR_STOPVR_DEACTIVATION_ACK_OK"));

         m_u8VRRelStatus |= EN_VR_DEACT_OK;

         fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
         NULL_CHECK(p_clientHndler_bluetooth)

         fc_phone_tclService_Telephone *poTelService = fc_phone_tclService_Telephone::pGetInstance();
         NULL_CHECK(poTelService)

         tU8 u8BDAddressId = p_clientHndler_bluetooth->u8GetBTAddressIdFromDeviceHandle(poTelService->u8GetActiveDeviceHandle());
         tU8 u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(u8BDAddressId))); //CMG3G-4847 - To solve Lint
         ETG_TRACE_USR4((" u8SCOConnectionStatus = %u ",u8SCOConnectionStatus));

         if ((EN_VR_SCO_REL_DEACT_OK == m_u8VRRelStatus) || (FC_PHONE_DBUS_SCO_CONN_ESTABLISHED != u8SCOConnectionStatus))
         {
            vProcessVRRequestForOtherDevice();
         }
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_RELEASE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_RELEASE"));

         m_u8VRRelStatus |= EN_VR_SCO_REL;

         if (EN_VR_SCO_REL_DEACT_OK == m_u8VRRelStatus)
         {
            vProcessVRRequestForOtherDevice();
         }

      }
      break;

      default:
         ETG_TRACE_USR4((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMVRSession::vHandleEventInWaitForStopVR"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInWaitForStartVR
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
void fc_phone_tclSMVRSession::vHandleEventInWaitForStartVR(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleEventInWaitForStartVR : %d", u16EventId));

   switch ( u16EventId )
   {
      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_ACTIVATION_ACK_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_ACTIVATION_ACK_OK"));

         m_u16SubState = FC_PHONE_VR_STATE_GET_REQUEST;
         ETG_TRACE_USR3(("State change: FC_PHONE_VR_STATE_GET_REQUEST"));

         if (TRUE == m_bBTVRProcessingRelease)
         {
            ETG_TRACE_USR3(("DEACTIVATION request was received. Hence handling it here."));

            m_bBTVRProcessingRelease = FALSE;
            vProcessEvent(FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_INACTIVE);
         }

         vHandleVoiceRecActivated();
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_INACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_INACTIVE"));

         // This event will be handled on receiving ACTIVATION ack.
         // The "m_bBTVRProcessingRelease" is set so that DEACTIVATION request is not handled.
         m_bBTVRProcessingRelease = TRUE;
         ETG_TRACE_USR4((" m_bBTVRProcessingRelease %d ",m_bBTVRProcessingRelease));
      }
      break;

      default:
         ETG_TRACE_USR4((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMVRSession::vHandleEventInWaitForStartVR"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInActiveState
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
void fc_phone_tclSMVRSession::vHandleEventInActiveState(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleEventInActiveState : %u", u16EventId));

   switch ( m_u16SubState )
   {
      case FC_PHONE_VR_STATE_GET_REQUEST:
      {
         ETG_TRACE_USR2(("FC_PHONE_VR_STATE_GET_REQUEST"));
         vHandleEventInGetRequest(u16EventId);
      }
      break;

      case FC_PHONE_VR_STATE_RELEASE_REQUEST:
      {
         ETG_TRACE_USR2(("FC_PHONE_VR_STATE_RELEASE_REQUEST"));
         vHandleEventInReleaseRequest(u16EventId);
      }
      break;

      case FC_PHONE_VR_STATE_WAITFOR_STOPVR_FROMBT:
      {
         ETG_TRACE_USR2(("FC_PHONE_VR_STATE_WAITFOR_STOPVR_FROMBT"));
         vHandleEventInWaitForStopVR(u16EventId);
      }
      break;

      case FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT:
      {
         ETG_TRACE_USR2(("FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT"));
         vHandleEventInWaitForStartVR(u16EventId);
      }
      break;

      default:
         ETG_TRACE_USR4((" default %u", m_u16SubState));
         break;
   }

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACTIVATION_ACK_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACTIVATION_ACK_OK"));
         vHandleVoiceRecDeActivated();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACT_INCOMINGCALL:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACT_INCOMINGCALL"));
         vEndVoiceSesion();
      }
      break;
      case FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_INACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_INACTIVE"));
         //gmmy15-9420  - to avoid posting multiple deactivate (AT+BVRA=0) to phone device.
         ETG_TRACE_USR4((" m_bBTVRProcessingRelease %d ",m_bBTVRProcessingRelease));
         if(TRUE != m_bBTVRProcessingRelease)
         {
            vHandleVoiceRecInActive();
            m_bBTVRProcessingRelease = TRUE;
            ETG_TRACE_USR4((" m_bBTVRProcessingRelease %d ",m_bBTVRProcessingRelease));
         }
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_ACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_ACTIVE"));

         // Fixed as a part of NCG3D-79618.
         // The VR activation request is posted to the BT Stack when the VR session is already ACTIVE.
         vSendActivateVoiceRecognition();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACTIVATION_IND:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACTIVATION_IND"));
         if (FC_PHONE_VR_STATE_WAITFOR_STOPVR_FROMBT != m_u16SubState)
         {
            vHandleVoiceRecDeActivationInd();
         }
      }
      break;

      case FC_PHONE_SM_EVENT_SA_OFF:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SA_OFF"));
         ETG_TRACE_USR4((" m_bBTVRProcessingRelease %d ",m_bBTVRProcessingRelease));
         //gmmy15-9420  - to avoid posting multiple deactivate (AT+BVRA=0) to phone device.
         if(TRUE != m_bBTVRProcessingRelease)
         {
            vHandleVoiceRecInActive();
            m_bBTVRProcessingRelease = TRUE;
            ETG_TRACE_USR4((" m_bBTVRProcessingRelease %d ",m_bBTVRProcessingRelease));
         }
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_ACTIVE_FOR_PASSIVE_DEVICE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_ACTIVE_FOR_PASSIVE_DEVICE"));
         //RTC-295743 : During Switch Device for VR, if the VR activation received for the passive device before
         //processing the VR deactivation of active device, FC_Phone would wait untill the completion of the deactivation.
         if (FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT  != m_u16SubState)
         {
            fc_phone_tclService_Telephone *poTelService = NULLPTR;
            poTelService = fc_phone_tclService_Telephone::pGetInstance();
            if (poTelService)
            {
               m_poSMManager->vProcessVREvent(FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_INACTIVE);
               m_u16SubState = FC_PHONE_VR_STATE_WAITFOR_STOPVR_FROMBT;
            }
         }
         else
         {
            // Sending error response since the EVENT cannot be handled in this Sub-state.
            vSendErrorCode(FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED);
         }
      }
      break;

      default:
         ETG_TRACE_USR4((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMVRSession::vHandleEventInActiveState"));
}


/*******************************************************************************
 *
 * FUNCTION: vHandleSourceActvityOn
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleSourceActvityOn()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleSourceActvityOn"));

   //GMMY15-9208 Check whether the SA_OFF has been called directly. If so we can enable BT_VR now
   if (TRUE == m_bAVinterrupt)
   {
      tBool b_getActiveDeviceAddress = FALSE;
      tU8 u8_Active_BDAddressId=INVALID_BDADDRESS_ID;
      tChar ActiveDeviceAddress[PHONE_BDADRESS_LENGTH]={0};
      b_getActiveDeviceAddress = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone-> \
            b_get_ActiveDevice_AddressId_FromBT(&u8_Active_BDAddressId);

      m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_SPEECH;
      m_u16SubState = FC_PHONE_VR_STATE_GET_REQUEST;
      if (FALSE == b_getActiveDeviceAddress)
      {
         ETG_TRACE_ERR((" INTERNAL ERROR :: ACTIVE DEVICE ADDRESS IS NULL"));
         return ;
      }

      m_u16SubState = FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT;
      ETG_TRACE_USR4(("State change: FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT"));

      ETG_TRACE_USR4((" bActivateVoiceRecognition - Activate"));

      vStringCopy(ActiveDeviceAddress,fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(u8_Active_BDAddressId),PHONE_BDADRESS_LENGTH);
      m_pDbusIf->bActivateVoiceRecognition(ActiveDeviceAddress,FC_PHONE_VOICE_RECOGNITION_ACTIVATE);
   }

   /* Fix for PSARCC21-3356
    * LC_Speech channel got allocated after Release request is posted from SM_SMVRSession.
    * Hence the state of SMVR State machine should not be changed to ACTIVE for this SA_ON
    * and should be retained as IDLE state itself for processing the further VR requests.
    */
   else if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_u16AudioChannel)
   {
      ETG_TRACE_USR2((" LC_Speech channel got allocated after Release request is posted from SM_SMVRSession. Hence returning back."));
      return;
   }

   else
   {
      m_u16State = STATE_ACTIVE;
      ETG_TRACE_USR2((" State Change: STATE_ACTIVE"));
   }

#ifdef PHONE_SIRI
   tU8 u8ActiveBDAddressId = INVALID_BDADDRESS_ID;
   tBool bGetActiveDeviceAddress = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->b_get_ActiveDevice_AddressId_FromBT(&u8ActiveBDAddressId);
   if (FALSE == bGetActiveDeviceAddress)
   {
      ETG_TRACE_ERR((" ACTIVE DEVICE ADDRESS IS NULL"));
      return;
   }

   (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_oSiriData[u8ActiveBDAddressId].vSetSiriState(ACTIVE);
   ETG_TRACE_USR2(("SiriState Change: ACTIVE"));
#endif //SIRI_FEATURE_ENABLE
}

/*******************************************************************************
 *
 * FUNCTION: vHandleSourceActvityOff
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleSourceActvityOff()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleSourceActvityOff"));
   bActivationFromDevice = FALSE;
   if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_u16AudioChannel)
   {
      m_bAVinterrupt = TRUE; //GMMY15-9208 Set the boolean to TRUE if SA_OFF is directly called
      m_poSMManager->vProcessVREvent(FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_INACTIVE);
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleVoiceRecActive
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleVoiceRecActive()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleVoiceRecActive"));

   /*
    * Set the IAVConnection::BaseVoiceMode to VOICE_MODE_ON
    * in order to obtain audio silence during the voice recognition
    * session.
    */
   /*
    * setting  of IAVConnection::BaseVoiceMode to VOICE_MODE_ON - IS REMOVED for  GMMY15-11687 - CRQ
    */
   /*
    * User starts voice session from Vehicle
    * Request for speech channel
    */
   m_u16SubState = FC_PHONE_VR_STATE_GET_REQUEST;
   if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_u16AudioChannel)
   {
      if(TRUE==m_bAVinterrupt)
         m_poAudioManager->s32SyncAudioMangerOnChannelRelease(FC_PHONE_AUDIOCHANNEL_REQUESTOR_VOICE_REC,FC_PHONE_AUDIOCHANNEL_SPEECH);
      m_bAVinterrupt = FALSE; //GMMY15-9208 Reset the variable if a new channel is to be acquired
      m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_SPEECH;
      ETG_TRACE_USR3((" Requesting Audio ..AudioChannel = FC_PHONE_AUDIOCHANNEL_SPEECH "));
      m_poAudioManager->s32GetRequest(FC_PHONE_AUDIOCHANNEL_REQUESTOR_VOICE_REC,
            FC_PHONE_AUDIOCHANNEL_SPEECH,
            vAudioCallBackVR);
   }
   else if(FC_PHONE_AUDIOCHANNEL_SPEECH == m_u16AudioChannel)
   {
      // Channel is aleardy acquired
      //gmmy15-10110 - when siri session retriggered while channel aqusition is in process.
      if((fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->u8SpeechChannelStatus() == EN_SPEECH_CHNL_ACTIVE )
      {
         ETG_TRACE_USR4((" already speech channel  acquired"));
         m_poSMManager->vProcessVREvent(FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK);
      }
      else
         ETG_TRACE_USR4((" already speech channel aqusition is in process"));

   }
   else
   {
      //Error
      ETG_TRACE_USR4((" vHandleVoiceRecActive::wrong Audio Channel Value %d",m_u16AudioChannel));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleVoiceRecInActive
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleVoiceRecInActive()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleVoiceRecInActive"));

   /*
    * User ends voice session from Vehicle
    * Now send deactivate command to Alps
    */
   tBool b_getActiveDeviceAddress = FALSE;
   tU8  u8_Active_BDAddressId=INVALID_BDADDRESS_ID;
   tChar ActiveDeviceAddress[PHONE_BDADRESS_LENGTH] = {0};

   b_getActiveDeviceAddress = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->b_get_ActiveDevice_AddressId_FromBT(&u8_Active_BDAddressId);

   if (FALSE == b_getActiveDeviceAddress)
   {
      ETG_TRACE_ERR((" INTERNAL ERROR :: ACTIVE DEVICE ADDRESS IS NULL"));
      return ;
   }
   vStringCopy(ActiveDeviceAddress,fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(u8_Active_BDAddressId),PHONE_BDADRESS_LENGTH);
   m_pDbusIf->bActivateVoiceRecognition(ActiveDeviceAddress,FC_PHONE_VOICE_RECOGNITION_DEACTIVATE);

}

/*******************************************************************************
 *
 * FUNCTION: vHandleSpeechGetRequestOk
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleSpeechGetRequestOk()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleSpeechGetRequestOk"));

   /*
    * Speech channel granted
    *  sending  AT+BVRA=1 to phone device
    */

   /*
    * Set state to Active
    */

   if (FALSE == bActivationFromDevice && m_bAVinterrupt == FALSE)
   {
      vSendActivateVoiceRecognition();
   }

   else //TRUE == bActivationFromDevice
   {
      m_bAVinterrupt = FALSE;
      vHandleVoiceRecActivated();
   }

   m_u16State = STATE_ACTIVE;
   ETG_TRACE_USR2((" State Change: STATE_ACTIVE"));

#ifdef PHONE_SIRI
   tU8 u8ActiveBDAddressId = INVALID_BDADDRESS_ID;
   tBool bGetActiveDeviceAddress = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->b_get_ActiveDevice_AddressId_FromBT(&u8ActiveBDAddressId);
   if (FALSE == bGetActiveDeviceAddress)
   {
      ETG_TRACE_ERR((" ACTIVE DEVICE ADDRESS IS NULL"));
      return;
   }

   (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_oSiriData[u8ActiveBDAddressId].vSetSiriState(ACTIVE);
   ETG_TRACE_USR2((" SiriState  Change: ACTIVE"));
#endif //SIRI_FEATURE_ENABLE
}


/*******************************************************************************
 *
 * FUNCTION: vSendActivateVoiceRecognition
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vSendActivateVoiceRecognition()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vSendActivateVoiceRecognition"));
   /*
    * Start streaming
    * Now send AT+BVRA=1 to alps
    */

   tBool b_getActiveDeviceAddress = FALSE;
   tU8 u8_Active_BDAddressId=INVALID_BDADDRESS_ID;
   tChar ActiveDeviceAddress[PHONE_BDADRESS_LENGTH]={0};
   b_getActiveDeviceAddress = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone-> \
         b_get_ActiveDevice_AddressId_FromBT(&u8_Active_BDAddressId);

   if (FALSE == b_getActiveDeviceAddress)
   {
      ETG_TRACE_ERR((" INTERNAL ERROR :: ACTIVE DEVICE ADDRESS IS NULL"));
      return ;
   }

   m_u16SubState = FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT;
   ETG_TRACE_USR4(("State change: FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT"));

   ETG_TRACE_USR4((" bActivateVoiceRecognition - Activate"));

   vStringCopy(ActiveDeviceAddress,fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(u8_Active_BDAddressId),PHONE_BDADRESS_LENGTH);
   m_pDbusIf->bActivateVoiceRecognition(ActiveDeviceAddress,FC_PHONE_VOICE_RECOGNITION_ACTIVATE);
}


/*******************************************************************************
 *
 * FUNCTION: vHandleSpeechRequestNOk
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleSpeechGetRequestNOk()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleSpeechGetRequestNOk"));

   /*
    * Speech channel not granted. It could be getrequest or release
    * request failed.
    */

   /*
    * sends the BTDeviceVoiceRecognition.Status(BTDeviceVoiceRecActive, BTDeviceVoiceRecSupported)
    * notification with BTDeviceVoiceRecActive = BT_VR_ACTIVE and BTDeviceVoiceRecSupported = BT_DEVICE_VR_SUPPORTED.
    */
   tBool b_getActiveDeviceAddress = FALSE;
   tU8 u8_Active_BDAddressId=INVALID_BDADDRESS_ID;
   tChar ActiveDeviceAddress[PHONE_BDADRESS_LENGTH]={0};
   b_getActiveDeviceAddress = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone-> \
         b_get_ActiveDevice_AddressId_FromBT(&u8_Active_BDAddressId);

   m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
   FCPhone_VRData ptProcessEventArg;
   ptProcessEventArg.bBTDeviceVoiceRecActive = FC_PHONE_BT_VR_INACTIVE;
   ptProcessEventArg.bBTDeviceVoiceRecSupported = FC_PHONE_BT_DEVICE_VR_SUPPORTED;
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_BT_VOICERECOGNITION, &ptProcessEventArg);

   /*
    * Set state to Idle
    */
   m_u16State = STATE_IDLE;

   if (FALSE == b_getActiveDeviceAddress)
   {
      ETG_TRACE_ERR((" INTERNAL ERROR :: ACTIVE DEVICE ADDRESS IS NULL"));
      return ;
   }

#ifdef PHONE_SIRI
   (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_oSiriData[u8_Active_BDAddressId].vSetSiriState(IDLE);
   ETG_TRACE_USR2((" SiriState  Change: IDLE "));
#endif //SIRI_FEATURE_ENABLE

   ETG_TRACE_USR4((" bAudioTransfer - FROMHANSFREE_TOHANDSET "));

   vStringCopy(ActiveDeviceAddress,fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(u8_Active_BDAddressId),PHONE_BDADRESS_LENGTH);
   m_pDbusIf->bAudioTransfer(ActiveDeviceAddress,FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
}

/*******************************************************************************
 *
 * FUNCTION: vHandleSpeechReleaseRequestOk
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleSpeechReleaseRequestOk()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleSpeechReleaseRequestOk"));

   /*
    * Speech channel released
    */

   /*
    * Set state to Idle
    */
   m_u16State = STATE_IDLE;
   ETG_TRACE_USR2((" State Change: STATE_IDLE"));

#ifdef PHONE_SIRI
   tU8 u8ActiveBDAddressId = INVALID_BDADDRESS_ID;
   tBool bGetActiveDeviceAddress = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->b_get_ActiveDevice_AddressId_FromBT(&u8ActiveBDAddressId);
   if (FALSE == bGetActiveDeviceAddress)
   {
      ETG_TRACE_ERR((" ACTIVE DEVICE ADDRESS IS NULL"));
      return;
   }

   (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_oSiriData[u8ActiveBDAddressId].vSetSiriState(IDLE);
   ETG_TRACE_USR2((" SiriState  Change: IDLE "));
#endif //SIRI_FEATURE_ENABLE

}

/*******************************************************************************
 *
 * FUNCTION: vHandleSpeechRequestNOk
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleSpeechReleaseRequestNOk()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleSpeechReleaseRequestNOk"));

   /*
    * Speech channel not released.
    */

   /*
    * sends the BTDeviceVoiceRecognition.Status(BTDeviceVoiceRecActive, BTDeviceVoiceRecSupported)
    * notification with BTDeviceVoiceRecActive = BT_VR_ACTIVE and BTDeviceVoiceRecSupported = BT_DEVICE_VR_SUPPORTED.
    */

   m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_SPEECH;
   FCPhone_VRData ptProcessEventArg;
   ptProcessEventArg.bBTDeviceVoiceRecActive = FC_PHONE_BT_VR_INACTIVE;
   ptProcessEventArg.bBTDeviceVoiceRecSupported = FC_PHONE_BT_DEVICE_VR_SUPPORTED;
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_BT_VOICERECOGNITION, &ptProcessEventArg);
}


/*******************************************************************************
 *
 * FUNCTION: vUpdateVRstatusInactive
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vUpdateVRstatusInactive()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vUpdateVRstatusInactive"));

   /*
    * Speech channel not released.
    */

   /*
    * sends the BTDeviceVoiceRecognition.Status(BTDeviceVoiceRecActive, BTDeviceVoiceRecSupported)
    * as INACTIVE when callstatus is received on initiating call from HMI.
    */

   /*
    * Resetting  of IAVConnection::BaseVoiceMode to VOICE_MODE_OFF - IS REMOVED for  GMMY15-11687 - CRQ
    */

   FCPhone_VRData ptProcessEventArg;
   ptProcessEventArg.bBTDeviceVoiceRecActive = FC_PHONE_BT_VR_INACTIVE;
   ptProcessEventArg.bBTDeviceVoiceRecSupported = FC_PHONE_BT_DEVICE_VR_SUPPORTED;
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_BT_VOICERECOGNITION, &ptProcessEventArg);

}

/*******************************************************************************
 *
 * FUNCTION: vHandleVoiceRecActivated
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleVoiceRecActivated()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleVoiceRecActivated"));

   /*
    * sends the BTDeviceVoiceRecognition.Status(BTDeviceVoiceRecActive, BTDeviceVoiceRecSupported)
    * notification with BTDeviceVoiceRecActive = BT_VR_ACTIVE and BTDeviceVoiceRecSupported = BT_DEVICE_VR_SUPPORTED.
    */
   FCPhone_VRData ptProcessEventArg;
   ptProcessEventArg.bBTDeviceVoiceRecActive = FC_PHONE_BT_VR_ACTIVE;
   ptProcessEventArg.bBTDeviceVoiceRecSupported = FC_PHONE_BT_DEVICE_VR_SUPPORTED;
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_BT_VOICERECOGNITION, &ptProcessEventArg);
}

/*******************************************************************************
 *
 * FUNCTION: vHandleVoiceRecDeActivated
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleVoiceRecDeActivated()
{    
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleVoiceRecDeActivated"));

   /*
    * Bluetooth voice recognition session is ended from the HMI.
    */

   vEndVoiceSesion();

}

/*******************************************************************************
 *
 * FUNCTION: vHandleVoiceRecActivationInd
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleVoiceRecActivationInd()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleVoiceRecActivationInd"));

   /*
    * User starts voice session from Vehicle
    * Request for speech channel
    */
   ETG_TRACE_USR4((" vHandleVoiceRecActivationInd::m_bExtendVRSessionTimerRunning = %d",m_bExtendVRSessionTimerRunning));
   if(m_bExtendVRSessionTimerRunning == TRUE)
   {
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(m_u16TimerId);
      m_bExtendVRSessionTimerRunning = FALSE;
   }


   bActivationFromDevice = TRUE;

   vHandleVoiceRecActive();
}

/*******************************************************************************
 *
 * FUNCTION: vHandleVoiceRecDeActivationInd
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleVoiceRecDeActivationInd()
{    
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vHandleVoiceRecDeActivationInd"));

   /*
    * Bluetooth voice recognition session is ended from the phone on its own or
    * based on the user selecting to end the voice recognition session the
    * Bluetooth device sends the Bluetooth HFP +BVRA:0 command.
    */

// CMG3G-7982- Extend VR session
#ifdef EXTEND_VR_SESSION
   fc_phone_tclClientHandler_MediaPlayer *p_clientHndler_mediaplayer = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerMediaPlayer;

   // If the AutoPlay status is received before the HfVoiceRecDeactivationInd (OR)
   // If any of the call is not IDLE, End the voice session immediately-> Concept changed. See below comments

   //Fix for PSARCCB-5362. The voice session should not be ended immediately if any of the call is not IDLE.
   //Instead it is started by default and should be ended on establishment of the SCO channel or on receiving call status.
   if((p_clientHndler_mediaplayer && (p_clientHndler_mediaplayer->vGetMediaPlayingStatus())) || (TRUE == m_bAVinterrupt))
   {
#endif //EXTENDVRSESSION

      vEndVoiceSesion();

// CMG3G-7982- Extend VR session
#ifdef EXTEND_VR_SESSION
   }
   else
   {
      /*
       *If the AutoPlay status is not received from BT-Settings hold the
       *VR channel based on the project specific configuration
       */
      m_u16TimerId = FC_PHONE_EXTEND_VR_SESSION_TIMER_ID;
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Start(m_u16TimerId, FC_PHONE_EXTEND_VR_SESSION_TIMEOUT_DURATION, vExtendVRSessionTimerCallBack);
      m_bExtendVRSessionTimerRunning = TRUE;
      ETG_TRACE_USR3((" m_bExtendVRSessionTimerRunning = TRUE "));

      // Set state to idle.
      // The state is set to not disturb the existing flow
      m_u16State = STATE_IDLE;
      ETG_TRACE_USR2((" State Change: STATE_IDLE"));

   }
#endif //EXTENDVRSESSION
}

/*******************************************************************************
 *
 * FUNCTION: vEndVoiceSesion
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vEndVoiceSesion(bool bDeviceDisconnected)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vEndVoiceSesion"));

   /*
    * Release the speech channel
    */

   if(FC_PHONE_AUDIOCHANNEL_SPEECH == m_u16AudioChannel)
   {
      ETG_TRACE_USR4(("Voice session ended - Release speech channel"));

      m_u16SubState = FC_PHONE_VR_STATE_RELEASE_REQUEST;
      ETG_TRACE_USR2((" State Change: SubState = FC_PHONE_VR_STATE_RELEASE_REQUEST "));
      /*
       * Set the IAVConnection::BaseVoiceMode to VOICE_MODE_OFF
       */

      /*
       * Resetting  of IAVConnection::BaseVoiceMode to VOICE_MODE_OFF - IS REMOVED for  GMMY15-11687 - CRQ
       */
      m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
      /*
       * Voice Session ended
       * Release speech channel
       */
      if (FALSE == m_bAVinterrupt)
      {
         ETG_TRACE_USR3((" Releasing Audio ..AudioChannel - FC_PHONE_AUDIOCHANNEL_SPEECH"));
         m_poAudioManager->s32ReleaseRequest(FC_PHONE_AUDIOCHANNEL_REQUESTOR_VOICE_REC,
               FC_PHONE_AUDIOCHANNEL_SPEECH,
               vAudioCallBackVR);
      }
      /*
       * sends the BTDeviceVoiceRecognition.Status(BTDeviceVoiceRecActive, BTDeviceVoiceRecSupported)
       * notification with BTDeviceVoiceRecActive = BT_VR_INACTIVE and BTDeviceVoiceRecSupported = BT_DEVICE_VR_SUPPORTED.
       */
      FCPhone_VRData ptProcessEventArg;
      ptProcessEventArg.bBTDeviceVoiceRecActive = FC_PHONE_BT_VR_INACTIVE;
      //GMMY15-62 Bluetooth Speech Recognition shown as available after walking phone out of range during BTSR session.
      //ptProcessEventArg.bBTDeviceVoiceRecSupported = FC_PHONE_BT_DEVICE_VR_SUPPORTED;
      ptProcessEventArg.bBTDeviceVoiceRecSupported = (bDeviceDisconnected == true)?FC_PHONE_BT_DEVICE_VR_NOT_SUPPORTED:FC_PHONE_BT_DEVICE_VR_SUPPORTED;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_BT_VOICERECOGNITION, &ptProcessEventArg);

   }

   /*
    * Set state to idle
    */
   m_u16State = STATE_IDLE;
   ETG_TRACE_USR2((" State Change: STATE_IDLE"));

#ifdef PHONE_SIRI
   tU8 u8ActiveBDAddressId = INVALID_BDADDRESS_ID;
   tBool bGetActiveDeviceAddress = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->b_get_ActiveDevice_AddressId_FromBT(&u8ActiveBDAddressId);
   if (FALSE == bGetActiveDeviceAddress)
   {
      ETG_TRACE_ERR((" ACTIVE DEVICE ADDRESS IS NULL"));
      return;
   }

   (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_oSiriData[u8ActiveBDAddressId].vSetSiriState(IDLE);
   ETG_TRACE_USR2((" SiriState Change: IDLE"));
#endif //SIRI_FEATURE_ENABLE

   m_bBTVRProcessingRelease = FALSE;
   bActivationFromDevice = FALSE;
}

/*******************************************************************************
 *
 * FUNCTION: vHandleDbusError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vHandleDbusError(tU16 u16DbusAckType,tChar Code)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMVRSession::vHandleDbusError "));

   switch(u16DbusAckType)
   {
      case FC_PHONE_CB_FID_VOICERECOGNITION_CFM :
      {
         ETG_TRACE_USR1((" FC_PHONE_CB_FID_VOICERECOGNITION_CFM"));
         vSendErrorCode(Code);
      }
      break;

      default:
      {
         ETG_TRACE_USR1((" This Event ID is not supported yet"));
      }
      break;
   }
   ETG_TRACE_USR4((" EXIT:fc_phone_tclSMVRSession::vHandleDbusError "));
}

/*******************************************************************************
 *
 * FUNCTION: vSendErrorCode
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vSendErrorCode(tChar Code)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::vSendErrorCode"));

   switch(Code)
   {
      case FC_PHONE_DBUS_ERRORCODE_STATE_ERROR:
      {
         ETG_TRACE_USR3((" FC_PHONE_DBUS_ERRORCODE_STATE_ERROR"));
         FCPhone_VRData ptProcessEventArg;
         ptProcessEventArg.u8ErrorAck = FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR;
         m_poSMManager->vSendError(FC_PHONE_SMMANAGER_ERROR_BT_VOICERECOGNITION, &ptProcessEventArg);
      }
      break;

      case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:
      case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:
      {
         ETG_TRACE_USR3((" FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:: FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED"));
         FCPhone_VRData ptProcessEventArg;
         ptProcessEventArg.u8ErrorAck = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
         m_poSMManager->vSendError(FC_PHONE_SMMANAGER_ERROR_BT_VOICERECOGNITION, &ptProcessEventArg);
      }
      break;

      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT This Error Code [0x%x] is not supported yet",Code) );

         FCPhone_VRData ptProcessEventArg;
         ptProcessEventArg.u8ErrorAck = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendError(FC_PHONE_SMMANAGER_ERROR_BT_VOICERECOGNITION, &ptProcessEventArg);
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventSLCOFF
 *
 * DESCRIPTION: HFP SLC is gone . Hence clean up.
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMVRSession::bHandleEventSLCOFF(tVoid *varg)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::bHandleEventSLCOFF"));
     (tVoid) varg;
   //tU8* pu8BDAddress = NULL;
   //pu8BDAddress    = (tU8*)varg;
   // TBD : Check if it is for the same device
   if(STATE_ACTIVE == m_u16State)
   {
      //GMMY15-62 Bluetooth Speech Recognition shown as available after walking phone out of range during BTSR session.
      vEndVoiceSesion(true);
   }

   return(TRUE);

}

/*******************************************************************************
 *
 * FUNCTION: u16GetVRSessionState
 *
 * DESCRIPTION: Get VR Session State
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tU16 fc_phone_tclSMVRSession::u16GetVRSessionState()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMVRSession::u16GetVRSessionState and m_u16State : %d", m_u16State));

   return m_u16State;
}

/*******************************************************************************
 *
 * FUNCTION: bIsVRSessionRunning
 *
 * DESCRIPTION: To get the actual running Status of the VR session
 *
 * PARAMETER:
 *
 * RETURNVALUE:   TRUE - if VR session is started in the HMI, else FALSE
 *
 ********************************************************************************/
tBool fc_phone_tclSMVRSession::bIsVRSessionRunning()
{
   ETG_TRACE_USR4(("ENTER : fc_phone_tclSMVRSession::bIsVRSessionRunning"));

   ETG_TRACE_USR4(("m_u16State: %u and m_u16SubState: %u", m_u16State, m_u16SubState));

   if (STATE_ACTIVE == m_u16State)
   {
      // Only two sub-states to be checked here
      if ((FC_PHONE_VR_STATE_WAITFOR_STOPVR_FROMBT == m_u16SubState) || (FC_PHONE_VR_STATE_GET_REQUEST == m_u16SubState))
      {
         return TRUE;
      }
   }
   return FALSE;
}

/*******************************************************************************
 *
 * FUNCTION: bIsVRActivationRequestPendingFromBTStack
 *
 * DESCRIPTION: To get the actual running Status of the VR session
 *
 * PARAMETER:
 *
 * RETURNVALUE:   TRUE - if VR_SM is waiting for response from the BT-Stack for VR ACTIVATION, else FALSE
 *
 ********************************************************************************/
tBool fc_phone_tclSMVRSession::bIsVRActivationRequestPendingFromBTStack()
{
   ETG_TRACE_USR4(("ENTER : fc_phone_tclSMVRSession::bIsVRActivationRequestPendingFromBTStack"));

   ETG_TRACE_USR4(("m_u16State: %u and m_u16SubState: %u", m_u16State, m_u16SubState));

   if (FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT == m_u16SubState)
   {
      return TRUE;
   }

   return FALSE;
}

/*******************************************************************************
 *
 * FUNCTION: vSendBtVRStatus
 *
 * DESCRIPTION: Sends BTDeviceVoiceRecognition status
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vSendBtVRStatus()
{
   ETG_TRACE_USR4(("ENTER : fc_phone_tclSMVRSession::vSendBtVRStatus"));

   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      LoopBackData LB_data;
      LB_data.u16FunctionID = FC_PHONE_CB_FID_VOICERECOGNITION_STATUS;
      poTelService->push_back_LB_data(LB_data);
      ETG_TRACE_USR4(("FC_PHONE_CB_FID_VOICERECOGNITION_STATUS"));
      poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_VOICERECOGNITION_STATUS);
   }
   else
   {
      ETG_TRACE_USR4(("poTelService is NULL"));
   }
}

// CMG3G-7982- Extend VR session
/*******************************************************************************
 *
 * FUNCTION: vExtendVRSessionTimerCallBack
 *
 * DESCRIPTION: Timer callback on expiry of the ExtendedVRSession Timer
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid vExtendVRSessionTimerCallBack(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("ENTER vExtendVRSessionTimerCallBack"));
   fc_phone_tclSMVRSession *poVRInstance = fc_phone_tclSMVRSession::poGetInstance();
   poVRInstance->vTimerCallBack(u16TimerId);
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMVRSession::vTimerCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vTimerCallBack(tU16 u16TimerId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMVRSession::vTimerCallBack with TimerID %d",u16TimerId));
   if (FC_PHONE_EXTEND_VR_SESSION_TIMER_ID == u16TimerId)
   {
      vStopExtendedVRSession();
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMVRSession::vStopExtendedVRSession
 *
 * DESCRIPTION: This function is used to Stop the ExtendVRSession Timer 
 * and End Voice Session
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vStopExtendedVRSession()
{
   ETG_TRACE_USR4((" fc_phone_tclSMVRSession::vStopExtendedVRSession "));
   if(m_bExtendVRSessionTimerRunning)
   {
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(m_u16TimerId);
      m_bExtendVRSessionTimerRunning = FALSE;

      vEndVoiceSesion();
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMVRSession::bIsExtendVRSessionTimerRunning
 *
 * DESCRIPTION: Returns the status of the boolean variable m_bExtendVRSessionTimerRunning
 *
 * PARAMETER:
 *
 * RETURNVALUE: Boolean. TRUE- ExtendVRSessionTimer is Running
 *                       FALSE- ExtendVRSessionTimer is not Running
 *
 ********************************************************************************/
tBool fc_phone_tclSMVRSession::bIsExtendVRSessionTimerRunning()
{
   ETG_TRACE_USR3((" bIsExtendVRSessionTimerRunning: m_bExtendVRSessionTimerRunning = %d", m_bExtendVRSessionTimerRunning));
   return m_bExtendVRSessionTimerRunning;
}

/*******************************************************************************
 *
 * FUNCTION: vProcessVRRequestForOtherDevice
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 ********************************************************************************/
tVoid fc_phone_tclSMVRSession::vProcessVRRequestForOtherDevice()
{
   ETG_TRACE_USR3((" vProcessVRRequestForOtherDevice Entered "));

#ifdef PHONE_SIRI
   tU8 u8ActiveDevHandle = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->u8GetActiveDeviceHandle();
   tU8 u8BDAddressId =(tU8)(fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings->u8GetBTAddressIdFromDeviceHandle(u8ActiveDevHandle);
   ETG_TRACE_USR3(("u8BDAddressId: %d", u8BDAddressId));

   if (INVALID_BDADDRESS_ID != u8BDAddressId)
   {
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_oSiriData[u8BDAddressId].vSetSiriState(IDLE);
      ETG_TRACE_USR2((" SiriState  Change: IDLE "));
   }
#endif

   vUpdateVRstatusInactive();


   bActivationFromDevice = false;
   m_u8VRRelStatus = EN_VR_IDLE;

   m_u16State = STATE_IDLE;
   // NCG3D-85047
   // The sub state is updated as "FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT" untill the switch device is performed.
   m_u16SubState = FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT;

   m_bBTVRProcessingRelease = FALSE;

   fc_phone_tclService_Telephone *poTelService = fc_phone_tclService_Telephone::pGetInstance();
   NULL_CHECK(poTelService)
   poTelService->vSwitchActivePassiveFromVR();
   // NCG3D-85047
   // Once when the switch device is triggered, the sub state is updated back to "FC_PHONE_VR_STATE_GET_REQUEST" .
   // Hence the next VR session would process fresh.
   m_u16SubState = FC_PHONE_VR_STATE_GET_REQUEST;
   if (m_bAVinterrupt)
   {
      ETG_TRACE_USR3(("SA OFF is received by EXT trigger and the Release request is in progress for the previous ACTIVE device"));
      m_bAVinterrupt = false;
      vProcessEvent(FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_ACTIVE);
   }
   else
   {
      ETG_TRACE_USR3(("Channel already available, hence continuing the speech request received "));
   vProcessEvent(FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK);
   }
}
